/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.ArrayWrappers;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.KVTypeInfo;
import org.sparkproject.guava.base.Objects;
import org.sparkproject.guava.base.Preconditions;

@Private
public class InMemoryStore
implements KVStore {
    private Object metadata;
    private InMemoryLists inMemoryLists = new InMemoryLists();

    @Override
    public <T> T getMetadata(Class<T> klass) {
        return klass.cast(this.metadata);
    }

    @Override
    public void setMetadata(Object value) {
        this.metadata = value;
    }

    @Override
    public long count(Class<?> type) {
        InstanceList<?> list = this.inMemoryLists.get(type);
        return list != null ? (long)list.size() : 0L;
    }

    @Override
    public long count(Class<?> type, String index, Object indexedValue) throws Exception {
        InstanceList<?> list = this.inMemoryLists.get(type);
        int count = 0;
        Comparable<Object> comparable = InMemoryStore.asKey(indexedValue);
        KVTypeInfo.Accessor accessor = list.getIndexAccessor(index);
        for (Object o : this.view(type)) {
            if (!Objects.equal(comparable, InMemoryStore.asKey(accessor.get(o)))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public <T> T read(Class<T> klass, Object naturalKey) {
        T value;
        InstanceList<T> list = this.inMemoryLists.get(klass);
        T t = value = list != null ? (T)list.get(naturalKey) : null;
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public void write(Object value) throws Exception {
        this.inMemoryLists.write(value);
    }

    @Override
    public void delete(Class<?> type, Object naturalKey) {
        InstanceList<?> list = this.inMemoryLists.get(type);
        if (list != null) {
            list.delete(naturalKey);
        }
    }

    @Override
    public <T> KVStoreView<T> view(Class<T> type) {
        InstanceList<T> list = this.inMemoryLists.get(type);
        return list != null ? list.view() : InMemoryStore.emptyView();
    }

    @Override
    public void close() {
        this.metadata = null;
        this.inMemoryLists.clear();
    }

    @Override
    public <T> boolean removeAllByIndexValues(Class<T> klass, String index, Collection<?> indexValues) {
        InstanceList<T> list = this.inMemoryLists.get(klass);
        if (list != null) {
            return list.countingRemoveAllByIndexValues(index, indexValues) > 0;
        }
        return false;
    }

    private static Comparable<Object> asKey(Object in) {
        if (in.getClass().isArray()) {
            in = ArrayWrappers.forArray(in);
        }
        return in;
    }

    private static <T> KVStoreView<T> emptyView() {
        return InMemoryView.EMPTY_VIEW;
    }

    private static class InMemoryIterator<T>
    implements KVStoreIterator<T> {
        private final Iterator<T> iter;

        InMemoryIterator(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> next(int max) {
            ArrayList<T> list = new ArrayList<T>(max);
            while (this.hasNext() && list.size() < max) {
                list.add(this.next());
            }
            return list;
        }

        @Override
        public boolean skip(long n) {
            for (long skipped = 0L; skipped < n; ++skipped) {
                if (this.hasNext()) {
                    this.next();
                    continue;
                }
                return false;
            }
            return this.hasNext();
        }

        @Override
        public void close() {
        }
    }

    private static class InMemoryView<T>
    extends KVStoreView<T> {
        private static final InMemoryView<?> EMPTY_VIEW = new InMemoryView(new ConcurrentHashMap(), null, "", new ConcurrentHashMap<Comparable<Object>, NaturalKeys>());
        private final ConcurrentMap<Comparable<Object>, T> data;
        private final KVTypeInfo ti;
        private final KVTypeInfo.Accessor natural;
        private final ConcurrentMap<Comparable<Object>, NaturalKeys> parentToChildrenMap;
        private final String naturalParentIndexName;
        private final Boolean hasNaturalParentIndex;

        InMemoryView(ConcurrentMap<Comparable<Object>, T> data, KVTypeInfo ti, String naturalParentIndexName, ConcurrentMap<Comparable<Object>, NaturalKeys> parentToChildrenMap) {
            this.data = data;
            this.ti = ti;
            this.natural = ti != null ? ti.getAccessor("__main__") : null;
            this.naturalParentIndexName = naturalParentIndexName;
            this.parentToChildrenMap = parentToChildrenMap;
            this.hasNaturalParentIndex = !naturalParentIndexName.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            if (this.data.isEmpty()) {
                return new InMemoryIterator(Collections.emptyIterator());
            }
            KVTypeInfo.Accessor getter = this.index != null ? this.ti.getAccessor(this.index) : null;
            int modifier = this.ascending ? 1 : -1;
            List<T> sorted = this.copyElements();
            sorted.sort((e1, e2) -> modifier * this.compare(e1, e2, getter));
            Stream<Object> stream = sorted.stream();
            if (this.first != null) {
                Comparable firstKey = InMemoryStore.asKey(this.first);
                stream = stream.filter(e -> modifier * this.compare(e, getter, firstKey) >= 0);
            }
            if (this.last != null) {
                Comparable lastKey = InMemoryStore.asKey(this.last);
                stream = stream.filter(e -> modifier * this.compare(e, getter, lastKey) <= 0);
            }
            if (this.skip > 0L) {
                stream = stream.skip(this.skip);
            }
            if (this.max < (long)sorted.size()) {
                stream = stream.limit((int)this.max);
            }
            return new InMemoryIterator(stream.iterator());
        }

        private List<T> copyElements() {
            if (this.parent != null) {
                Comparable parentKey = InMemoryStore.asKey(this.parent);
                if (this.hasNaturalParentIndex.booleanValue() && this.naturalParentIndexName.equals(this.ti.getParentIndexName(this.index))) {
                    NaturalKeys children = this.parentToChildrenMap.getOrDefault(parentKey, new NaturalKeys());
                    ArrayList elements = new ArrayList();
                    for (Comparable naturalKey : children.keySet()) {
                        this.data.computeIfPresent(naturalKey, (k, v) -> {
                            elements.add(v);
                            return v;
                        });
                    }
                    return elements;
                }
                KVTypeInfo.Accessor parentGetter = this.ti.getParentAccessor(this.index);
                Preconditions.checkArgument((parentGetter != null ? 1 : 0) != 0, (Object)"Parent filter for non-child index.");
                return this.data.values().stream().filter(e -> this.compare(e, parentGetter, parentKey) == 0).collect(Collectors.toList());
            }
            return new ArrayList(this.data.values());
        }

        private int compare(T e1, T e2, KVTypeInfo.Accessor getter) {
            try {
                int diff = this.compare(e1, getter, InMemoryStore.asKey(getter.get(e2)));
                if (diff == 0 && getter != this.natural) {
                    diff = this.compare(e1, this.natural, InMemoryStore.asKey(this.natural.get(e2)));
                }
                return diff;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private int compare(T e1, KVTypeInfo.Accessor getter, Comparable<?> v2) {
            try {
                return InMemoryStore.asKey(getter.get(e1)).compareTo(v2);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class InstanceList<T> {
        private final KVTypeInfo ti;
        private final KVTypeInfo.Accessor naturalKey;
        private final ConcurrentMap<Comparable<Object>, T> data;
        private final String naturalParentIndexName;
        private final Boolean hasNaturalParentIndex;
        private final ConcurrentMap<Comparable<Object>, NaturalKeys> parentToChildrenMap;

        private InstanceList(Class<?> klass) {
            this.ti = new KVTypeInfo(klass);
            this.naturalKey = this.ti.getAccessor("__main__");
            this.data = new ConcurrentHashMap<Comparable<Object>, T>();
            this.naturalParentIndexName = this.ti.getParentIndexName("__main__");
            this.parentToChildrenMap = new ConcurrentHashMap<Comparable<Object>, NaturalKeys>();
            this.hasNaturalParentIndex = !this.naturalParentIndexName.isEmpty();
        }

        KVTypeInfo.Accessor getIndexAccessor(String indexName) {
            return this.ti.getAccessor(indexName);
        }

        int countingRemoveAllByIndexValues(String index, Collection<?> indexValues) {
            int count = 0;
            if ("__main__".equals(index)) {
                for (Object naturalKey : indexValues) {
                    count += this.delete(InMemoryStore.asKey(naturalKey)) ? 1 : 0;
                }
                return count;
            }
            if (this.hasNaturalParentIndex.booleanValue() && this.naturalParentIndexName.equals(index)) {
                for (Object indexValue : indexValues) {
                    Comparable parentKey = InMemoryStore.asKey(indexValue);
                    NaturalKeys children = this.parentToChildrenMap.getOrDefault(parentKey, new NaturalKeys());
                    for (Comparable naturalKey : children.keySet()) {
                        this.data.remove(naturalKey);
                        ++count;
                    }
                    this.parentToChildrenMap.remove(parentKey);
                }
                return count;
            }
            Predicate<T> filter = InstanceList.getPredicate(this.ti.getAccessor(index), indexValues);
            CountingRemoveIfForEach<T> callback = new CountingRemoveIfForEach<T>(this, filter);
            this.data.forEach(callback);
            return callback.count();
        }

        public T get(Object key) {
            return (T)this.data.get(InMemoryStore.asKey(key));
        }

        public void put(T value) throws Exception {
            this.data.put(InMemoryStore.asKey(this.naturalKey.get(value)), value);
            if (this.hasNaturalParentIndex.booleanValue()) {
                Comparable parentKey = InMemoryStore.asKey(this.getIndexAccessor(this.naturalParentIndexName).get(value));
                NaturalKeys children = this.parentToChildrenMap.computeIfAbsent(parentKey, k -> new NaturalKeys());
                children.put(InMemoryStore.asKey(this.naturalKey.get(value)), true);
            }
        }

        public boolean delete(Object key) {
            boolean entryExists;
            boolean bl = entryExists = this.data.remove(InMemoryStore.asKey(key)) != null;
            if (entryExists) {
                this.deleteParentIndex(key);
            }
            return entryExists;
        }

        public boolean delete(Object key, T value) {
            boolean entryExists = this.data.remove(InMemoryStore.asKey(key), value);
            if (entryExists) {
                this.deleteParentIndex(key);
            }
            return entryExists;
        }

        private void deleteParentIndex(Object key) {
            block1: {
                NaturalKeys v;
                if (!this.hasNaturalParentIndex.booleanValue()) break block1;
                Iterator iterator = this.parentToChildrenMap.values().iterator();
                while (iterator.hasNext() && (v = (NaturalKeys)iterator.next()).remove(InMemoryStore.asKey(key)) == null) {
                }
            }
        }

        public int size() {
            return this.data.size();
        }

        public InMemoryView<T> view() {
            return new InMemoryView<T>(this.data, this.ti, this.naturalParentIndexName, this.parentToChildrenMap);
        }

        private static <T> Predicate<? super T> getPredicate(KVTypeInfo.Accessor getter, Collection<?> values) {
            if (Comparable.class.isAssignableFrom(getter.getType())) {
                HashSet set = new HashSet(values);
                return value -> set.contains(InstanceList.indexValueForEntity(getter, value));
            }
            HashSet<Comparable> set = new HashSet<Comparable>(values.size());
            for (Object key : values) {
                set.add(InMemoryStore.asKey(key));
            }
            return value -> set.contains(InMemoryStore.asKey(InstanceList.indexValueForEntity(getter, value)));
        }

        private static Object indexValueForEntity(KVTypeInfo.Accessor getter, Object entity) {
            try {
                return getter.get(entity);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private static class CountingRemoveIfForEach<T>
        implements BiConsumer<Comparable<Object>, T> {
            private final InstanceList<T> instanceList;
            private final Predicate<? super T> filter;
            private int count = 0;

            CountingRemoveIfForEach(InstanceList<T> instanceList, Predicate<? super T> filter) {
                this.instanceList = instanceList;
                this.filter = filter;
            }

            @Override
            public void accept(Comparable<Object> key, T value) {
                if (this.filter.test(value) && this.instanceList.delete(key, value)) {
                    ++this.count;
                }
            }

            public int count() {
                return this.count;
            }
        }
    }

    private static class NaturalKeys
    extends ConcurrentHashMap<Comparable<Object>, Boolean> {
        private NaturalKeys() {
        }
    }

    private static class InMemoryLists {
        private final ConcurrentMap<Class<?>, InstanceList<?>> data = new ConcurrentHashMap();

        private InMemoryLists() {
        }

        public <T> InstanceList<T> get(Class<T> type) {
            return (InstanceList)this.data.get(type);
        }

        public <T> void write(T value) throws Exception {
            InstanceList list = this.data.computeIfAbsent(value.getClass(), x$0 -> new InstanceList((Class)x$0));
            list.put(value);
        }

        public void clear() {
            this.data.clear();
        }
    }
}

