/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class AvroSchemaIOProvider
implements SchemaIOProvider {
    @Override
    public String identifier() {
        return "avro";
    }

    @Override
    public Schema configurationSchema() {
        return Schema.builder().addNullableField("writeWindowSizeSeconds", Schema.FieldType.INT64).build();
    }

    @Override
    public AvroSchemaIO from(String location, Row configuration, Schema dataSchema) {
        return new AvroSchemaIO(location, dataSchema, configuration);
    }

    @Override
    public boolean requiresDataSchema() {
        return true;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private static class AvroSchemaIO
    implements SchemaIO,
    Serializable {
        protected final Schema dataSchema;
        protected final String location;
        protected final @Nullable Duration windowSize;

        private AvroSchemaIO(String location, Schema dataSchema, Row configuration) {
            this.dataSchema = dataSchema;
            this.location = location;
            this.windowSize = configuration.getInt64("writeWindowSizeSeconds") != null ? Duration.standardSeconds((long)configuration.getInt64("writeWindowSizeSeconds")) : null;
        }

        @Override
        public Schema schema() {
            return this.dataSchema;
        }

        @Override
        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                @Override
                public PCollection<Row> expand(PBegin begin) {
                    return ((PCollection)begin.apply("AvroIORead", AvroIO.readGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).withBeamSchemas(true).from(location))).apply("ToRows", Convert.toRows());
                }
            };
        }

        public PTransform<PCollection<Row>, POutput> buildWriter() {
            return new PTransform<PCollection<Row>, POutput>(){

                @Override
                public PDone expand(PCollection<Row> input) {
                    PCollection asRecords = input.apply("ToGenericRecords", Convert.to(GenericRecord.class));
                    AvroIO.Write<GenericRecord> avroWrite = AvroIO.writeGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).to(location);
                    if (input.isBounded() == PCollection.IsBounded.UNBOUNDED || windowSize != null) {
                        asRecords = (PCollection)asRecords.apply(Window.into(FixedWindows.of(windowSize == null ? Duration.standardMinutes((long)1L) : windowSize)));
                        avroWrite = avroWrite.withWindowedWrites().withNumShards(1);
                    } else {
                        avroWrite = avroWrite.withoutSharding();
                    }
                    return (PDone)asRecords.apply("AvroIOWrite", avroWrite);
                }
            };
        }
    }
}

