/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SnappyCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceRestriction;
import org.apache.beam.sdk.io.AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceValue;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Deduplicate;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Read {
    private static final int DEFAULT_DESIRED_NUM_SPLITS = 20;

    public static <T> Bounded<T> from(BoundedSource<T> source) {
        return new Bounded(null, source);
    }

    public static <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
        return new Unbounded<T>(null, source);
    }

    private static class OutputSingleSource<T, SourceT extends Source<T>>
    extends DoFn<byte[], SourceT> {
        private final SourceT source;

        private OutputSingleSource(SourceT source) {
            this.source = source;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.OutputReceiver<SourceT> outputReceiver) {
            outputReceiver.output(this.source);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", (HasDisplayData)this.source);
        }

        /* synthetic */ OutputSingleSource(Source x0, 1 x1) {
            this(x0);
        }
    }

    @DoFn.UnboundedPerElement
    static class UnboundedSourceAsSDFWrapperFn<OutputT, CheckpointT extends UnboundedSource.CheckpointMark>
    extends DoFn<UnboundedSource<OutputT, CheckpointT>, ValueWithRecordId<OutputT>> {
        private static final Logger LOG = LoggerFactory.getLogger(UnboundedSourceAsSDFWrapperFn.class);
        private static final int DEFAULT_BUNDLE_FINALIZATION_LIMIT_MINS = 10;
        private final Coder<CheckpointT> checkpointCoder;
        private Cache<Object, UnboundedSource.UnboundedReader<OutputT>> cachedReaders;
        private Coder<UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder;

        @VisibleForTesting
        UnboundedSourceAsSDFWrapperFn(Coder<CheckpointT> checkpointCoder) {
            this.checkpointCoder = checkpointCoder;
        }

        @DoFn.GetInitialRestriction
        public UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction(@DoFn.Element UnboundedSource<OutputT, CheckpointT> element) {
            return UnboundedSourceRestriction.create(element, null, BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        @DoFn.Setup
        public void setUp() throws Exception {
            this.restrictionCoder = this.restrictionCoder();
            this.cachedReaders = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(100L).removalListener(removalNotification -> {
                if (removalNotification.wasEvicted()) {
                    try {
                        ((UnboundedSource.UnboundedReader)removalNotification.getValue()).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close UnboundedReader.", (Throwable)e);
                    }
                }
            }).build();
        }

        @DoFn.SplitRestriction
        public void splitRestriction(@DoFn.Restriction UnboundedSourceRestriction<OutputT, CheckpointT> restriction, DoFn.OutputReceiver<UnboundedSourceRestriction<OutputT, CheckpointT>> receiver, PipelineOptions pipelineOptions) throws Exception {
            if (restriction.getSource() instanceof EmptyUnboundedSource) {
                return;
            }
            if (restriction.getCheckpoint() != null && !(restriction.getCheckpoint() instanceof UnboundedSource.CheckpointMark.NoopCheckpointMark)) {
                receiver.output(restriction);
            }
            try {
                for (UnboundedSource<OutputT, CheckpointT> split : restriction.getSource().split(20, pipelineOptions)) {
                    receiver.output(UnboundedSourceRestriction.create(split, null, restriction.getWatermark()));
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while splitting source. Source not split.", (Throwable)e);
                receiver.output(restriction);
            }
        }

        @DoFn.NewTracker
        public RestrictionTracker<UnboundedSourceRestriction<OutputT, CheckpointT>, UnboundedSourceValue<OutputT>[]> restrictionTracker(@DoFn.Restriction UnboundedSourceRestriction<OutputT, CheckpointT> restriction, PipelineOptions pipelineOptions) {
            Preconditions.checkNotNull(this.restrictionCoder);
            Preconditions.checkNotNull(this.cachedReaders);
            return new UnboundedSourceAsSDFRestrictionTracker<OutputT, CheckpointT>(restriction, pipelineOptions, this.cachedReaders, this.restrictionCoder);
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(RestrictionTracker<UnboundedSourceRestriction<OutputT, CheckpointT>, UnboundedSourceValue[]> tracker, ManualWatermarkEstimator<Instant> watermarkEstimator, DoFn.OutputReceiver<ValueWithRecordId<OutputT>> receiver, DoFn.BundleFinalizer bundleFinalizer) throws IOException {
            boolean isInitialRestriction;
            UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction = tracker.currentRestriction();
            UnboundedSourceValue[] out = new UnboundedSourceValue[1];
            while (tracker.tryClaim(out) && out[0] != null) {
                watermarkEstimator.setWatermark(out[0].getWatermark());
                receiver.outputWithTimestamp(new ValueWithRecordId(out[0].getValue(), out[0].getId()), out[0].getTimestamp());
            }
            UnboundedSourceRestriction<OutputT, CheckpointT> currentRestriction = tracker.currentRestriction();
            boolean bl = isInitialRestriction = initialRestriction == currentRestriction;
            if (currentRestriction.getCheckpoint() != null && !isInitialRestriction && !(tracker.currentRestriction().getCheckpoint() instanceof UnboundedSource.CheckpointMark.NoopCheckpointMark)) {
                bundleFinalizer.afterBundleCommit(Instant.now().plus((ReadableDuration)Duration.standardMinutes((long)10L)), () -> currentRestriction.getCheckpoint().finalizeCheckpoint());
            }
            if (currentRestriction.getSource() instanceof EmptyUnboundedSource) {
                return DoFn.ProcessContinuation.stop();
            }
            watermarkEstimator.setWatermark(currentRestriction.getWatermark());
            return DoFn.ProcessContinuation.resume();
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        private static Instant ensureTimestampWithinBounds(Instant timestamp) {
            if (timestamp.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MIN_VALUE)) {
                timestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
            } else if (timestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                timestamp = BoundedWindow.TIMESTAMP_MAX_VALUE;
            }
            return timestamp;
        }

        @DoFn.NewWatermarkEstimator
        public WatermarkEstimators.Manual newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
            return new WatermarkEstimators.Manual(UnboundedSourceAsSDFWrapperFn.ensureTimestampWithinBounds(watermarkEstimatorState));
        }

        @DoFn.GetRestrictionCoder
        public Coder<UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder() {
            return SnappyCoder.of(new UnboundedSourceRestrictionCoder(SerializableCoder.of(new TypeDescriptor<UnboundedSource<OutputT, CheckpointT>>(){}), NullableCoder.of(this.checkpointCoder)));
        }

        private static class UnboundedSourceAsSDFRestrictionTracker<OutputT, CheckpointT extends UnboundedSource.CheckpointMark>
        extends RestrictionTracker<UnboundedSourceRestriction<OutputT, CheckpointT>, UnboundedSourceValue<OutputT>[]>
        implements RestrictionTracker.HasProgress {
            private final UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction;
            private final PipelineOptions pipelineOptions;
            private UnboundedSource.UnboundedReader<OutputT> currentReader;
            private boolean readerHasBeenStarted;
            private Cache<Object, UnboundedSource.UnboundedReader<OutputT>> cachedReaders;
            private Coder<UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder;

            UnboundedSourceAsSDFRestrictionTracker(UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction, PipelineOptions pipelineOptions, Cache<Object, UnboundedSource.UnboundedReader<OutputT>> cachedReaders, Coder<UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder) {
                this.initialRestriction = initialRestriction;
                this.pipelineOptions = pipelineOptions;
                this.cachedReaders = cachedReaders;
                this.restrictionCoder = restrictionCoder;
            }

            private Object createCacheKey(UnboundedSource<OutputT, CheckpointT> source, CheckpointT checkpoint) {
                Preconditions.checkNotNull(this.restrictionCoder);
                return this.restrictionCoder.structuralValue(UnboundedSourceRestriction.create(source, checkpoint, BoundedWindow.TIMESTAMP_MIN_VALUE));
            }

            private void initializeCurrentReader() throws IOException {
                Preconditions.checkState((this.currentReader == null ? 1 : 0) != 0);
                Object cacheKey = this.createCacheKey(this.initialRestriction.getSource(), this.initialRestriction.getCheckpoint());
                this.currentReader = (UnboundedSource.UnboundedReader)this.cachedReaders.getIfPresent(cacheKey);
                if (this.currentReader == null) {
                    this.currentReader = this.initialRestriction.getSource().createReader(this.pipelineOptions, this.initialRestriction.getCheckpoint());
                } else {
                    this.readerHasBeenStarted = true;
                    this.cachedReaders.invalidate(cacheKey);
                }
            }

            private void cacheCurrentReader(UnboundedSourceRestriction<OutputT, CheckpointT> restriction) {
                if (!(this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader)) {
                    this.cachedReaders.put(this.createCacheKey(restriction.getSource(), restriction.getCheckpoint()), this.currentReader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean tryClaim(UnboundedSourceValue<OutputT>[] position) {
                try {
                    if (this.currentReader == null) {
                        this.initializeCurrentReader();
                    }
                    if (this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader) {
                        return false;
                    }
                    if (!this.readerHasBeenStarted) {
                        this.readerHasBeenStarted = true;
                        if (!this.currentReader.start()) {
                            position[0] = null;
                            return true;
                        }
                    } else if (!this.currentReader.advance()) {
                        position[0] = null;
                        return true;
                    }
                    position[0] = UnboundedSourceValue.create(this.currentReader.getCurrentRecordId(), this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp(), this.currentReader.getWatermark());
                    return true;
                }
                catch (IOException e) {
                    if (this.currentReader != null) {
                        try {
                            this.currentReader.close();
                        }
                        catch (IOException closeException) {
                            e.addSuppressed(closeException);
                        }
                        finally {
                            this.currentReader = null;
                        }
                    }
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UnboundedSourceRestriction<OutputT, CheckpointT> currentRestriction() {
                if (this.currentReader == null) {
                    return this.initialRestriction;
                }
                Instant watermark = UnboundedSourceAsSDFWrapperFn.ensureTimestampWithinBounds(this.currentReader.getWatermark());
                if (!(this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader) && BoundedWindow.TIMESTAMP_MAX_VALUE.equals((Object)watermark)) {
                    UnboundedSource.CheckpointMark checkpointT = this.currentReader.getCheckpointMark();
                    try {
                        this.currentReader.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close UnboundedReader.", (Throwable)e);
                    }
                    finally {
                        this.currentReader = EmptyUnboundedSource.INSTANCE.createReader((PipelineOptions)null, checkpointT);
                    }
                }
                return UnboundedSourceRestriction.create(this.currentReader.getCurrentSource(), this.currentReader.getCheckpointMark(), watermark);
            }

            @Override
            public SplitResult<UnboundedSourceRestriction<OutputT, CheckpointT>> trySplit(double fractionOfRemainder) {
                Object currentRestriction = this.currentRestriction();
                if (((UnboundedSourceRestriction)currentRestriction).getSource() instanceof EmptyUnboundedSource) {
                    return null;
                }
                SplitResult<Object> result = SplitResult.of(UnboundedSourceRestriction.create(EmptyUnboundedSource.INSTANCE, null, BoundedWindow.TIMESTAMP_MAX_VALUE), currentRestriction);
                this.cacheCurrentReader((UnboundedSourceRestriction<OutputT, CheckpointT>)currentRestriction);
                this.currentReader = EmptyUnboundedSource.INSTANCE.createReader((PipelineOptions)null, ((UnboundedSourceRestriction)currentRestriction).getCheckpoint());
                return result;
            }

            @Override
            public void checkDone() throws IllegalStateException {
                Preconditions.checkState((boolean)(this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader), (Object)"Expected all records to have been claimed but finished processing unbounded source while some records may have not been read.");
            }

            @Override
            public RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.UNBOUNDED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RestrictionTracker.Progress getProgress() {
                if (((UnboundedSourceRestriction)this.currentRestriction()).getSource() instanceof EmptyUnboundedSource) {
                    return RestrictionTracker.Progress.from(1.0, 0.0);
                }
                boolean resetReaderAfter = false;
                if (this.currentReader == null) {
                    try {
                        this.initializeCurrentReader();
                        resetReaderAfter = true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    long size = this.currentReader.getSplitBacklogBytes();
                    if (size != -1L) {
                        RestrictionTracker.Progress progress = RestrictionTracker.Progress.from(0.0, size);
                        return progress;
                    }
                    RestrictionTracker.Progress progress = RestrictionTracker.Progress.from(0.0, 1.0);
                    return progress;
                }
                finally {
                    if (resetReaderAfter) {
                        this.cacheCurrentReader(this.initialRestriction);
                        this.currentReader = null;
                    }
                }
            }
        }

        private static class EmptyUnboundedSource<OutputT, CheckpointT extends UnboundedSource.CheckpointMark>
        extends UnboundedSource<OutputT, CheckpointT> {
            private static final EmptyUnboundedSource INSTANCE = new EmptyUnboundedSource();

            private EmptyUnboundedSource() {
            }

            @Override
            public List<? extends UnboundedSource<OutputT, CheckpointT>> split(int desiredNumSplits, PipelineOptions options) throws Exception {
                throw new UnsupportedOperationException("split is never meant to be invoked.");
            }

            @Override
            public UnboundedSource.UnboundedReader<OutputT> createReader(PipelineOptions options, @Nullable CheckpointT checkpointMark) {
                return new EmptyUnboundedReader(this, (UnboundedSource.CheckpointMark)checkpointMark);
            }

            @Override
            public Coder<CheckpointT> getCheckpointMarkCoder() {
                throw new UnsupportedOperationException("getCheckpointMarkCoder is never meant to be invoked.");
            }

            private static class EmptyUnboundedReader
            extends UnboundedSource.UnboundedReader<OutputT> {
                private final @Nullable CheckpointT checkpointMark;
                final /* synthetic */ EmptyUnboundedSource this$0;

                private EmptyUnboundedReader(CheckpointT checkpointMark) {
                    this.this$0 = var1_1;
                    this.checkpointMark = checkpointMark;
                }

                @Override
                public boolean start() throws IOException {
                    return false;
                }

                @Override
                public boolean advance() throws IOException {
                    return false;
                }

                @Override
                public OutputT getCurrent() throws NoSuchElementException {
                    throw new UnsupportedOperationException("getCurrent is never meant to be invoked.");
                }

                @Override
                public Instant getCurrentTimestamp() throws NoSuchElementException {
                    throw new UnsupportedOperationException("getCurrentTimestamp is never meant to be invoked.");
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Instant getWatermark() {
                    return BoundedWindow.TIMESTAMP_MAX_VALUE;
                }

                @Override
                public UnboundedSource.CheckpointMark getCheckpointMark() {
                    return this.checkpointMark;
                }

                @Override
                public UnboundedSource<OutputT, ?> getCurrentSource() {
                    return INSTANCE;
                }
            }
        }

        private static class UnboundedSourceRestrictionCoder<OutputT, CheckpointT extends UnboundedSource.CheckpointMark>
        extends StructuredCoder<UnboundedSourceRestriction<OutputT, CheckpointT>> {
            private final Coder<UnboundedSource<OutputT, CheckpointT>> sourceCoder;
            private final Coder<CheckpointT> checkpointCoder;

            private UnboundedSourceRestrictionCoder(Coder<UnboundedSource<OutputT, CheckpointT>> sourceCoder, Coder<CheckpointT> checkpointCoder) {
                this.sourceCoder = sourceCoder;
                this.checkpointCoder = checkpointCoder;
            }

            @Override
            public void encode(UnboundedSourceRestriction<OutputT, CheckpointT> value, OutputStream outStream) throws CoderException, IOException {
                this.sourceCoder.encode(value.getSource(), outStream);
                this.checkpointCoder.encode(value.getCheckpoint(), outStream);
                InstantCoder.of().encode(value.getWatermark(), outStream);
            }

            @Override
            public UnboundedSourceRestriction<OutputT, CheckpointT> decode(InputStream inStream) throws CoderException, IOException {
                return UnboundedSourceRestriction.create(this.sourceCoder.decode(inStream), (UnboundedSource.CheckpointMark)this.checkpointCoder.decode(inStream), InstantCoder.of().decode(inStream));
            }

            @Override
            public List<? extends Coder<?>> getCoderArguments() {
                return Arrays.asList(this.sourceCoder, this.checkpointCoder);
            }

            @Override
            public void verifyDeterministic() throws Coder.NonDeterministicException {
                UnboundedSourceRestrictionCoder.verifyDeterministic(this.sourceCoder, "source coder not deterministic", new Coder[0]);
                UnboundedSourceRestrictionCoder.verifyDeterministic(this.checkpointCoder, "checkpoint coder not deterministic", new Coder[0]);
                UnboundedSourceRestrictionCoder.verifyDeterministic(InstantCoder.of(), "watermark coder not deterministic", new Coder[0]);
            }
        }

        @AutoValue
        static abstract class UnboundedSourceRestriction<OutputT, CheckpointT extends UnboundedSource.CheckpointMark>
        implements Serializable {
            UnboundedSourceRestriction() {
            }

            public static <OutputT, CheckpointT extends UnboundedSource.CheckpointMark> UnboundedSourceRestriction<OutputT, CheckpointT> create(UnboundedSource<OutputT, CheckpointT> source, CheckpointT checkpoint, Instant watermark) {
                return new AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceRestriction<OutputT, CheckpointT>(source, checkpoint, watermark);
            }

            public abstract UnboundedSource<OutputT, CheckpointT> getSource();

            public abstract @Nullable CheckpointT getCheckpoint();

            public abstract Instant getWatermark();
        }

        @AutoValue
        static abstract class UnboundedSourceValue<T> {
            UnboundedSourceValue() {
            }

            public static <T> UnboundedSourceValue<T> create(byte[] id, T value, Instant timestamp, Instant watermark) {
                return new AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceValue<T>(id, value, timestamp, watermark);
            }

            public abstract byte[] getId();

            public abstract T getValue();

            public abstract Instant getTimestamp();

            public abstract Instant getWatermark();
        }
    }

    static class BoundedSourceAsSDFWrapperFn<T, BoundedSourceT extends BoundedSource<T>>
    extends DoFn<BoundedSourceT, T> {
        private static final Logger LOG = LoggerFactory.getLogger(BoundedSourceAsSDFWrapperFn.class);
        private static final long DEFAULT_DESIRED_BUNDLE_SIZE_BYTES = 0x4000000L;

        BoundedSourceAsSDFWrapperFn() {
        }

        @DoFn.GetInitialRestriction
        public BoundedSourceT initialRestriction(@DoFn.Element BoundedSourceT element) {
            return element;
        }

        @DoFn.GetSize
        public double getSize(@DoFn.Restriction BoundedSourceT restriction, PipelineOptions pipelineOptions) throws Exception {
            return ((BoundedSource)restriction).getEstimatedSizeBytes(pipelineOptions);
        }

        @DoFn.SplitRestriction
        public void splitRestriction(@DoFn.Restriction BoundedSourceT restriction, DoFn.OutputReceiver<BoundedSourceT> receiver, PipelineOptions pipelineOptions) throws Exception {
            long estimatedSize = ((BoundedSource)restriction).getEstimatedSizeBytes(pipelineOptions);
            long splitBundleSize = Math.min(0x4000000L, Math.max(1L, estimatedSize / 20L));
            List splits = ((BoundedSource)restriction).split(splitBundleSize, pipelineOptions);
            for (BoundedSource split : splits) {
                receiver.output(split);
            }
        }

        @DoFn.NewTracker
        public RestrictionTracker<BoundedSourceT, TimestampedValue<T>[]> restrictionTracker(@DoFn.Restriction BoundedSourceT restriction, PipelineOptions pipelineOptions) {
            return new BoundedSourceAsSDFRestrictionTracker(restriction, pipelineOptions);
        }

        @DoFn.ProcessElement
        public void processElement(RestrictionTracker<BoundedSourceT, TimestampedValue<T>[]> tracker, DoFn.OutputReceiver<T> receiver) throws IOException {
            TimestampedValue[] out = new TimestampedValue[1];
            while (tracker.tryClaim(out)) {
                receiver.outputWithTimestamp(out[0].getValue(), out[0].getTimestamp());
            }
        }

        @DoFn.GetRestrictionCoder
        public Coder<BoundedSourceT> restrictionCoder() {
            return SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<BoundedSourceT>(){}));
        }

        private static class BoundedSourceAsSDFRestrictionTracker<BoundedSourceT extends BoundedSource<T>, T>
        extends RestrictionTracker<BoundedSourceT, TimestampedValue<T>[]> {
            private final BoundedSourceT initialRestriction;
            private final PipelineOptions pipelineOptions;
            private BoundedSource.BoundedReader<T> currentReader;
            private boolean claimedAll;

            BoundedSourceAsSDFRestrictionTracker(BoundedSourceT initialRestriction, PipelineOptions pipelineOptions) {
                this.initialRestriction = initialRestriction;
                this.pipelineOptions = pipelineOptions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean tryClaim(TimestampedValue<T>[] position) {
                if (this.claimedAll) {
                    return false;
                }
                try {
                    if (this.currentReader == null) {
                        this.currentReader = ((BoundedSource)this.initialRestriction).createReader(this.pipelineOptions);
                        if (!this.currentReader.start()) {
                            this.claimedAll = true;
                            try {
                                this.currentReader.close();
                            }
                            finally {
                                this.currentReader = null;
                            }
                            return false;
                        }
                        position[0] = TimestampedValue.of(this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp());
                        return true;
                    }
                    if (!this.currentReader.advance()) {
                        this.claimedAll = true;
                        try {
                            this.currentReader.close();
                        }
                        finally {
                            this.currentReader = null;
                        }
                        return false;
                    }
                    position[0] = TimestampedValue.of(this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp());
                    return true;
                }
                catch (IOException e) {
                    if (this.currentReader != null) {
                        try {
                            this.currentReader.close();
                        }
                        catch (IOException closeException) {
                            e.addSuppressed(closeException);
                        }
                        finally {
                            this.currentReader = null;
                        }
                    }
                    throw new RuntimeException(e);
                }
            }

            protected void finalize() throws Throwable {
                if (this.currentReader != null) {
                    try {
                        this.currentReader.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close BoundedReader due to failure processing bundle.", (Throwable)e);
                    }
                }
            }

            @Override
            public BoundedSourceT currentRestriction() {
                if (this.currentReader == null) {
                    return this.initialRestriction;
                }
                return (BoundedSourceT)this.currentReader.getCurrentSource();
            }

            @Override
            public SplitResult<BoundedSourceT> trySplit(double fractionOfRemainder) {
                BoundedSource<T> residual;
                if (this.currentReader == null) {
                    return null;
                }
                Double consumedFraction = this.currentReader.getFractionConsumed();
                double fraction = fractionOfRemainder;
                if (consumedFraction != null) {
                    fraction = consumedFraction + (1.0 - consumedFraction) * fractionOfRemainder;
                }
                if ((residual = this.currentReader.splitAtFraction(fraction)) == null) {
                    return null;
                }
                Source primary = this.currentReader.getCurrentSource();
                return SplitResult.of(primary, residual);
            }

            @Override
            public void checkDone() throws IllegalStateException {
                Preconditions.checkState((boolean)this.claimedAll, (Object)"Expected all records to have been claimed but finished processing bounded source while some records may have not been read.");
            }

            @Override
            public RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.BOUNDED;
            }
        }
    }

    public static class Unbounded<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final UnboundedSource<T, UnboundedSource.CheckpointMark> source;

        @VisibleForTesting
        Unbounded(@Nullable String name, UnboundedSource<T, ?> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        public BoundedReadFromUnboundedSource<T> withMaxNumRecords(long maxNumRecords) {
            return new BoundedReadFromUnboundedSource<T>(this.source, maxNumRecords, null);
        }

        public BoundedReadFromUnboundedSource<T> withMaxReadTime(@Nullable Duration maxReadTime) {
            return new BoundedReadFromUnboundedSource<T>(this.source, Long.MAX_VALUE, maxReadTime);
        }

        @Override
        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            PCollection outputWithIds = ((PCollection)((Object)((PCollection)input.getPipeline().apply(Impulse.create()).apply(ParDo.of(new OutputSingleSource(this.source, null)))).setCoder(SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<UnboundedSource<T, UnboundedSource.CheckpointMark>>(){}))).apply(ParDo.of(this.createUnboundedSdfWrapper())))).setCoder(ValueWithRecordId.ValueWithRecordIdCoder.of(this.source.getOutputCoder()));
            if (this.source.requiresDeduping()) {
                outputWithIds.apply(Deduplicate.withRepresentativeValueFn(element -> element.getId()).withRepresentativeType(TypeDescriptor.of(byte[].class)));
            }
            return (PCollection)outputWithIds.apply(ParDo.of(new ValueWithRecordId.StripIdsDoFn()));
        }

        @VisibleForTesting
        UnboundedSourceAsSDFWrapperFn<T, UnboundedSource.CheckpointMark> createUnboundedSdfWrapper() {
            return new UnboundedSourceAsSDFWrapperFn(this.source.getCheckpointMarkCoder());
        }

        public UnboundedSource<T, ?> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Bounded<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final BoundedSource<T> source;

        private Bounded(@Nullable String name, BoundedSource<T> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        @Override
        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            return ((PCollection)((PCollection)input.getPipeline().apply(Impulse.create()).apply(ParDo.of(new OutputSingleSource(this.source, null)))).setCoder(SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<BoundedSource<T>>(){}))).apply(ParDo.of(new BoundedSourceAsSDFWrapperFn()))).setCoder(this.source.getOutputCoder()).setTypeDescriptor(this.source.getOutputCoder().getEncodedTypeDescriptor());
        }

        public BoundedSource<T> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Builder {
        private final String name;

        private Builder(String name) {
            this.name = name;
        }

        public <T> Bounded<T> from(BoundedSource<T> source) {
            return new Bounded(this.name, source);
        }

        public <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
            return new Unbounded<T>(this.name, source);
        }
    }
}

