/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoderHelpers;
import org.apache.beam.sdk.schemas.SchemaUtils;
import org.apache.beam.sdk.schemas.logicaltypes.FixedPrecisionNumeric;
import org.apache.beam.sdk.schemas.logicaltypes.MicrosInstant;
import org.apache.beam.sdk.schemas.logicaltypes.PythonCallable;
import org.apache.beam.sdk.schemas.logicaltypes.SchemaLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.UnknownLogicalType;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaTranslation {
    private static final String URN_BEAM_LOGICAL_DECIMAL = FixedPrecisionNumeric.BASE_IDENTIFIER;
    private static final String URN_BEAM_LOGICAL_JAVASDK = "beam:logical_type:javasdk:v1";
    private static final String URN_BEAM_LOGICAL_MILLIS_INSTANT = (String)SchemaApi.LogicalTypes.Enum.MILLIS_INSTANT.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private static final ImmutableMap<String, Class<? extends Schema.LogicalType<?, ?>>> STANDARD_LOGICAL_TYPES = ImmutableMap.builder().put((Object)"beam:logical_type:fixed_decimal:v1", FixedPrecisionNumeric.class).put((Object)MicrosInstant.IDENTIFIER, MicrosInstant.class).put((Object)"beam:logical_type:schema:v1", SchemaLogicalType.class).put((Object)PythonCallable.IDENTIFIER, PythonCallable.class).build();

    public static SchemaApi.Schema schemaToProto(Schema schema, boolean serializeLogicalType) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        SchemaApi.Schema.Builder builder = SchemaApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            SchemaApi.Field protoField = SchemaTranslation.fieldToProto(field, schema.indexOf(field.getName()), schema.getEncodingPositions().get(field.getName()), serializeLogicalType);
            builder.addFields(protoField);
        }
        builder.addAllOptions(SchemaTranslation.optionsToProto(schema.getOptions()));
        return builder.build();
    }

    private static SchemaApi.Field fieldToProto(Schema.Field field, int fieldId, int position, boolean serializeLogicalType) {
        return SchemaApi.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.fieldTypeToProto(field.getType(), serializeLogicalType)).setId(fieldId).setEncodingPosition(position).addAllOptions(SchemaTranslation.optionsToProto(field.getOptions())).build();
    }

    private static SchemaApi.FieldType fieldTypeToProto(Schema.FieldType fieldType, boolean serializeLogicalType) {
        SchemaApi.FieldType.Builder builder = SchemaApi.FieldType.newBuilder();
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowType(SchemaApi.RowType.newBuilder().setSchema(SchemaTranslation.schemaToProto(fieldType.getRowSchema(), serializeLogicalType)));
                break;
            }
            case ARRAY: {
                builder.setArrayType(SchemaApi.ArrayType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType(), serializeLogicalType)));
                break;
            }
            case ITERABLE: {
                builder.setIterableType(SchemaApi.IterableType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType(), serializeLogicalType)));
                break;
            }
            case MAP: {
                builder.setMapType(SchemaApi.MapType.newBuilder().setKeyType(SchemaTranslation.fieldTypeToProto(fieldType.getMapKeyType(), serializeLogicalType)).setValueType(SchemaTranslation.fieldTypeToProto(fieldType.getMapValueType(), serializeLogicalType)).build());
                break;
            }
            case LOGICAL_TYPE: {
                SchemaApi.LogicalType.Builder logicalTypeBuilder;
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                String identifier = logicalType.getIdentifier();
                boolean isStandard = STANDARD_LOGICAL_TYPES.containsKey((Object)identifier);
                if (!isStandard && logicalType instanceof UnknownLogicalType) {
                    logicalTypeBuilder = SchemaApi.LogicalType.newBuilder().setUrn(logicalType.getIdentifier()).setPayload(ByteString.copyFrom((byte[])((UnknownLogicalType)logicalType).getPayload())).setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType(), serializeLogicalType));
                    if (logicalType.getArgumentType() != null) {
                        logicalTypeBuilder.setArgumentType(SchemaTranslation.fieldTypeToProto(logicalType.getArgumentType(), serializeLogicalType)).setArgument(SchemaTranslation.fieldValueToProto(logicalType.getArgumentType(), logicalType.getArgument()));
                    }
                } else {
                    String urn = identifier.startsWith("beam:logical_type:") ? identifier : URN_BEAM_LOGICAL_JAVASDK;
                    logicalTypeBuilder = SchemaApi.LogicalType.newBuilder().setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType(), serializeLogicalType)).setUrn(urn);
                    if (logicalType.getArgumentType() != null) {
                        logicalTypeBuilder = logicalTypeBuilder.setArgumentType(SchemaTranslation.fieldTypeToProto(logicalType.getArgumentType(), serializeLogicalType)).setArgument(SchemaTranslation.fieldValueToProto(logicalType.getArgumentType(), logicalType.getArgument()));
                    }
                    if (!isStandard && serializeLogicalType) {
                        logicalTypeBuilder = logicalTypeBuilder.setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(logicalType)));
                    }
                }
                builder.setLogicalType(logicalTypeBuilder.build());
                break;
            }
            case DATETIME: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_MILLIS_INSTANT).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.INT64, serializeLogicalType)).build());
                break;
            }
            case DECIMAL: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DECIMAL).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.BYTES, serializeLogicalType)).build());
                break;
            }
            case BYTE: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTE);
                break;
            }
            case INT16: {
                builder.setAtomicType(SchemaApi.AtomicType.INT16);
                break;
            }
            case INT32: {
                builder.setAtomicType(SchemaApi.AtomicType.INT32);
                break;
            }
            case INT64: {
                builder.setAtomicType(SchemaApi.AtomicType.INT64);
                break;
            }
            case FLOAT: {
                builder.setAtomicType(SchemaApi.AtomicType.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setAtomicType(SchemaApi.AtomicType.DOUBLE);
                break;
            }
            case STRING: {
                builder.setAtomicType(SchemaApi.AtomicType.STRING);
                break;
            }
            case BOOLEAN: {
                builder.setAtomicType(SchemaApi.AtomicType.BOOLEAN);
                break;
            }
            case BYTES: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTES);
            }
        }
        builder.setNullable(fieldType.getNullable());
        return builder.build();
    }

    public static Schema schemaFromProto(SchemaApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap encodingLocationMap = Maps.newHashMap();
        for (SchemaApi.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field;
            try {
                field = SchemaTranslation.fieldFromProto(protoField);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to decode Schema due to an error decoding Field proto:\n\n" + protoField, e);
            }
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        builder.setOptions(SchemaTranslation.optionsFromProto(protoSchema.getOptionsList()));
        Schema schema = builder.build();
        Preconditions.checkState((encodingLocationMap.size() == schema.getFieldCount() ? 1 : 0) != 0);
        long dinstictEncodingPositions = encodingLocationMap.values().stream().distinct().count();
        Preconditions.checkState((dinstictEncodingPositions <= (long)schema.getFieldCount() ? 1 : 0) != 0);
        if (dinstictEncodingPositions < (long)schema.getFieldCount() && schema.getFieldCount() > 0) {
            Preconditions.checkState((dinstictEncodingPositions == 1L ? 1 : 0) != 0);
        } else if (protoSchema.getEncodingPositionsSet()) {
            schema.setEncodingPositions(encodingLocationMap);
        }
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(SchemaApi.Field protoField) {
        return Schema.Field.of(protoField.getName(), SchemaTranslation.fieldTypeFromProto(protoField.getType())).withOptions(SchemaTranslation.optionsFromProto(protoField.getOptionsList())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(SchemaApi.FieldType protoFieldType) {
        Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProtoWithoutNullable(protoFieldType);
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }

    private static Schema.FieldType fieldTypeFromProtoWithoutNullable(SchemaApi.FieldType protoFieldType) {
        switch (protoFieldType.getTypeInfoCase()) {
            case ATOMIC_TYPE: {
                switch (protoFieldType.getAtomicType()) {
                    case BYTE: {
                        return Schema.FieldType.of(Schema.TypeName.BYTE);
                    }
                    case INT16: {
                        return Schema.FieldType.of(Schema.TypeName.INT16);
                    }
                    case INT32: {
                        return Schema.FieldType.of(Schema.TypeName.INT32);
                    }
                    case INT64: {
                        return Schema.FieldType.of(Schema.TypeName.INT64);
                    }
                    case FLOAT: {
                        return Schema.FieldType.of(Schema.TypeName.FLOAT);
                    }
                    case DOUBLE: {
                        return Schema.FieldType.of(Schema.TypeName.DOUBLE);
                    }
                    case STRING: {
                        return Schema.FieldType.of(Schema.TypeName.STRING);
                    }
                    case BOOLEAN: {
                        return Schema.FieldType.of(Schema.TypeName.BOOLEAN);
                    }
                    case BYTES: {
                        return Schema.FieldType.of(Schema.TypeName.BYTES);
                    }
                    case UNSPECIFIED: {
                        throw new IllegalArgumentException("Encountered UNSPECIFIED AtomicType");
                    }
                }
                throw new IllegalArgumentException("Encountered unknown AtomicType: " + (Object)((Object)protoFieldType.getAtomicType()));
            }
            case ROW_TYPE: {
                return Schema.FieldType.row(SchemaTranslation.schemaFromProto(protoFieldType.getRowType().getSchema()));
            }
            case ARRAY_TYPE: {
                return Schema.FieldType.array(SchemaTranslation.fieldTypeFromProto(protoFieldType.getArrayType().getElementType()));
            }
            case ITERABLE_TYPE: {
                return Schema.FieldType.iterable(SchemaTranslation.fieldTypeFromProto(protoFieldType.getIterableType().getElementType()));
            }
            case MAP_TYPE: {
                return Schema.FieldType.map(SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
            }
            case LOGICAL_TYPE: {
                SchemaApi.LogicalType logicalType = protoFieldType.getLogicalType();
                String urn = logicalType.getUrn();
                Class logicalTypeClass = (Class)STANDARD_LOGICAL_TYPES.get((Object)urn);
                if (logicalTypeClass != null) {
                    boolean hasArgument = logicalType.hasArgument();
                    if (hasArgument) {
                        Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProto(logicalType.getArgumentType());
                        Object fieldValue = Objects.requireNonNull(SchemaTranslation.fieldValueFromProto(fieldType, logicalType.getArgument()));
                        Class<Object> clazz = fieldValue.getClass();
                        if (fieldValue instanceof List) {
                            clazz = List.class;
                        }
                        if (fieldValue instanceof Map) {
                            clazz = Map.class;
                        } else if (fieldValue instanceof Row) {
                            clazz = Row.class;
                        }
                        String objectName = clazz.getName();
                        try {
                            return Schema.FieldType.logicalType((Schema.LogicalType)logicalTypeClass.cast(logicalTypeClass.getMethod("of", clazz).invoke(null, fieldValue)));
                        }
                        catch (NoSuchMethodException e) {
                            throw new RuntimeException(String.format("Standard logical type '%s' does not have a static of('%s') method.", urn, objectName), e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(String.format("Standard logical type '%s' has an of('%s') method, but it is not accessible.", urn, objectName), e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(String.format("Error instantiating logical type '%s' with of('%s') method.", urn, objectName), e);
                        }
                    }
                    try {
                        return Schema.FieldType.logicalType((Schema.LogicalType)logicalTypeClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(String.format("Standard logical type '%s' does not have a zero-argument constructor.", urn), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(String.format("Standard logical type '%s' has a zero-argument constructor, but it is not accessible.", urn), e);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(String.format("Error instantiating logical type '%s' with zero-argument constructor.", urn), e);
                    }
                }
                if (urn.equals(URN_BEAM_LOGICAL_MILLIS_INSTANT)) {
                    return Schema.FieldType.DATETIME;
                }
                if (urn.equals(URN_BEAM_LOGICAL_DECIMAL)) {
                    return Schema.FieldType.DECIMAL;
                }
                if (urn.equals(URN_BEAM_LOGICAL_JAVASDK)) {
                    return Schema.FieldType.logicalType((Schema.LogicalType)SerializableUtils.deserializeFromByteArray(logicalType.getPayload().toByteArray(), "logicalType"));
                }
                Schema.FieldType argumentType = null;
                Object argumentValue = null;
                if (logicalType.hasArgumentType()) {
                    argumentType = SchemaTranslation.fieldTypeFromProto(logicalType.getArgumentType());
                    argumentValue = SchemaTranslation.fieldValueFromProto(argumentType, logicalType.getArgument());
                }
                return Schema.FieldType.logicalType(new UnknownLogicalType(urn, logicalType.getPayload().toByteArray(), argumentType, argumentValue, SchemaTranslation.fieldTypeFromProto(logicalType.getRepresentation())));
            }
        }
        throw new IllegalArgumentException("Unexpected type_info: " + (Object)((Object)protoFieldType.getTypeInfoCase()));
    }

    public static SchemaApi.Row rowToProto(Row row) {
        SchemaApi.Row.Builder builder = SchemaApi.Row.newBuilder();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            builder.addValues(SchemaTranslation.fieldValueToProto(row.getSchema().getField(i).getType(), row.getValue(i)));
        }
        return builder.build();
    }

    public static Object rowFromProto(SchemaApi.Row row, Schema.FieldType fieldType) {
        Row.Builder builder = Row.withSchema(fieldType.getRowSchema());
        for (int i = 0; i < row.getValuesCount(); ++i) {
            builder.addValue(SchemaTranslation.fieldValueFromProto(fieldType.getRowSchema().getField(i).getType(), row.getValues(i)));
        }
        return builder.build();
    }

    static SchemaApi.FieldValue fieldValueToProto(Schema.FieldType fieldType, Object value) {
        SchemaApi.FieldValue.Builder builder = SchemaApi.FieldValue.newBuilder();
        if (value == null) {
            if (fieldType.getNullable().booleanValue()) {
                return builder.build();
            }
            throw new RuntimeException("Null value found for field that doesn't support nulls.");
        }
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                return builder.setArrayValue(SchemaTranslation.arrayValueToProto(fieldType.getCollectionElementType(), (Iterable)value)).build();
            }
            case ITERABLE: {
                return builder.setIterableValue(SchemaTranslation.iterableValueToProto(fieldType.getCollectionElementType(), (Iterable)value)).build();
            }
            case MAP: {
                return builder.setMapValue(SchemaTranslation.mapToProto(fieldType.getMapKeyType(), fieldType.getMapValueType(), (Map)value)).build();
            }
            case ROW: {
                return builder.setRowValue(SchemaTranslation.rowToProto((Row)value)).build();
            }
            case DATETIME: {
                return builder.setLogicalTypeValue(SchemaTranslation.logicalTypeToProto(Schema.FieldType.INT64, fieldType, value)).build();
            }
            case DECIMAL: {
                return builder.setLogicalTypeValue(SchemaTranslation.logicalTypeToProto(Schema.FieldType.BYTES, fieldType, value)).build();
            }
            case LOGICAL_TYPE: {
                return builder.setLogicalTypeValue(SchemaTranslation.logicalTypeToProto(fieldType.getLogicalType(), value)).build();
            }
        }
        return builder.setAtomicValue(SchemaTranslation.primitiveRowFieldToProto(fieldType, value)).build();
    }

    static boolean isNullFieldValueFromProto(Schema.FieldType fieldType, boolean hasNonNullValue) {
        if (!hasNonNullValue && !fieldType.getNullable().booleanValue()) {
            throw new RuntimeException("FieldTypeValue has no value but the field cannot be null.");
        }
        return !hasNonNullValue;
    }

    static Object fieldValueFromProto(Schema.FieldType fieldType, SchemaApi.FieldValue value) {
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasArrayValue())) {
                    return null;
                }
                return SchemaTranslation.arrayValueFromProto(fieldType.getCollectionElementType(), value.getArrayValue());
            }
            case ITERABLE: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasIterableValue())) {
                    return null;
                }
                return SchemaTranslation.iterableValueFromProto(fieldType.getCollectionElementType(), value.getIterableValue());
            }
            case MAP: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasMapValue())) {
                    return null;
                }
                return SchemaTranslation.mapFromProto(fieldType.getMapKeyType(), fieldType.getMapValueType(), value.getMapValue());
            }
            case ROW: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasRowValue())) {
                    return null;
                }
                return SchemaTranslation.rowFromProto(value.getRowValue(), fieldType);
            }
            case LOGICAL_TYPE: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasLogicalTypeValue())) {
                    return null;
                }
                return SchemaTranslation.logicalTypeFromProto(fieldType.getLogicalType(), value);
            }
            case DATETIME: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasLogicalTypeValue())) {
                    return null;
                }
                return SchemaTranslation.logicalTypeFromProto(Schema.FieldType.INT64, fieldType, value.getLogicalTypeValue());
            }
            case DECIMAL: {
                if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasLogicalTypeValue())) {
                    return null;
                }
                return SchemaTranslation.logicalTypeFromProto(Schema.FieldType.BYTES, fieldType, value.getLogicalTypeValue());
            }
        }
        if (SchemaTranslation.isNullFieldValueFromProto(fieldType, value.hasAtomicValue())) {
            return null;
        }
        return SchemaTranslation.primitiveFromProto(fieldType, value.getAtomicValue());
    }

    private static SchemaApi.ArrayTypeValue arrayValueToProto(Schema.FieldType elementType, Iterable values) {
        return SchemaApi.ArrayTypeValue.newBuilder().addAllElement(Iterables.transform((Iterable)values, e -> SchemaTranslation.fieldValueToProto(elementType, e))).build();
    }

    private static Iterable arrayValueFromProto(Schema.FieldType elementType, SchemaApi.ArrayTypeValue values) {
        return values.getElementList().stream().map(e -> SchemaTranslation.fieldValueFromProto(elementType, e)).collect(Collectors.toList());
    }

    private static SchemaApi.IterableTypeValue iterableValueToProto(Schema.FieldType elementType, Iterable values) {
        return SchemaApi.IterableTypeValue.newBuilder().addAllElement(Iterables.transform((Iterable)values, e -> SchemaTranslation.fieldValueToProto(elementType, e))).build();
    }

    private static Object iterableValueFromProto(Schema.FieldType elementType, SchemaApi.IterableTypeValue values) {
        return values.getElementList().stream().map(e -> SchemaTranslation.fieldValueFromProto(elementType, e)).collect(Collectors.toList());
    }

    private static SchemaApi.MapTypeValue mapToProto(Schema.FieldType keyType, Schema.FieldType valueType, Map<Object, Object> map) {
        SchemaApi.MapTypeValue.Builder builder = SchemaApi.MapTypeValue.newBuilder();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            SchemaApi.MapTypeEntry mapProtoEntry = SchemaApi.MapTypeEntry.newBuilder().setKey(SchemaTranslation.fieldValueToProto(keyType, entry.getKey())).setValue(SchemaTranslation.fieldValueToProto(valueType, entry.getValue())).build();
            builder.addEntries(mapProtoEntry);
        }
        return builder.build();
    }

    private static Object mapFromProto(Schema.FieldType mapKeyType, Schema.FieldType mapValueType, SchemaApi.MapTypeValue mapValue) {
        return mapValue.getEntriesList().stream().collect(Collectors.toMap(entry -> SchemaTranslation.fieldValueFromProto(mapKeyType, entry.getKey()), entry -> SchemaTranslation.fieldValueFromProto(mapValueType, entry.getValue())));
    }

    private static Object logicalTypeFromProto(Schema.FieldType baseType, Schema.FieldType inputType, SchemaApi.LogicalTypeValue value) {
        try {
            PipedInputStream in = new PipedInputStream();
            DataOutputStream stream = new DataOutputStream(new PipedOutputStream(in));
            switch (baseType.getTypeName()) {
                case INT64: {
                    stream.writeLong(value.getValue().getAtomicValue().getInt64());
                    break;
                }
                case BYTES: {
                    stream.write(value.getValue().getAtomicValue().getBytes().toByteArray());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported underlying type for parsing logical type via coder.");
                }
            }
            stream.close();
            return SchemaCoderHelpers.coderForFieldType(inputType).decode(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SchemaApi.LogicalTypeValue logicalTypeToProto(Schema.FieldType baseType, Schema.FieldType inputType, Object value) {
        try {
            Object baseObject;
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            SchemaCoderHelpers.coderForFieldType(inputType).encode(value, out);
            out.close();
            switch (baseType.getTypeName()) {
                case INT64: {
                    baseObject = new DataInputStream(in).readLong();
                    break;
                }
                case BYTES: {
                    baseObject = ByteStreams.toByteArray((InputStream)in);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported underlying type for producing LogicalType via coder.");
                }
            }
            return SchemaApi.LogicalTypeValue.newBuilder().setValue(SchemaTranslation.fieldValueToProto(baseType, baseObject)).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SchemaApi.LogicalTypeValue logicalTypeToProto(Schema.LogicalType logicalType, Object value) {
        return SchemaApi.LogicalTypeValue.newBuilder().setValue(SchemaTranslation.fieldValueToProto(logicalType.getBaseType(), SchemaUtils.toLogicalBaseType(logicalType, value))).build();
    }

    private static Object logicalTypeFromProto(Schema.LogicalType logicalType, SchemaApi.FieldValue logicalValue) {
        return SchemaUtils.toLogicalInputType(logicalType, SchemaTranslation.fieldValueFromProto(logicalType.getBaseType(), logicalValue.getLogicalTypeValue().getValue()));
    }

    private static SchemaApi.AtomicTypeValue primitiveRowFieldToProto(Schema.FieldType fieldType, Object value) {
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return SchemaApi.AtomicTypeValue.newBuilder().setByte(((Byte)value).byteValue()).build();
            }
            case INT16: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt16(((Short)value).shortValue()).build();
            }
            case INT32: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt32((Integer)value).build();
            }
            case INT64: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt64((Long)value).build();
            }
            case FLOAT: {
                return SchemaApi.AtomicTypeValue.newBuilder().setFloat(((Float)value).floatValue()).build();
            }
            case DOUBLE: {
                return SchemaApi.AtomicTypeValue.newBuilder().setDouble((Double)value).build();
            }
            case STRING: {
                return SchemaApi.AtomicTypeValue.newBuilder().setString((String)value).build();
            }
            case BOOLEAN: {
                return SchemaApi.AtomicTypeValue.newBuilder().setBoolean((Boolean)value).build();
            }
            case BYTES: {
                return SchemaApi.AtomicTypeValue.newBuilder().setBytes(ByteString.copyFrom((byte[])((byte[])value))).build();
            }
        }
        throw new RuntimeException("FieldType unexpected " + (Object)((Object)fieldType.getTypeName()));
    }

    private static Object primitiveFromProto(Schema.FieldType fieldType, SchemaApi.AtomicTypeValue value) {
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return (byte)value.getByte();
            }
            case INT16: {
                return (short)value.getInt16();
            }
            case INT32: {
                return value.getInt32();
            }
            case INT64: {
                return value.getInt64();
            }
            case FLOAT: {
                return Float.valueOf(value.getFloat());
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case STRING: {
                return value.getString();
            }
            case BOOLEAN: {
                return value.getBoolean();
            }
            case BYTES: {
                return value.getBytes().toByteArray();
            }
        }
        throw new RuntimeException("FieldType unexpected " + (Object)((Object)fieldType.getTypeName()));
    }

    private static List<SchemaApi.Option> optionsToProto(Schema.Options options) {
        ArrayList<SchemaApi.Option> protoOptions = new ArrayList<SchemaApi.Option>();
        for (String name : options.getOptionNames()) {
            protoOptions.add(SchemaApi.Option.newBuilder().setName(name).setType(SchemaTranslation.fieldTypeToProto(Objects.requireNonNull(options.getType(name)), false)).setValue(SchemaTranslation.fieldValueToProto(Objects.requireNonNull(options.getType(name)), options.getValue(name))).build());
        }
        return protoOptions;
    }

    private static Schema.Options optionsFromProto(List<SchemaApi.Option> protoOptions) {
        Schema.Options.Builder optionBuilder = Schema.Options.builder();
        for (SchemaApi.Option protoOption : protoOptions) {
            Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProto(protoOption.getType());
            optionBuilder.setOption(protoOption.getName(), fieldType, SchemaTranslation.fieldValueFromProto(fieldType, protoOption.getValue()));
        }
        return optionBuilder.build();
    }
}

