/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.extensions.gcp.util.CustomHttpErrors;
import org.apache.beam.sdk.extensions.gcp.util.HttpRequestWrapper;
import org.apache.beam.sdk.extensions.gcp.util.HttpResponseWrapper;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpRequestInitializer
implements HttpRequestInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHttpRequestInitializer.class);
    private static final Set<Integer> DEFAULT_IGNORED_RESPONSE_CODES = new HashSet<Integer>(Arrays.asList(307, 308));
    private static final int HANGING_GET_TIMEOUT_SEC = 80;
    private int writeTimeout;
    private final HttpResponseInterceptor responseInterceptor;
    private CustomHttpErrors customHttpErrors = null;
    private final NanoClock nanoClock;
    private final Sleeper sleeper;
    private Set<Integer> ignoredResponseCodes = new HashSet<Integer>(DEFAULT_IGNORED_RESPONSE_CODES);

    public RetryHttpRequestInitializer() {
        this(Collections.emptyList());
    }

    public RetryHttpRequestInitializer(Collection<Integer> additionalIgnoredResponseCodes) {
        this(additionalIgnoredResponseCodes, null);
    }

    public RetryHttpRequestInitializer(Collection<Integer> additionalIgnoredResponseCodes, @Nullable HttpResponseInterceptor responseInterceptor) {
        this(NanoClock.SYSTEM, Sleeper.DEFAULT, additionalIgnoredResponseCodes, responseInterceptor);
    }

    RetryHttpRequestInitializer(NanoClock nanoClock, Sleeper sleeper, Collection<Integer> additionalIgnoredResponseCodes, HttpResponseInterceptor responseInterceptor) {
        this.nanoClock = nanoClock;
        this.sleeper = sleeper;
        this.ignoredResponseCodes.addAll(additionalIgnoredResponseCodes);
        this.responseInterceptor = responseInterceptor;
        this.writeTimeout = 0;
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setReadTimeout(80000);
        request.setWriteTimeout(this.writeTimeout);
        LoggingHttpBackOffHandler loggingHttpBackOffHandler = new LoggingHttpBackOffHandler(this.sleeper, (BackOff)new ExponentialBackOff.Builder().setNanoClock(this.nanoClock).setMultiplier(2.0).build(), (BackOff)new ExponentialBackOff.Builder().setNanoClock(this.nanoClock).setMultiplier(2.0).build(), this.ignoredResponseCodes, this.customHttpErrors);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)loggingHttpBackOffHandler);
        request.setIOExceptionHandler((HttpIOExceptionHandler)loggingHttpBackOffHandler);
        if (this.responseInterceptor != null) {
            request.setResponseInterceptor(this.responseInterceptor);
        }
    }

    public void setCustomErrors(CustomHttpErrors customErrors) {
        this.customHttpErrors = customErrors;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    private static class LoggingHttpBackOffHandler
    implements HttpIOExceptionHandler,
    HttpUnsuccessfulResponseHandler {
        private final Sleeper sleeper;
        private final BackOff ioExceptionBackOff;
        private final BackOff unsuccessfulResponseBackOff;
        private final Set<Integer> ignoredResponseCodes;
        private final Counter throttlingMsecs = Metrics.counter(LoggingHttpBackOffHandler.class, (String)"throttling-msecs");
        private int ioExceptionRetries;
        private int unsuccessfulResponseRetries;
        private @Nullable CustomHttpErrors customHttpErrors;

        private LoggingHttpBackOffHandler(Sleeper sleeper, BackOff ioExceptionBackOff, BackOff unsucessfulResponseBackOff, Set<Integer> ignoredResponseCodes, @Nullable CustomHttpErrors customHttpErrors) {
            this.sleeper = sleeper;
            this.ioExceptionBackOff = ioExceptionBackOff;
            this.unsuccessfulResponseBackOff = unsucessfulResponseBackOff;
            this.ignoredResponseCodes = ignoredResponseCodes;
            this.customHttpErrors = customHttpErrors;
        }

        public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
            boolean willRetry;
            boolean bl = willRetry = supportsRetry && this.backOffWasSuccessful(this.ioExceptionBackOff);
            if (willRetry) {
                ++this.ioExceptionRetries;
                LOG.debug("Request failed with IOException, will retry: {}", (Object)request.getUrl());
            } else {
                String message = "Request failed with IOException, performed {} retries due to IOExceptions, performed {} retries due to unsuccessful status codes, HTTP framework says request {} be retried, (caller responsible for retrying): {}";
                LOG.warn(message, new Object[]{this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl()});
            }
            return willRetry;
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            boolean willRetry;
            boolean bl = willRetry = supportsRetry && this.retryOnStatusCode(response.getStatusCode()) && this.backOffWasSuccessful(this.unsuccessfulResponseBackOff);
            if (willRetry) {
                ++this.unsuccessfulResponseRetries;
                LOG.debug("Request failed with code {}, will retry: {}", (Object)response.getStatusCode(), (Object)request.getUrl());
            } else {
                String error;
                String message = "Request failed with code {}, performed {} retries due to IOExceptions, performed {} retries due to unsuccessful status codes, HTTP framework says request {} be retried, (caller responsible for retrying): {}. {}";
                String customLogMessage = "";
                if (this.customHttpErrors != null && (error = this.customHttpErrors.getCustomError(new HttpRequestWrapper(request), new HttpResponseWrapper(response))) != null) {
                    customLogMessage = error;
                }
                if (this.ignoredResponseCodes.contains(response.getStatusCode())) {
                    LOG.debug(message, new Object[]{response.getStatusCode(), this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl(), customLogMessage});
                } else {
                    LOG.warn(message, new Object[]{response.getStatusCode(), this.ioExceptionRetries, this.unsuccessfulResponseRetries, supportsRetry ? "can" : "cannot", request.getUrl(), customLogMessage});
                }
            }
            return willRetry;
        }

        private boolean backOffWasSuccessful(BackOff backOff) {
            try {
                long backOffTime = backOff.nextBackOffMillis();
                if (backOffTime == -1L) {
                    return false;
                }
                this.throttlingMsecs.inc(backOffTime);
                this.sleeper.sleep(backOffTime);
                return true;
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }

        private boolean retryOnStatusCode(int statusCode) {
            return statusCode == 0 || statusCode / 100 == 5 || statusCode == 429;
        }
    }
}

