/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemoryLimiterImpl
implements MemoryLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryLimiterImpl.class);
    private final long minBlockSize;
    private final long maxBlockSize;
    private final long maxAvailable;
    @GuardedBy(value="this")
    private long available;

    public MemoryLimiterImpl(long minBlockSize, long maxBlockSize, long maxAvailable) {
        this.minBlockSize = minBlockSize;
        this.maxBlockSize = maxBlockSize;
        this.maxAvailable = maxAvailable;
        this.available = maxAvailable;
    }

    @Override
    public synchronized Block claim(long toAcquire) {
        toAcquire = Math.max(Math.min(toAcquire, this.available / 2L), this.minBlockSize);
        this.available -= toAcquire;
        return new Block(toAcquire);
    }

    @Override
    public long minBlockSize() {
        return this.minBlockSize;
    }

    @Override
    public long maxBlockSize() {
        return this.maxBlockSize;
    }

    private synchronized void release(long toRelease) {
        this.available += toRelease;
        Preconditions.checkState((this.available <= this.maxAvailable ? 1 : 0) != 0);
    }

    public class Block
    implements MemoryLimiter.Block {
        public final long claimed;
        private boolean released = false;

        private Block(long claimed) {
            this.claimed = claimed;
        }

        @Override
        public long claimed() {
            return this.claimed;
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.released ? 1 : 0) != 0);
            this.released = true;
            MemoryLimiterImpl.this.release(this.claimed);
        }

        public void finalize() {
            if (!this.released) {
                LOG.error("Failed to release memory block- likely SDF implementation error.");
                this.close();
            }
        }
    }
}

