/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)deleteMessageBatchRequest.getQueueUrl()));
        }
        if (!deleteMessageBatchRequest.getEntries().isEmpty() || !((SdkInternalList)deleteMessageBatchRequest.getEntries()).isAutoConstruct()) {
            SdkInternalList entriesList = (SdkInternalList)deleteMessageBatchRequest.getEntries();
            int entriesListIndex = 1;
            for (DeleteMessageBatchRequestEntry entriesListValue : entriesList) {
                if (entriesListValue != null) {
                    if (entriesListValue.getId() != null) {
                        request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString((String)entriesListValue.getId()));
                    }
                    if (entriesListValue.getReceiptHandle() != null) {
                        request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString((String)entriesListValue.getReceiptHandle()));
                    }
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

