/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import com.google.api.services.bigquery.model.TableReference;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.BQSchemaAndRecordToHopFn;
import org.apache.hop.core.row.IRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamBQInputTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String projectId;
    private String datasetId;
    private String tableId;
    private String query;
    private String rowMetaJson;
    private static final Logger LOG = LoggerFactory.getLogger(BeamBQInputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamBQInputError");
    private transient IRowMeta rowMeta;

    public BeamBQInputTransform() {
    }

    public BeamBQInputTransform(@Nullable String name, String transformName, String projectId, String datasetId, String tableId, String query, String rowMetaJson) {
        super(name);
        this.transformName = transformName;
        this.projectId = projectId;
        this.datasetId = datasetId;
        this.tableId = tableId;
        this.query = query;
        this.rowMetaJson = rowMetaJson;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            BeamHop.init();
            BQSchemaAndRecordToHopFn toHopFn = new BQSchemaAndRecordToHopFn(this.transformName, this.rowMetaJson);
            TableReference tableReference = new TableReference();
            if (StringUtils.isNotEmpty((String)this.projectId)) {
                tableReference.setProjectId(this.projectId);
            }
            tableReference.setDatasetId(this.datasetId);
            tableReference.setTableId(this.tableId);
            BigQueryIO.TypedRead bqTypedRead = StringUtils.isEmpty((String)this.query) ? BigQueryIO.read((SerializableFunction)toHopFn).from(tableReference).usingStandardSql() : BigQueryIO.read((SerializableFunction)toHopFn).fromQuery(this.query).usingStandardSql();
            PCollection output = (PCollection)input.apply((PTransform)bqTypedRead);
            return output;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in beam input transform", (Throwable)e);
            throw new RuntimeException("Error in beam input transform", e);
        }
    }
}

