/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.cypherbuilder.CypherBuilderMeta;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.neo4j.transforms.cypherbuilder.Property;
import org.apache.hop.neo4j.transforms.cypherbuilder.ReturnValue;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.BaseOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.CreateOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.DeleteOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeMatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MergeOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationFactory;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OrderByOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.ReturnOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.SetOperation;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputDialog;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class CypherBuilderDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CypherBuilderMeta.class;
    public static final String STRING_EXPERIMENTAL_WARNING = "CypherBuilderWarning";
    private CTabFolder wTabFolder;
    private Text wTransformName;
    private int middle;
    private int margin;
    private MetaSelectionLine<NeoConnection> wConnection;
    private TextVar wBatchSize;
    private TextVar wUnwindAlias;
    private TextVar wRetries;
    private TableView wParameters;
    private org.eclipse.swt.widgets.List wOperationsList;
    private Composite wOperationComp;
    private Text wCypher;
    private CypherBuilderMeta input;
    private CypherBuilderMeta copy;
    private boolean warningShown;

    public CypherBuilderDialog(Shell parent, IVariables variables, Object inputMetadata, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)inputMetadata, pipelineMeta, transformName);
        this.input = (CypherBuilderMeta)((Object)inputMetadata);
        this.copy = this.input.clone();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.shell.setLayout(this.createFormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"CypherBuilder.Transform.Name", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, this.margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.addOptionsTab();
        this.addParametersTab();
        this.addOperationsTab();
        this.addCypherTab();
        this.wTabFolder.setLayoutData((Object)new FormDataBuilder().left().top(new FormAttachment((Control)this.wTransformName, this.margin)).right().bottom(new FormAttachment((Control)this.wOk, -2 * this.margin)).result());
        this.getData();
        this.shell.addListener(26, e -> this.showExperimentalWarning());
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Options.Label", (String[])new String[0]));
        wOptionsTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Options.ToolTip", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        wOptionsComp.setLayout((Layout)new FormLayout());
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, NeoConnection.class, wOptionsComp, 18436, "Neo4j Connection", "The name of the Neo4j connection to use");
        PropsUi.setLook(this.wConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, 0);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting list of connections", e2);
        }
        TextVar lastControl = this.wConnection;
        Label wlBatchSize = new Label(wOptionsComp, 131072);
        wlBatchSize.setText("Batch size (rows)");
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(this.middle, -this.margin);
        fdlBatchSize.top = new FormAttachment(lastControl, 2 * this.margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(this.middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        this.wBatchSize.addListener(24, e -> this.copy.setBatchSize(this.wBatchSize.getText()));
        lastControl = this.wBatchSize;
        Label wlUnwindAlias = new Label(wOptionsComp, 131072);
        wlUnwindAlias.setText("Unwind map alias");
        wlUnwindAlias.setToolTipText("Set this to enable UNWIND style cypher building.  The map is called $rows so you can call this row");
        PropsUi.setLook((Widget)wlUnwindAlias);
        FormData fdlUnwindAlias = new FormData();
        fdlUnwindAlias.left = new FormAttachment(0, 0);
        fdlUnwindAlias.right = new FormAttachment(this.middle, -this.margin);
        fdlUnwindAlias.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlUnwindAlias.setLayoutData((Object)fdlUnwindAlias);
        this.wUnwindAlias = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wUnwindAlias);
        FormData fdUnwindAlias = new FormData();
        fdUnwindAlias.left = new FormAttachment(this.middle, 0);
        fdUnwindAlias.right = new FormAttachment(100, 0);
        fdUnwindAlias.top = new FormAttachment((Control)wlUnwindAlias, 0, 0x1000000);
        this.wUnwindAlias.setLayoutData((Object)fdUnwindAlias);
        this.wUnwindAlias.addListener(24, e -> this.copy.setUnwindAlias(this.wUnwindAlias.getText()));
        lastControl = this.wUnwindAlias;
        Label wlRetries = new Label(wOptionsComp, 131072);
        wlRetries.setText("Maximum retries");
        wlRetries.setToolTipText("This is the maximum number of times a transaction will be re-tried on the database before giving up.");
        PropsUi.setLook((Widget)wlRetries);
        FormData fdlRetries = new FormData();
        fdlRetries.left = new FormAttachment(0, 0);
        fdlRetries.right = new FormAttachment(this.middle, -this.margin);
        fdlRetries.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlRetries.setLayoutData((Object)fdlRetries);
        this.wRetries = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wRetries);
        FormData fdRetries = new FormData();
        fdRetries.left = new FormAttachment(this.middle, 0);
        fdRetries.right = new FormAttachment(100, 0);
        fdRetries.top = new FormAttachment((Control)wlRetries, 0, 0x1000000);
        this.wRetries.setLayoutData((Object)fdRetries);
        this.wRetries.addListener(24, e -> this.copy.setRetries(this.wRetries.getText()));
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void addParametersTab() {
        String[] fieldNames;
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Parameters.Label", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Parameters.ToolTip", (String[])new String[0]));
        Composite wParametersComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wParametersComp);
        wParametersComp.setLayout(this.createFormLayout());
        try {
            fieldNames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames();
        }
        catch (Exception e2) {
            this.logError("Unable to get fields from previous transform", e2);
            fieldNames = new String[]{};
        }
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo("Parameter", 1, false), new ColumnInfo("Input field", 2, fieldNames, false), new ColumnInfo("Neo4j Type", 2, GraphPropertyType.getNames(), false)};
        Label wlParameters = new Label(wParametersComp, 16384);
        wlParameters.setText("Parameters: (NOTE that parameters for labels are not supported)");
        PropsUi.setLook((Widget)wlParameters);
        FormData fdlParameters = new FormData();
        fdlParameters.left = new FormAttachment(0, 0);
        fdlParameters.right = new FormAttachment(100, 0);
        fdlParameters.top = new FormAttachment(0, 0);
        wlParameters.setLayoutData((Object)fdlParameters);
        Button wbGetParameters = new Button(wParametersComp, 8);
        wbGetParameters.setText("Get parameters");
        FormData fdbGetParameters = new FormData();
        fdbGetParameters.right = new FormAttachment(100, 0);
        fdbGetParameters.top = new FormAttachment((Control)wlParameters, 0, 1024);
        wbGetParameters.setLayoutData((Object)fdbGetParameters);
        wbGetParameters.addListener(13, e -> {
            try {
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wParameters, (int)2, (int[])new int[]{2}, (int[])new int[0], (int)-1, (int)-1, (item, valueMeta) -> Neo4JOutputDialog.getPropertyNameTypePrimary(item, valueMeta, new int[]{1}, new int[]{3}, -1));
            }
            catch (Exception ex) {
                new ErrorDialog(this.shell, "Error", "Error getting transform input fields", ex);
            }
        });
        this.wParameters = new TableView(this.variables, wParametersComp, 67586, parameterColumns, this.input.getParameters().size(), null, this.props);
        PropsUi.setLook((Widget)this.wParameters);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.right = new FormAttachment((Control)wbGetParameters, -this.margin);
        fdParameters.top = new FormAttachment((Control)wlParameters, this.margin);
        fdParameters.bottom = new FormAttachment(100, 0);
        this.wParameters.setLayoutData((Object)fdParameters);
        wParametersComp.layout();
        wParametersTab.setControl((Control)wParametersComp);
    }

    private void addOperationsTab() {
        CTabItem wOperationsTab = new CTabItem(this.wTabFolder, 0);
        wOperationsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOperationsTab.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Operations.Label", (String[])new String[0]));
        wOperationsTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Operations.ToolTip", (String[])new String[0]));
        SashForm sashForm = new SashForm((Composite)this.wTabFolder, 256);
        wOperationsTab.setControl((Control)sashForm);
        Composite wOperationsComp = new Composite((Composite)sashForm, 0);
        PropsUi.setLook((Widget)wOperationsComp);
        wOperationsComp.setLayout(this.createFormLayout());
        FormData fdOperationsComp = new FormData();
        fdOperationsComp.left = new FormAttachment(0, 0);
        fdOperationsComp.top = new FormAttachment(0, 0);
        fdOperationsComp.right = new FormAttachment(100, 0);
        fdOperationsComp.bottom = new FormAttachment(100, 0);
        wOperationsComp.setLayoutData((Object)fdOperationsComp);
        ToolBar wOperationsBar = new ToolBar(wOperationsComp, 0x800000);
        PropsUi.setLook((Widget)wOperationsBar);
        FormData fdOperationsBar = new FormData();
        fdOperationsBar.top = new FormAttachment(0, 0);
        fdOperationsBar.left = new FormAttachment(0, 0);
        fdOperationsBar.right = new FormAttachment(100, 0);
        wOperationsBar.setLayoutData((Object)fdOperationsBar);
        ToolItem addOperationItem = new ToolItem(wOperationsBar, 8);
        addOperationItem.setImage(GuiResource.getInstance().getImageAdd());
        addOperationItem.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.OperationAdd.Tooltip", (String[])new String[0]));
        addOperationItem.addListener(13, e -> this.operationAdd());
        ToolItem deleteOperationItem = new ToolItem(wOperationsBar, 8);
        deleteOperationItem.setImage(GuiResource.getInstance().getImageDelete());
        deleteOperationItem.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.OperationDelete.Tooltip", (String[])new String[0]));
        deleteOperationItem.addListener(13, e -> this.operationDelete());
        ToolItem moveUpOperationItem = new ToolItem(wOperationsBar, 8);
        moveUpOperationItem.setImage(GuiResource.getInstance().getImageUp());
        moveUpOperationItem.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.OperationMoveUp.Tooltip", (String[])new String[0]));
        moveUpOperationItem.addListener(13, e -> this.operationMoveUp());
        ToolItem moveDownOperationItem = new ToolItem(wOperationsBar, 8);
        moveDownOperationItem.setImage(GuiResource.getInstance().getImageDown());
        moveDownOperationItem.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.OperationMoveDown.Tooltip", (String[])new String[0]));
        moveDownOperationItem.addListener(13, e -> this.operationMoveDown());
        this.wOperationsList = new org.eclipse.swt.widgets.List(wOperationsComp, 2564);
        PropsUi.setLook((Widget)this.wOperationsList);
        FormData fdOperationsList = new FormData();
        fdOperationsList.left = new FormAttachment(0, 0);
        fdOperationsList.right = new FormAttachment(100, 0);
        fdOperationsList.top = new FormAttachment((Control)wOperationsBar, this.margin);
        fdOperationsList.bottom = new FormAttachment(100, 0);
        this.wOperationsList.setLayoutData((Object)fdOperationsList);
        this.wOperationsList.addListener(13, e -> this.operationEdit());
        this.wOperationsList.setItems(this.copy.getOperationNames());
        this.wOperationComp = new Composite((Composite)sashForm, 0);
        FormData fdOperationComp = new FormData();
        fdOperationComp.left = new FormAttachment(0, 0);
        fdOperationComp.right = new FormAttachment(100, 0);
        fdOperationComp.top = new FormAttachment(0, 0);
        fdOperationComp.bottom = new FormAttachment(100, 0);
        this.wOperationComp.setLayoutData((Object)fdOperationComp);
        this.wOperationComp.setLayout(this.createFormLayout());
        PropsUi.setLook((Widget)wOperationsComp);
        wOperationsComp.setBackground(GuiResource.getInstance().getColorBackground());
        sashForm.setWeights(new int[]{20, 80});
    }

    private void operationEdit() {
        int selectionIndex = this.wOperationsList.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        String operationName = this.wOperationsList.getItem(selectionIndex);
        IOperation operation = this.copy.findOperation(operationName);
        if (operation == null) {
            return;
        }
        this.removeOperationsWidgets();
        switch (operation.getOperationType()) {
            case MATCH: {
                this.addOperationMatch(operation);
                break;
            }
            case MERGE: {
                this.addOperationMerge(operation);
                break;
            }
            case CREATE: {
                this.addOperationCreate(operation);
                break;
            }
            case DELETE: {
                this.addOperationDelete(operation);
                break;
            }
            case EDGE_MATCH: 
            case EDGE_MERGE: 
            case EDGE_CREATE: {
                this.addOperationEdgeMatch(operation);
                break;
            }
            case ORDER_BY: {
                this.addOperationOrderBy(operation);
                break;
            }
            case RETURN: {
                this.addOperationReturn(operation);
                break;
            }
            case SET: {
                this.addOperationSet(operation);
            }
        }
        this.wOperationComp.layout(true, true);
    }

    private void removeOperationsWidgets() {
        for (Control child : this.wOperationComp.getChildren()) {
            child.dispose();
        }
    }

    private void addOperationMatch(IOperation operation) {
        MatchOperation matchOperation = (MatchOperation)operation;
        Control lastControl = this.addOperationWidgetName(matchOperation);
        lastControl = this.addOperationWidgetType(matchOperation, lastControl);
        lastControl = this.addOperationWidgetLabels(matchOperation, lastControl);
        lastControl = this.addOperationWidgetText(matchOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Tooltip", (String[])new String[0]), matchOperation.getAlias(), c -> matchOperation.setAlias(c.getText()));
        this.addOperationWidgetKeys(matchOperation, lastControl);
    }

    private void addOperationMerge(IOperation operation) {
        MergeOperation mergeOperation = (MergeOperation)operation;
        Control lastControl = this.addOperationWidgetName(mergeOperation);
        lastControl = this.addOperationWidgetType(mergeOperation, lastControl);
        lastControl = this.addOperationWidgetLabels(mergeOperation, lastControl);
        lastControl = this.addOperationWidgetText(mergeOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Tooltip", (String[])new String[0]), mergeOperation.getAlias(), c -> mergeOperation.setAlias(c.getText()));
        lastControl = this.addOperationWidgetKeys(mergeOperation, lastControl);
        this.addOperationWidgetProperties(mergeOperation, lastControl);
    }

    private void addOperationCreate(IOperation operation) {
        CreateOperation createOperation = (CreateOperation)operation;
        Control lastControl = this.addOperationWidgetName(createOperation);
        lastControl = this.addOperationWidgetType(createOperation, lastControl);
        lastControl = this.addOperationWidgetLabels(createOperation, lastControl);
        lastControl = this.addOperationWidgetText(createOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Tooltip", (String[])new String[0]), createOperation.getAlias(), c -> createOperation.setAlias(c.getText()));
        lastControl = this.addOperationWidgetKeys(createOperation, lastControl);
        this.addOperationWidgetProperties(createOperation, lastControl);
    }

    private void addOperationDelete(IOperation operation) {
        DeleteOperation deleteOperation = (DeleteOperation)operation;
        Control lastControl = this.addOperationWidgetName(deleteOperation);
        lastControl = this.addOperationWidgetType(deleteOperation, lastControl);
        lastControl = this.addOperationWidgetDetachDelete(deleteOperation, lastControl);
        lastControl = this.addOperationWidgetLabels(deleteOperation, lastControl);
        lastControl = this.addOperationWidgetText(deleteOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeAlias.Tooltip", (String[])new String[0]), deleteOperation.getAlias(), c -> deleteOperation.setAlias(c.getText()));
        this.addOperationWidgetKeys(deleteOperation, lastControl);
    }

    private void addOperationEdgeMatch(IOperation operation) {
        EdgeMatchOperation edgeMatchOperation = (EdgeMatchOperation)operation;
        Control lastControl = this.addOperationWidgetName(edgeMatchOperation);
        lastControl = this.addOperationWidgetType(edgeMatchOperation, lastControl);
        lastControl = this.addOperationWidgetText(edgeMatchOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.SourceNodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.SourceNodeAlias.Tooltip", (String[])new String[0]), edgeMatchOperation.getSourceAlias(), c -> edgeMatchOperation.setSourceAlias(c.getText()));
        lastControl = this.addOperationWidgetText(edgeMatchOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.EdgeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.EdgeAlias.Tooltip", (String[])new String[0]), edgeMatchOperation.getEdgeAlias(), c -> edgeMatchOperation.setEdgeAlias(c.getText()));
        lastControl = this.addOperationWidgetText(edgeMatchOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.EdgeLabel.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.EdgeLabel.Tooltip", (String[])new String[0]), edgeMatchOperation.getEdgeLabel(), c -> edgeMatchOperation.setEdgeLabel(c.getText()));
        this.addOperationWidgetText(edgeMatchOperation, lastControl, BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.TargetNodeAlias.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.TargetNodeAlias.Tooltip", (String[])new String[0]), edgeMatchOperation.getTargetAlias(), c -> edgeMatchOperation.setTargetAlias(c.getText()));
    }

    private void addOperationOrderBy(IOperation operation) {
        OrderByOperation orderByOperation = (OrderByOperation)operation;
        Control lastControl = this.addOperationWidgetName(orderByOperation);
        lastControl = this.addOperationWidgetType(orderByOperation, lastControl);
        this.addOperationWidgetOrderByProperties(orderByOperation, lastControl);
    }

    private void addOperationReturn(IOperation operation) {
        ReturnOperation returnOperation = (ReturnOperation)operation;
        Control lastControl = this.addOperationWidgetName(returnOperation);
        lastControl = this.addOperationWidgetType(returnOperation, lastControl);
        this.addOperationWidgetReturnValues(returnOperation, lastControl);
    }

    private void addOperationSet(IOperation operation) {
        SetOperation setOperation = (SetOperation)operation;
        Control lastControl = this.addOperationWidgetName(setOperation);
        lastControl = this.addOperationWidgetType(setOperation, lastControl);
        this.addOperationWidgetSetProperties(setOperation, lastControl);
    }

    private void operationAdd() {
        String[] operationDescriptions = OperationType.getOperationDescriptions();
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, operationDescriptions, "Add Operation", "Select the operation to add:", null, this.variables);
        String operationChoice = dialog.open();
        if (operationChoice == null) {
            return;
        }
        OperationType operationType = OperationType.getOperationByDescription(operationChoice);
        if (operationType == null) {
            return;
        }
        IOperation operation = OperationFactory.createOperation(operationType);
        operation.setName(operation.getOperationType().getDescription());
        this.copy.getOperations().add(operation);
        this.wOperationsList.add(operation.getName());
        this.wOperationsList.setSelection(this.copy.getOperations().size() - 1);
        this.operationEdit();
    }

    private void operationDelete() {
        int selectionIndex = this.wOperationsList.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        this.removeOperationsWidgets();
        this.copy.getOperations().remove(selectionIndex);
        this.wOperationsList.remove(selectionIndex);
        this.operationEdit();
    }

    private void operationMoveUp() {
    }

    private void operationMoveDown() {
    }

    private Control addOperationWidgetText(BaseOperation operation, Control lastControl, String label, String toolTip, String value, ITextChanged changed) {
        Label wlText = new Label(this.wOperationComp, 131072);
        wlText.setText(label);
        wlText.setToolTipText(toolTip);
        FormData fdlText = new FormData();
        fdlText.left = new FormAttachment(0, 0);
        fdlText.right = new FormAttachment(this.middle, 0);
        fdlText.top = new FormAttachment(lastControl, this.margin);
        wlText.setLayoutData((Object)fdlText);
        Text wText = new Text(this.wOperationComp, 18436);
        wText.setText(Const.NVL((String)value, (String)""));
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(this.middle, this.margin);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)wlText, 0, 0x1000000);
        wText.setLayoutData((Object)fdText);
        wText.addListener(24, e -> changed.changed(wText));
        return wText;
    }

    private Control addOperationWidgetType(IOperation operation, Control lastControl) {
        Label wlOperationType = new Label(this.wOperationComp, 131072);
        wlOperationType.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeOperationType.Label", (String[])new String[0]));
        wlOperationType.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.NodeOperationType.Tooltip", (String[])new String[0]));
        FormData fdlOperationType = new FormData();
        fdlOperationType.top = new FormAttachment(lastControl, this.margin);
        fdlOperationType.left = new FormAttachment(0, 0);
        fdlOperationType.right = new FormAttachment(this.middle, 0);
        wlOperationType.setLayoutData((Object)fdlOperationType);
        Text wOperationType = new Text(this.wOperationComp, 18436);
        wOperationType.setText(Const.NVL((String)operation.getOperationType().keyWord(), (String)""));
        wOperationType.setEditable(false);
        FormData fdOperationType = new FormData();
        fdOperationType.left = new FormAttachment(this.middle, this.margin);
        fdOperationType.right = new FormAttachment(100, 0);
        fdOperationType.top = new FormAttachment((Control)wlOperationType, 0, 0x1000000);
        wOperationType.setLayoutData((Object)fdOperationType);
        return wOperationType;
    }

    private Control addOperationWidgetDetachDelete(DeleteOperation operation, Control lastControl) {
        Label wlDetachDelete = new Label(this.wOperationComp, 131072);
        wlDetachDelete.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.DetachDelete.Label", (String[])new String[0]));
        wlDetachDelete.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.DetachDelete.Tooltip", (String[])new String[0]));
        FormData fdlDetachDelete = new FormData();
        fdlDetachDelete.left = new FormAttachment(0, 0);
        fdlDetachDelete.right = new FormAttachment(this.middle, 0);
        fdlDetachDelete.top = new FormAttachment(0, 0);
        wlDetachDelete.setLayoutData((Object)fdlDetachDelete);
        Button wDetachDelete = new Button(this.wOperationComp, 16416);
        wDetachDelete.setSelection(operation.isDetach());
        FormData fdDetachDelete = new FormData();
        fdDetachDelete.left = new FormAttachment(this.middle, this.margin);
        fdDetachDelete.right = new FormAttachment(100, 0);
        fdDetachDelete.top = new FormAttachment((Control)wlDetachDelete, 0, 0x1000000);
        wDetachDelete.setLayoutData((Object)fdDetachDelete);
        wDetachDelete.addListener(13, e -> operation.setDetach(wDetachDelete.getSelection()));
        return wDetachDelete;
    }

    private Control addOperationWidgetLabels(BaseOperation operation, Control lastControl) {
        Label wlLabels = new Label(this.wOperationComp, 131072);
        wlLabels.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Labels.Label", (String[])new String[0]));
        wlLabels.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Labels.Tooltip", (String[])new String[0]));
        FormData fdlLabels = new FormData();
        fdlLabels.top = new FormAttachment(lastControl, this.margin);
        fdlLabels.left = new FormAttachment(0, 0);
        fdlLabels.right = new FormAttachment(this.middle, 0);
        wlLabels.setLayoutData((Object)fdlLabels);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Labels.Column.Label", (String[])new String[0]), 1, false, false)};
        TableView wLabels = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getLabels().size(), false, null, this.props);
        FormData fdLabels = new FormData();
        fdLabels.top = new FormAttachment(lastControl, this.margin);
        fdLabels.left = new FormAttachment(this.middle, this.margin);
        fdLabels.right = new FormAttachment(100, 0);
        fdLabels.bottom = new FormAttachment(lastControl, this.margin + (int)(100.0 * this.props.getZoomFactor()));
        wLabels.setLayoutData((Object)fdLabels);
        for (int i = 0; i < operation.getLabels().size(); ++i) {
            TableItem item = wLabels.table.getItem(i);
            item.setText(1, Const.NVL((String)operation.getLabels().get(i), (String)""));
        }
        wLabels.optimizeTableView();
        Function<TableItem, String> itemFunction = tableItem -> tableItem.getText(1);
        wLabels.addModifyListener(new TableViewModified<String>(wLabels, operation.getLabels(), itemFunction));
        return wLabels;
    }

    private Control addOperationWidgetName(IOperation operation) {
        Label wlName = new Label(this.wOperationComp, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Name.Label", (String[])new String[0]));
        wlName.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Name.Tooltip", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, 0);
        wlName.setLayoutData((Object)fdlName);
        Text wName = new Text(this.wOperationComp, 18436);
        wName.setText(Const.NVL((String)operation.getName(), (String)""));
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(this.middle, this.margin);
        fdName.right = new FormAttachment(100, 0);
        wName.setLayoutData((Object)fdName);
        wName.addListener(24, e -> {
            operation.setName(wName.getText());
            this.wOperationsList.setItem(this.wOperationsList.getSelectionIndex(), Const.NVL((String)wName.getText(), (String)""));
        });
        return wlName;
    }

    private Control addOperationWidgetKeys(BaseOperation operation, Control lastControl) {
        Label wlKeys = new Label(this.wOperationComp, 131072);
        wlKeys.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Keys.Label", (String[])new String[0]));
        wlKeys.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Keys.Tooltip", (String[])new String[0]));
        FormData fdlKeys = new FormData();
        fdlKeys.top = new FormAttachment(lastControl, this.margin);
        fdlKeys.left = new FormAttachment(0, 0);
        fdlKeys.right = new FormAttachment(this.middle, 0);
        wlKeys.setLayoutData((Object)fdlKeys);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Keys.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Keys.Column.Parameter", (String[])new String[0]), 2, false, false)};
        columns[1].setComboValues(this.copy.getParameterNames());
        TableView wKeys = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getKeys().size(), false, null, this.props);
        FormData fdKeys = new FormData();
        fdKeys.left = new FormAttachment(this.middle, this.margin);
        fdKeys.right = new FormAttachment(100, 0);
        fdKeys.top = new FormAttachment(lastControl, this.margin);
        fdKeys.bottom = new FormAttachment(lastControl, this.margin + (int)(150.0 * this.props.getZoomFactor()));
        wKeys.setLayoutData((Object)fdKeys);
        for (int i = 0; i < operation.getKeys().size(); ++i) {
            TableItem item = wKeys.table.getItem(i);
            Property key = operation.getKeys().get(i);
            item.setText(1, Const.NVL((String)key.getName(), (String)""));
            item.setText(2, Const.NVL((String)key.getParameter(), (String)""));
        }
        wKeys.optimizeTableView();
        Function<TableItem, Property> itemFunction = tableItem -> new Property(operation.getAlias(), tableItem.getText(1), tableItem.getText(2));
        wKeys.addModifyListener(new TableViewModified<Property>(wKeys, operation.getKeys(), itemFunction));
        return wKeys;
    }

    private Control addOperationWidgetProperties(BaseOperation operation, Control lastControl) {
        Label wlProperties = new Label(this.wOperationComp, 131072);
        wlProperties.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Label", (String[])new String[0]));
        wlProperties.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Tooltip", (String[])new String[0]));
        FormData fdlProperties = new FormData();
        fdlProperties.left = new FormAttachment(0, 0);
        fdlProperties.right = new FormAttachment(this.middle, 0);
        fdlProperties.top = new FormAttachment(lastControl, this.margin);
        wlProperties.setLayoutData((Object)fdlProperties);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Expression", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Parameter", (String[])new String[0]), 2, false, false)};
        columns[2].setComboValues(this.copy.getParameterNames());
        TableView wProperties = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getProperties().size(), false, null, this.props);
        FormData fdProperties = new FormData();
        fdProperties.left = new FormAttachment(this.middle, this.margin);
        fdProperties.right = new FormAttachment(100, 0);
        fdProperties.top = new FormAttachment(lastControl, this.margin);
        fdProperties.bottom = new FormAttachment(100, 0);
        wProperties.setLayoutData((Object)fdProperties);
        for (int i = 0; i < operation.getProperties().size(); ++i) {
            TableItem item2 = wProperties.table.getItem(i);
            Property property = operation.getProperties().get(i);
            item2.setText(1, Const.NVL((String)property.getName(), (String)""));
            item2.setText(2, Const.NVL((String)property.getExpression(), (String)""));
            item2.setText(3, Const.NVL((String)property.getParameter(), (String)""));
        }
        wProperties.optimizeTableView();
        Function<TableItem, Property> itemFunction = item -> new Property(operation.getAlias(), item.getText(1), item.getText(2), item.getText(3), item.getText(4));
        wProperties.addModifyListener(new TableViewModified<Property>(wProperties, operation.getProperties(), itemFunction));
        return wProperties;
    }

    private Control addOperationWidgetOrderByProperties(BaseOperation operation, Control lastControl) {
        Label wlProperties = new Label(this.wOperationComp, 131072);
        wlProperties.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.OrderByProperties.Label", (String[])new String[0]));
        wlProperties.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.OrderByProperties.Tooltip", (String[])new String[0]));
        FormData fdlProperties = new FormData();
        fdlProperties.left = new FormAttachment(0, 0);
        fdlProperties.right = new FormAttachment(this.middle, 0);
        fdlProperties.top = new FormAttachment(lastControl, this.margin);
        wlProperties.setLayoutData((Object)fdlProperties);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Alias", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Expression", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Descending", (String[])new String[0]), 2, new String[]{"N", "Y"}, false)};
        TableView wProperties = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getProperties().size(), false, null, this.props);
        FormData fdProperties = new FormData();
        fdProperties.left = new FormAttachment(this.middle, this.margin);
        fdProperties.right = new FormAttachment(100, 0);
        fdProperties.top = new FormAttachment(lastControl, this.margin);
        fdProperties.bottom = new FormAttachment(100, 0);
        wProperties.setLayoutData((Object)fdProperties);
        for (int i = 0; i < operation.getProperties().size(); ++i) {
            TableItem item2 = wProperties.table.getItem(i);
            Property property = operation.getProperties().get(i);
            item2.setText(1, Const.NVL((String)property.getAlias(), (String)""));
            item2.setText(2, Const.NVL((String)property.getName(), (String)""));
            item2.setText(3, Const.NVL((String)property.getExpression(), (String)""));
            item2.setText(4, property.isDescending() ? "Y" : "N");
        }
        wProperties.optimizeTableView();
        Function<TableItem, Property> itemFunction = item -> new Property(item.getText(1), item.getText(2), item.getText(3), null, null, "Y".equalsIgnoreCase(item.getText(4)));
        wProperties.addModifyListener(new TableViewModified<Property>(wProperties, operation.getProperties(), itemFunction));
        return wProperties;
    }

    private Control addOperationWidgetReturnValues(ReturnOperation operation, Control lastControl) {
        Label wlReturnValues = new Label(this.wOperationComp, 131072);
        wlReturnValues.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Label", (String[])new String[0]));
        wlReturnValues.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Tooltip", (String[])new String[0]));
        FormData fdlReturnValues = new FormData();
        fdlReturnValues.left = new FormAttachment(0, 0);
        fdlReturnValues.right = new FormAttachment(this.middle, 0);
        fdlReturnValues.top = new FormAttachment(lastControl, this.margin);
        wlReturnValues.setLayoutData((Object)fdlReturnValues);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.Alias", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.Property", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.Expression", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.Parameter", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.Rename", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.NeoType", (String[])new String[0]), 2, GraphPropertyDataType.getNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.ReturnValues.Column.HopType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false)};
        TableView wReturnValues = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getReturnValues().size(), false, null, this.props);
        FormData fdReturnValues = new FormData();
        fdReturnValues.left = new FormAttachment(this.middle, this.margin);
        fdReturnValues.right = new FormAttachment(100, 0);
        fdReturnValues.top = new FormAttachment(lastControl, this.margin);
        fdReturnValues.bottom = new FormAttachment(100, 0);
        wReturnValues.setLayoutData((Object)fdReturnValues);
        for (int i = 0; i < operation.getReturnValues().size(); ++i) {
            TableItem item2 = wReturnValues.table.getItem(i);
            ReturnValue returnValue = operation.getReturnValues().get(i);
            item2.setText(1, Const.NVL((String)returnValue.getAlias(), (String)""));
            item2.setText(2, Const.NVL((String)returnValue.getProperty(), (String)""));
            item2.setText(3, Const.NVL((String)returnValue.getExpression(), (String)""));
            item2.setText(3, Const.NVL((String)returnValue.getParameter(), (String)""));
            item2.setText(4, Const.NVL((String)returnValue.getRename(), (String)""));
        }
        wReturnValues.optimizeTableView();
        wReturnValues.addModifyListener(new TableViewModified<ReturnValue>(wReturnValues, operation.getReturnValues(), item -> new ReturnValue(item.getText(1), item.getText(2), item.getText(3), item.getText(4), item.getText(5), item.getText(6), item.getText(7))));
        return wReturnValues;
    }

    private Control addOperationWidgetSetProperties(SetOperation operation, Control lastControl) {
        Label wlProperties = new Label(this.wOperationComp, 131072);
        wlProperties.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.SetProperties.Label", (String[])new String[0]));
        wlProperties.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.SetProperties.Tooltip", (String[])new String[0]));
        FormData fdlProperties = new FormData();
        fdlProperties.left = new FormAttachment(0, 0);
        fdlProperties.right = new FormAttachment(this.middle, 0);
        fdlProperties.top = new FormAttachment(lastControl, this.margin);
        wlProperties.setLayoutData((Object)fdlProperties);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Alias", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Parameter", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Operation.Properties.Column.Expression", (String[])new String[0]), 1, false, false)};
        columns[2].setComboValues(this.copy.getParameterNames());
        TableView wProperties = new TableView(this.variables, this.wOperationComp, 0, columns, operation.getProperties().size(), false, null, this.props);
        FormData fdProperties = new FormData();
        fdProperties.left = new FormAttachment(this.middle, this.margin);
        fdProperties.right = new FormAttachment(100, 0);
        fdProperties.top = new FormAttachment(lastControl, this.margin);
        fdProperties.bottom = new FormAttachment(100, 0);
        wProperties.setLayoutData((Object)fdProperties);
        for (int i = 0; i < operation.getProperties().size(); ++i) {
            TableItem item2 = wProperties.table.getItem(i);
            Property property = operation.getProperties().get(i);
            item2.setText(1, Const.NVL((String)property.getAlias(), (String)""));
            item2.setText(2, Const.NVL((String)property.getName(), (String)""));
            item2.setText(3, Const.NVL((String)property.getParameter(), (String)""));
            item2.setText(4, Const.NVL((String)property.getExpression(), (String)""));
        }
        wProperties.optimizeTableView();
        Function<TableItem, Property> itemFunction = item -> new Property(item.getText(1), item.getText(2), item.getText(4), item.getText(3), null, false);
        wProperties.addModifyListener(new TableViewModified<Property>(wProperties, operation.getProperties(), itemFunction));
        return wProperties;
    }

    private void addCypherTab() {
        CTabItem wCypherTab = new CTabItem(this.wTabFolder, 0);
        wCypherTab.setFont(GuiResource.getInstance().getFontDefault());
        wCypherTab.setText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Cypher.Label", (String[])new String[0]));
        wCypherTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherBuilderDialog.Tab.Cypher.ToolTip", (String[])new String[0]));
        Composite wCypherComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wCypherComp);
        wCypherComp.setLayout(this.createFormLayout());
        this.wCypher = new Text(wCypherComp, 19202);
        this.wCypher.setFont(GuiResource.getInstance().getFontFixed());
        PropsUi.setLook((Widget)this.wCypher);
        FormData fdCypher = new FormData();
        fdCypher.left = new FormAttachment(0, 0);
        fdCypher.right = new FormAttachment(100, 0);
        fdCypher.top = new FormAttachment(0, 0);
        fdCypher.bottom = new FormAttachment(100, 0);
        this.wCypher.setLayoutData((Object)fdCypher);
        this.wCypher.setEditable(false);
        wCypherComp.layout();
        wCypherTab.setControl((Control)wCypherComp);
        Listener cypherRefresh = e -> {
            try {
                this.wCypher.setText(Const.NVL((String)this.copy.getCypher(this.variables), (String)""));
            }
            catch (Exception ex) {
                this.wCypher.setText("Error building cypher statement: " + Const.CR + Const.CR + Const.getSimpleStackTrace((Throwable)ex));
            }
        };
        this.wTabFolder.addListener(13, e -> {
            if (e.item.equals(wCypherTab)) {
                cypherRefresh.handleEvent(e);
            }
        });
    }

    private Layout createFormLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = PropsUi.getFormMargin();
        formLayout.marginRight = PropsUi.getFormMargin();
        formLayout.marginTop = PropsUi.getFormMargin();
        formLayout.marginBottom = PropsUi.getFormMargin();
        return formLayout;
    }

    private void enableFields() {
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.copy.getConnectionName(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.copy.getBatchSize(), (String)""));
        this.wUnwindAlias.setText(Const.NVL((String)this.copy.getUnwindAlias(), (String)""));
        this.wRetries.setText(Const.NVL((String)this.copy.getRetries(), (String)""));
        for (int i = 0; i < this.copy.getParameters().size(); ++i) {
            Parameter parameter = this.copy.getParameters().get(i);
            TableItem item = this.wParameters.table.getItem(i);
            item.setText(1, Const.NVL((String)parameter.getName(), (String)""));
            item.setText(2, Const.NVL((String)parameter.getInputFieldName(), (String)""));
            item.setText(3, Const.NVL((String)parameter.getNeoType(), (String)""));
        }
        this.wParameters.removeEmptyRows();
        this.wParameters.setRowNums();
        this.wParameters.optWidth(true);
        if (!this.copy.getOperations().isEmpty()) {
            this.wOperationsList.select(0);
            this.operationEdit();
        }
        this.enableFields();
    }

    public void showExperimentalWarning() {
        if (this.warningShown) {
            return;
        }
        this.warningShown = true;
        MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, "Work in progress", "This transform is not finished yet! \nIt's intended to get feedback from you. \nIt's not intended to be used in production", 8, new String[]{BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0])}, "Don't show this message again", "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_EXPERIMENTAL_WARNING, "Y")));
        md.open();
        this.props.setCustomParameter(STRING_EXPERIMENTAL_WARNING, md.getToggleState() ? "N" : "Y");
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    private void getInfo(CypherBuilderMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setUnwindAlias(this.wUnwindAlias.getText());
        meta.setRetries(this.wRetries.getText());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < this.wParameters.nrNonEmpty(); ++i) {
            TableItem item = this.wParameters.getNonEmpty(i);
            parameters.add(new Parameter(item.getText(1), item.getText(2), item.getText(3)));
        }
        meta.setParameters(parameters);
        meta.setOperations(this.copy.getOperations());
    }

    private static interface ITextChanged {
        public void changed(Text var1);
    }

    private class TableViewModified<T>
    implements ModifyListener {
        private final TableView tableView;
        private final List<T> list;
        private final Function<TableItem, T> itemFunction;

        public TableViewModified(TableView tableView, List<T> list, Function<TableItem, T> itemFunction) {
            this.tableView = tableView;
            this.list = list;
            this.itemFunction = itemFunction;
        }

        public void modifyText(ModifyEvent e) {
            String newValue = "";
            if (e.widget instanceof Text) {
                newValue = ((Text)e.widget).getText();
            } else if (e.widget instanceof TextVar) {
                newValue = ((TextVar)e.widget).getText();
            } else if (e.widget instanceof CCombo) {
                newValue = ((CCombo)e.widget).getText();
            } else if (e.widget instanceof Combo) {
                newValue = ((Combo)e.widget).getText();
            } else if (e.widget instanceof ComboVar) {
                newValue = ((ComboVar)e.widget).getText();
            }
            TableItem activeItem = this.tableView.table.getSelection()[0];
            int activeColumn = this.tableView.getActiveTableColumn();
            String oldValue = activeItem.getText(activeColumn);
            activeItem.setText(activeColumn, newValue);
            this.list.clear();
            for (TableItem item : this.tableView.getNonEmptyItems()) {
                this.list.add(this.itemFunction.apply(item));
            }
        }
    }
}

