/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.gui.plugin.IGuiActionLambda;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.util.StringUtil;

public class GuiAction {
    private String id;
    private GuiActionType type;
    private String name;
    private String tooltip;
    private String image;
    private IGuiActionLambda actionLambda;
    private String guiPluginClassName;
    private String guiPluginMethodName;
    private ClassLoader classLoader;
    private List<String> keywords = new ArrayList<String>();
    private String category;
    private String categoryOrder;

    public GuiAction() {
    }

    public GuiAction(String id, GuiActionType type, String name, String tooltip, String image, IGuiActionLambda actionLambda) {
        this();
        this.id = id;
        this.type = type;
        this.name = name;
        this.tooltip = tooltip;
        this.image = image;
        this.actionLambda = actionLambda;
    }

    public GuiAction(String id, GuiActionType type, String name, String tooltip, String image, String guiPluginClassName, String guiPluginMethodName) {
        this();
        this.id = id;
        this.type = type;
        this.name = name;
        this.tooltip = tooltip;
        this.image = image;
        this.guiPluginClassName = guiPluginClassName;
        this.guiPluginMethodName = guiPluginMethodName;
    }

    public GuiAction(GuiAction guiAction) {
        this();
        this.id = guiAction.id;
        this.type = guiAction.type;
        this.name = guiAction.name;
        this.tooltip = guiAction.tooltip;
        this.image = guiAction.image;
        this.guiPluginClassName = guiAction.guiPluginClassName;
        this.guiPluginMethodName = guiAction.guiPluginMethodName;
        this.actionLambda = guiAction.actionLambda;
        for (String keyword : guiAction.getKeywords()) {
            this.keywords.add(keyword);
        }
        this.category = guiAction.category;
        this.categoryOrder = guiAction.categoryOrder;
        this.classLoader = guiAction.getClassLoader();
    }

    public boolean containsFilterStrings(String[] filters) {
        for (String filter : filters) {
            if (this.containsFilterString(filter)) continue;
            return false;
        }
        return true;
    }

    public boolean containsFilterString(String filter) {
        if (filter == null) {
            return false;
        }
        if (this.matchesString(this.name, filter = StringUtil.removeDiacriticalMarks(filter))) {
            return true;
        }
        if (this.matchesString(this.tooltip, filter)) {
            return true;
        }
        if (this.type != null && this.matchesString(this.type.name(), filter)) {
            return true;
        }
        for (String keyword : this.keywords) {
            if (!this.matchesString(keyword, filter)) continue;
            return true;
        }
        return this.matchesString(this.category, filter);
    }

    private boolean matchesString(String string, String filter) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        string = StringUtil.removeDiacriticalMarks(string);
        return string.toUpperCase().contains(filter.toUpperCase());
    }

    public String toString() {
        return "GuiAction{id='" + this.id + "', type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "', tooltip='" + this.tooltip + "'}";
    }

    public String getShortName() {
        if (this.name == null) {
            return null;
        }
        if (this.name.length() < 30) {
            return this.name;
        }
        return this.name.substring(0, 28) + "...";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiAction guiAction = (GuiAction)o;
        return this.id.equals(guiAction.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GuiActionType getType() {
        return this.type;
    }

    public void setType(GuiActionType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IGuiActionLambda getActionLambda() {
        return this.actionLambda;
    }

    public void setActionLambda(IGuiActionLambda actionLambda) {
        this.actionLambda = actionLambda;
    }

    public String getGuiPluginClassName() {
        return this.guiPluginClassName;
    }

    public void setGuiPluginClassName(String guiPluginClassName) {
        this.guiPluginClassName = guiPluginClassName;
    }

    public String getGuiPluginMethodName() {
        return this.guiPluginMethodName;
    }

    public void setGuiPluginMethodName(String guiPluginMethodName) {
        this.guiPluginMethodName = guiPluginMethodName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryOrder() {
        return this.categoryOrder;
    }

    public void setCategoryOrder(String categoryOrder) {
        this.categoryOrder = categoryOrder;
    }
}

