/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.append;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.append.AppendData;
import org.apache.hop.pipeline.transforms.append.AppendMeta;

public class Append
extends BaseTransform<AppendMeta, AppendData> {
    private static final Class<?> PKG = Append.class;

    public Append(TransformMeta transformMeta, AppendMeta meta, AppendData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] input = null;
        if (((AppendData)this.data).processHead) {
            input = this.getRowFrom(((AppendData)this.data).headRowSet);
            if (input == null) {
                ((AppendData)this.data).processHead = false;
                ((AppendData)this.data).processTail = true;
            } else if (((AppendData)this.data).outputRowMeta == null) {
                ((AppendData)this.data).outputRowMeta = ((AppendData)this.data).headRowSet.getRowMeta();
            }
        }
        if (((AppendData)this.data).processTail) {
            input = this.getRowFrom(((AppendData)this.data).tailRowSet);
            if (input == null) {
                this.setOutputDone();
                return false;
            }
            if (((AppendData)this.data).outputRowMeta == null) {
                ((AppendData)this.data).outputRowMeta = ((AppendData)this.data).tailRowSet.getRowMeta();
            }
            if (((AppendData)this.data).firstTail) {
                ((AppendData)this.data).firstTail = false;
                try {
                    this.checkInputLayoutValid(((AppendData)this.data).headRowSet.getRowMeta(), ((AppendData)this.data).tailRowSet.getRowMeta());
                }
                catch (HopRowException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Append.Exception.InvalidLayoutDetected", (String[])new String[0]), (Throwable)e);
                }
            }
        }
        if (input != null) {
            this.putRow(((AppendData)this.data).outputRowMeta, input);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Append.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((AppendData)this.data).processHead = true;
            ((AppendData)this.data).processTail = false;
            ((AppendData)this.data).firstTail = true;
            List infoStreams = ((AppendMeta)this.meta).getTransformIOMeta().getInfoStreams();
            IStream headStream = (IStream)infoStreams.get(0);
            IStream tailStream = (IStream)infoStreams.get(1);
            if (((AppendMeta)this.meta).headTransformName != null) {
                headStream.setTransformMeta(this.getPipelineMeta().findTransform(((AppendMeta)this.meta).headTransformName));
            }
            if (((AppendMeta)this.meta).tailTransformName != null) {
                tailStream.setTransformMeta(this.getPipelineMeta().findTransform(((AppendMeta)this.meta).tailTransformName));
            }
            if (headStream.getTransformName() == null || tailStream.getTransformName() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"Append.Log.BothHopsAreNeeded", (String[])new String[0]));
            } else {
                try {
                    ((AppendData)this.data).headRowSet = this.findInputRowSet(headStream.getTransformName());
                    ((AppendData)this.data).tailRowSet = this.findInputRowSet(tailStream.getTransformName());
                    return true;
                }
                catch (Exception e) {
                    this.logError(e.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    protected void checkInputLayoutValid(IRowMeta referenceRowMeta, IRowMeta compareRowMeta) throws HopRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseTransform.safeModeChecking((IRowMeta)referenceRowMeta, (IRowMeta)compareRowMeta);
        }
    }
}

