/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.io.IOException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.server.HttpUtil;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PipelineConfiguration {
    public static final String XML_TAG = "pipeline_configuration";
    private PipelineMeta pipelineMeta;
    private PipelineExecutionConfiguration pipelineExecutionConfiguration;
    private SerializableMetadataProvider metadataProvider;

    public PipelineConfiguration(PipelineMeta pipelineMeta, PipelineExecutionConfiguration pipelineExecutionConfiguration, SerializableMetadataProvider metadataProvider) {
        this.pipelineMeta = pipelineMeta;
        this.pipelineExecutionConfiguration = pipelineExecutionConfiguration;
        this.metadataProvider = metadataProvider;
    }

    public String getXml(IVariables variables) throws IOException, HopException, HopException {
        StringBuilder xml = new StringBuilder(200);
        xml.append("<pipeline_configuration>").append(Const.CR);
        xml.append(this.pipelineMeta.getXml(variables));
        xml.append(this.pipelineExecutionConfiguration.getXml(variables));
        String jsonString = HttpUtil.encodeBase64ZippedString((String)this.metadataProvider.toJson());
        xml.append(XmlHandler.addTagValue((String)"metastore_json", (String)jsonString));
        xml.append("</pipeline_configuration>").append(Const.CR);
        return xml.toString();
    }

    public PipelineConfiguration(Node configNode) throws HopException, HopException, ParseException, IOException {
        Node trecNode = XmlHandler.getSubNode((Node)configNode, (String)"pipeline_execution_configuration");
        this.pipelineExecutionConfiguration = new PipelineExecutionConfiguration(trecNode);
        String metaStoreJson = HttpUtil.decodeBase64ZippedString((String)XmlHandler.getTagValue((Node)configNode, (String)"metastore_json"));
        this.metadataProvider = new SerializableMetadataProvider(metaStoreJson);
        Node pipelineNode = XmlHandler.getSubNode((Node)configNode, (String)"pipeline");
        this.pipelineMeta = new PipelineMeta(pipelineNode, this.metadataProvider);
    }

    public static final PipelineConfiguration fromXml(String xml) throws HopException, HopException, ParseException, IOException {
        Document document = XmlHandler.loadXmlString((String)xml);
        Node configNode = XmlHandler.getSubNode((Node)document, (String)XML_TAG);
        return new PipelineConfiguration(configNode);
    }

    public PipelineExecutionConfiguration getPipelineExecutionConfiguration() {
        return this.pipelineExecutionConfiguration;
    }

    public void setPipelineExecutionConfiguration(PipelineExecutionConfiguration pipelineExecutionConfiguration) {
        this.pipelineExecutionConfiguration = pipelineExecutionConfiguration;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public SerializableMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }
}

