/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.util.TypeComparable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.types.Value;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Visitor;

@Internal
public class CollectionExecutor {
    private final Map<Operator<?>, List<?>> intermediateResults;
    private final Map<String, Accumulator<?, ?>> accumulators;
    private final Map<String, Future<Path>> cachedFiles;
    private final Map<String, Value> previousAggregates;
    private final Map<String, Aggregator<?>> aggregators;
    private final ClassLoader userCodeClassLoader;
    private final ExecutionConfig executionConfig;
    private int iterationSuperstep;

    public CollectionExecutor(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
        this.intermediateResults = new HashMap();
        this.accumulators = new HashMap();
        this.previousAggregates = new HashMap<String, Value>();
        this.aggregators = new HashMap();
        this.cachedFiles = new HashMap<String, Future<Path>>();
        this.userCodeClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public JobExecutionResult execute(Plan program) throws Exception {
        long startTime = System.currentTimeMillis();
        JobID jobID = program.getJobId() == null ? new JobID() : program.getJobId();
        this.initCache(program.getCachedFiles());
        Collection<GenericDataSinkBase<?>> sinks = program.getDataSinks();
        for (Operator operator : sinks) {
            this.execute(operator, jobID);
        }
        long endTime = System.currentTimeMillis();
        Map<String, OptionalFailure<Object>> accumulatorResults = AccumulatorHelper.toResultMap(this.accumulators);
        return new JobExecutionResult(null, endTime - startTime, accumulatorResults);
    }

    private void initCache(Set<Map.Entry<String, DistributedCache.DistributedCacheEntry>> files) {
        for (Map.Entry<String, DistributedCache.DistributedCacheEntry> file : files) {
            CompletedFuture doNothing = new CompletedFuture(new Path(file.getValue().filePath));
            this.cachedFiles.put(file.getKey(), doNothing);
        }
    }

    private List<?> execute(Operator<?> operator, JobID jobID) throws Exception {
        return this.execute(operator, 0, jobID);
    }

    private List<?> execute(Operator<?> operator, int superStep, JobID jobID) throws Exception {
        List<Object> result = this.intermediateResults.get(operator);
        if (result != null) {
            return result;
        }
        if (operator instanceof BulkIterationBase) {
            result = this.executeBulkIteration((BulkIterationBase)operator, jobID);
        } else if (operator instanceof DeltaIterationBase) {
            result = this.executeDeltaIteration((DeltaIterationBase)operator, jobID);
        } else if (operator instanceof SingleInputOperator) {
            result = this.executeUnaryOperator((SingleInputOperator)operator, superStep, jobID);
        } else if (operator instanceof DualInputOperator) {
            result = this.executeBinaryOperator((DualInputOperator)operator, superStep, jobID);
        } else if (operator instanceof GenericDataSourceBase) {
            result = this.executeDataSource((GenericDataSourceBase)operator, superStep, jobID);
        } else if (operator instanceof GenericDataSinkBase) {
            this.executeDataSink((GenericDataSinkBase)operator, superStep, jobID);
            result = Collections.emptyList();
        } else {
            throw new RuntimeException("Cannot execute operator " + operator.getClass().getName());
        }
        this.intermediateResults.put(operator, result);
        return result;
    }

    private <IN> void executeDataSink(GenericDataSinkBase<?> sink, int superStep, JobID jobID) throws Exception {
        Operator<?> inputOp = sink.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The data sink " + sink.getName() + " has no input.");
        }
        List<?> input = this.execute(inputOp, jobID);
        GenericDataSinkBase<?> typedSink = sink;
        TaskInfo taskInfo = new TaskInfo(typedSink.getName(), 1, 0, 1, 0);
        RuntimeUDFContext ctx = RichOutputFormat.class.isAssignableFrom(typedSink.getUserCodeWrapper().getUserCodeClass()) ? this.createContext(superStep, taskInfo, jobID) : null;
        typedSink.executeOnCollections(input, ctx, this.executionConfig);
    }

    private RuntimeUDFContext createContext(int superStep, TaskInfo taskInfo, JobID jobID) {
        OperatorMetricGroup metrics = UnregisteredMetricsGroup.createOperatorMetricGroup();
        return superStep == 0 ? new RuntimeUDFContext(taskInfo, this.userCodeClassLoader, this.executionConfig, this.cachedFiles, this.accumulators, metrics, jobID) : new IterationRuntimeUDFContext(taskInfo, this.userCodeClassLoader, this.executionConfig, this.cachedFiles, this.accumulators, metrics, jobID);
    }

    private <OUT> List<OUT> executeDataSource(GenericDataSourceBase<?, ?> source, int superStep, JobID jobID) throws Exception {
        GenericDataSourceBase<?, ?> typedSource = source;
        TaskInfo taskInfo = new TaskInfo(typedSource.getName(), 1, 0, 1, 0);
        RuntimeUDFContext ctx = RichInputFormat.class.isAssignableFrom(typedSource.getUserCodeWrapper().getUserCodeClass()) ? this.createContext(superStep, taskInfo, jobID) : null;
        return typedSource.executeOnCollections(ctx, this.executionConfig);
    }

    private <IN, OUT> List<OUT> executeUnaryOperator(SingleInputOperator<?, ?, ?> operator, int superStep, JobID jobID) throws Exception {
        RuntimeUDFContext ctx;
        Operator<?> inputOp = operator.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The unary operation " + operator.getName() + " has no input.");
        }
        List<?> inputData = this.execute(inputOp, superStep, jobID);
        SingleInputOperator<?, ?, ?> typedOp = operator;
        TaskInfo taskInfo = new TaskInfo(typedOp.getName(), 1, 0, 1, 0);
        if (RichFunction.class.isAssignableFrom(typedOp.getUserCodeWrapper().getUserCodeClass())) {
            ctx = this.createContext(superStep, taskInfo, jobID);
            for (Map.Entry<String, Operator<?>> bcInputs : operator.getBroadcastInputs().entrySet()) {
                List<?> bcData = this.execute(bcInputs.getValue(), jobID);
                ctx.setBroadcastVariable(bcInputs.getKey(), bcData);
            }
        } else {
            ctx = null;
        }
        return typedOp.executeOnCollections(inputData, ctx, this.executionConfig);
    }

    private <IN1, IN2, OUT> List<OUT> executeBinaryOperator(DualInputOperator<?, ?, ?, ?> operator, int superStep, JobID jobID) throws Exception {
        RuntimeUDFContext ctx;
        Operator<?> inputOp1 = operator.getFirstInput();
        Operator<?> inputOp2 = operator.getSecondInput();
        if (inputOp1 == null) {
            throw new InvalidProgramException("The binary operation " + operator.getName() + " has no first input.");
        }
        if (inputOp2 == null) {
            throw new InvalidProgramException("The binary operation " + operator.getName() + " has no second input.");
        }
        List<?> inputData1 = this.execute(inputOp1, superStep, jobID);
        List<?> inputData2 = this.execute(inputOp2, superStep, jobID);
        DualInputOperator<?, ?, ?, ?> typedOp = operator;
        TaskInfo taskInfo = new TaskInfo(typedOp.getName(), 1, 0, 1, 0);
        if (RichFunction.class.isAssignableFrom(typedOp.getUserCodeWrapper().getUserCodeClass())) {
            ctx = this.createContext(superStep, taskInfo, jobID);
            for (Map.Entry<String, Operator<?>> bcInputs : operator.getBroadcastInputs().entrySet()) {
                List<?> bcData = this.execute(bcInputs.getValue(), jobID);
                ctx.setBroadcastVariable(bcInputs.getKey(), bcData);
            }
        } else {
            ctx = null;
        }
        return typedOp.executeOnCollections(inputData1, inputData2, ctx, this.executionConfig);
    }

    private <T> List<T> executeBulkIteration(BulkIterationBase<?> iteration, JobID jobID) throws Exception {
        Operator inputOp = iteration.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no input (initial partial solution).");
        }
        if (iteration.getNextPartialSolution() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no next partial solution defined (is not closed).");
        }
        List<?> inputData = this.execute(inputOp, jobID);
        LinkedHashSet dynamics = new LinkedHashSet();
        DynamicPathCollector dynCollector = new DynamicPathCollector(dynamics);
        iteration.getNextPartialSolution().accept(dynCollector);
        if (iteration.getTerminationCriterion() != null) {
            iteration.getTerminationCriterion().accept(dynCollector);
        }
        for (AggregatorWithName<?> a : iteration.getAggregators().getAllRegisteredAggregators()) {
            this.aggregators.put(a.getName(), a.getAggregator());
        }
        String convCriterionAggName = iteration.getAggregators().getConvergenceCriterionAggregatorName();
        ConvergenceCriterion<?> convCriterion = iteration.getAggregators().getConvergenceCriterion();
        List<?> currentResult = inputData;
        int maxIterations = iteration.getMaximumNumberOfIterations();
        for (int superstep = 1; superstep <= maxIterations; ++superstep) {
            Object v;
            this.intermediateResults.put(iteration.getPartialSolution(), currentResult);
            this.iterationSuperstep = superstep;
            currentResult = this.execute(iteration.getNextPartialSolution(), superstep, jobID);
            if (iteration.getTerminationCriterion() != null) {
                this.execute(iteration.getTerminationCriterion(), superstep, jobID);
            }
            if (convCriterion != null && convCriterionAggName != null && convCriterion.isConverged(superstep, v = this.aggregators.get(convCriterionAggName).getAggregate())) break;
            for (Operator operator : dynamics) {
                this.intermediateResults.remove(operator);
            }
            for (Map.Entry entry : this.aggregators.entrySet()) {
                this.previousAggregates.put((String)entry.getKey(), (Value)((Aggregator)entry.getValue()).getAggregate());
                ((Aggregator)entry.getValue()).reset();
            }
        }
        this.previousAggregates.clear();
        this.aggregators.clear();
        return currentResult;
    }

    private <T> List<T> executeDeltaIteration(DeltaIterationBase<?, ?> iteration, JobID jobID) throws Exception {
        Operator<?> solutionInput = iteration.getInitialSolutionSet();
        Operator<?> worksetInput = iteration.getInitialWorkset();
        if (solutionInput == null) {
            throw new InvalidProgramException("The delta iteration " + iteration.getName() + " has no initial solution set.");
        }
        if (worksetInput == null) {
            throw new InvalidProgramException("The delta iteration " + iteration.getName() + " has no initial workset.");
        }
        if (iteration.getSolutionSetDelta() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no solution set delta defined (is not closed).");
        }
        if (iteration.getNextWorkset() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no workset defined (is not closed).");
        }
        List<?> solutionInputData = this.execute(solutionInput, jobID);
        List<?> worksetInputData = this.execute(worksetInput, jobID);
        LinkedHashSet dynamics = new LinkedHashSet();
        DynamicPathCollector dynCollector = new DynamicPathCollector(dynamics);
        iteration.getSolutionSetDelta().accept(dynCollector);
        iteration.getNextWorkset().accept(dynCollector);
        OperatorInformation operatorInfo = iteration.getOperatorInfo();
        TypeInformation solutionType = ((BinaryOperatorInformation)operatorInfo).getFirstInputType();
        int[] keyColumns = iteration.getSolutionSetKeyFields();
        boolean[] inputOrderings = new boolean[keyColumns.length];
        TypeComparator inputComparator = ((CompositeType)solutionType).createComparator(keyColumns, inputOrderings, 0, this.executionConfig);
        HashMap solutionMap = new HashMap(solutionInputData.size());
        for (Object delta : solutionInputData) {
            TypeComparable typeComparable = new TypeComparable(delta, inputComparator);
            solutionMap.put(typeComparable, delta);
        }
        List<?> currentWorkset = worksetInputData;
        for (AggregatorWithName aggregatorWithName : iteration.getAggregators().getAllRegisteredAggregators()) {
            this.aggregators.put(aggregatorWithName.getName(), aggregatorWithName.getAggregator());
        }
        String convCriterionAggName = iteration.getAggregators().getConvergenceCriterionAggregatorName();
        ConvergenceCriterion<?> convergenceCriterion = iteration.getAggregators().getConvergenceCriterion();
        int maxIterations = iteration.getMaximumNumberOfIterations();
        for (int superstep = 1; superstep <= maxIterations; ++superstep) {
            Object v;
            ArrayList currentSolution = new ArrayList(solutionMap.size());
            currentSolution.addAll(solutionMap.values());
            this.intermediateResults.put(iteration.getSolutionSet(), currentSolution);
            this.intermediateResults.put(iteration.getWorkset(), currentWorkset);
            this.iterationSuperstep = superstep;
            List<?> solutionSetDelta = this.execute(iteration.getSolutionSetDelta(), superstep, jobID);
            this.intermediateResults.put(iteration.getSolutionSetDelta(), solutionSetDelta);
            for (Object obj : solutionSetDelta) {
                TypeComparable wrapper = new TypeComparable(obj, inputComparator);
                solutionMap.put(wrapper, obj);
            }
            currentWorkset = this.execute(iteration.getNextWorkset(), superstep, jobID);
            if (currentWorkset.isEmpty() || convergenceCriterion != null && convCriterionAggName != null && convergenceCriterion.isConverged(superstep, v = this.aggregators.get(convCriterionAggName).getAggregate())) break;
            for (Operator operator : dynamics) {
                this.intermediateResults.remove(operator);
            }
            for (Map.Entry entry : this.aggregators.entrySet()) {
                this.previousAggregates.put((String)entry.getKey(), (Value)((Aggregator)entry.getValue()).getAggregate());
                ((Aggregator)entry.getValue()).reset();
            }
        }
        this.previousAggregates.clear();
        this.aggregators.clear();
        ArrayList currentSolution = new ArrayList(solutionMap.size());
        currentSolution.addAll(solutionMap.values());
        return currentSolution;
    }

    private static final class CompletedFuture
    implements Future<Path> {
        private final Path result;

        public CompletedFuture(Path entry) {
            try {
                LocalFileSystem fs = (LocalFileSystem)FileSystem.getUnguardedFileSystem(entry.toUri());
                this.result = entry.isAbsolute() ? new Path(entry.toUri().getPath()) : new Path(fs.getWorkingDirectory(), entry);
            }
            catch (Exception e) {
                throw new RuntimeException("DistributedCache supports only local files for Collection Environments");
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Path get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public Path get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private class IterationRuntimeUDFContext
    extends RuntimeUDFContext
    implements IterationRuntimeContext {
        public IterationRuntimeUDFContext(TaskInfo taskInfo, ClassLoader classloader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup metrics, JobID jobID) {
            super(taskInfo, classloader, executionConfig, cpTasks, accumulators, metrics, jobID);
        }

        @Override
        public int getSuperstepNumber() {
            return CollectionExecutor.this.iterationSuperstep;
        }

        @Override
        public <T extends Aggregator<?>> T getIterationAggregator(String name) {
            return (T)((Aggregator)CollectionExecutor.this.aggregators.get(name));
        }

        @Override
        public <T extends Value> T getPreviousIterationAggregate(String name) {
            return (T)((Value)CollectionExecutor.this.previousAggregates.get(name));
        }
    }

    private static final class DynamicPathCollector
    implements Visitor<Operator<?>> {
        private final Set<Operator<?>> visited = new HashSet();
        private final Set<Operator<?>> dynamicPathOperations;

        public DynamicPathCollector(Set<Operator<?>> dynamicPathOperations) {
            this.dynamicPathOperations = dynamicPathOperations;
        }

        @Override
        public boolean preVisit(Operator<?> op) {
            return this.visited.add(op);
        }

        @Override
        public void postVisit(Operator<?> op) {
            if (op instanceof SingleInputOperator) {
                SingleInputOperator siop = (SingleInputOperator)op;
                if (this.dynamicPathOperations.contains(siop.getInput())) {
                    this.dynamicPathOperations.add(op);
                } else {
                    for (Operator<?> o : siop.getBroadcastInputs().values()) {
                        if (!this.dynamicPathOperations.contains(o)) continue;
                        this.dynamicPathOperations.add(op);
                        break;
                    }
                }
            } else if (op instanceof DualInputOperator) {
                DualInputOperator siop = (DualInputOperator)op;
                if (this.dynamicPathOperations.contains(siop.getFirstInput())) {
                    this.dynamicPathOperations.add(op);
                } else if (this.dynamicPathOperations.contains(siop.getSecondInput())) {
                    this.dynamicPathOperations.add(op);
                } else {
                    for (Operator<?> o : siop.getBroadcastInputs().values()) {
                        if (!this.dynamicPathOperations.contains(o)) continue;
                        this.dynamicPathOperations.add(op);
                        break;
                    }
                }
            } else if (op.getClass() == BulkIterationBase.PartialSolutionPlaceHolder.class || op.getClass() == DeltaIterationBase.WorksetPlaceHolder.class || op.getClass() == DeltaIterationBase.SolutionSetPlaceHolder.class) {
                this.dynamicPathOperations.add(op);
            } else if (!(op instanceof GenericDataSourceBase)) {
                throw new RuntimeException("Cannot handle operator type " + op.getClass().getName());
            }
        }
    }
}

