/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseOffsetDateTimeParser
extends ClickHouseDateValueParser<OffsetDateTime> {
    private static ClickHouseOffsetDateTimeParser instance;

    static ClickHouseOffsetDateTimeParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseOffsetDateTimeParser();
        }
        return instance;
    }

    private ClickHouseOffsetDateTimeParser() {
        super(OffsetDateTime.class);
    }

    @Override
    OffsetDateTime parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateToZonedDateTime(value, columnInfo, timeZone).toOffsetDateTime();
    }

    @Override
    OffsetDateTime parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateTimeToZonedDateTime(value, columnInfo, timeZone).toOffsetDateTime();
    }

    @Override
    OffsetDateTime parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.parseAsInstant(value).atZone(this.effectiveTimeZone(columnInfo, timeZone)).toOffsetDateTime();
    }

    @Override
    OffsetDateTime parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return this.parseAsLocalDateTime(value).atZone(this.effectiveTimeZone(columnInfo, timeZone)).toOffsetDateTime();
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return OffsetDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return this.parseAsInstant(value).atZone(this.effectiveTimeZone(columnInfo, timeZone)).toOffsetDateTime();
            }
        }
    }
}

