/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xslt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;

public class XsltData
extends BaseTransformData
implements ITransformData {
    public IRowMeta outputRowMeta;
    public int fieldposition = -1;
    public int fielxslfiledposition = -1;
    public String xslfilename = null;
    public int[] fieldsUsed;
    public TransformerFactory factory;
    public HashMap<String, Transformer> transformers = new HashMap();
    public int nrParams = 0;
    public int[] indexOfParams;
    public String[] nameOfParams;
    public boolean useParameters = false;
    public Properties outputProperties;
    public boolean setOutputProperties = false;
    public boolean xslIsAfile;

    public Transformer getTemplate(String xslFilename, boolean isAfile) throws Exception {
        Transformer template = this.transformers.get(xslFilename);
        if (template != null) {
            template.clearParameters();
            return template;
        }
        return this.createNewTemplate(xslFilename, isAfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer createNewTemplate(String xslSource, boolean isAfile) throws Exception {
        FileObject file = null;
        InputStream xslInputStream = null;
        Transformer transformer = null;
        try {
            if (isAfile) {
                file = HopVfs.getFileObject((String)xslSource);
                xslInputStream = HopVfs.getInputStream((FileObject)file);
            } else {
                xslInputStream = new ByteArrayInputStream(xslSource.getBytes("UTF-8"));
            }
            transformer = this.factory.newTransformer(new StreamSource(xslInputStream));
            this.transformers.put(xslSource, transformer);
            Transformer transformer2 = transformer;
            return transformer2;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (xslInputStream != null) {
                    xslInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() {
        this.transformers = null;
        this.factory = null;
        this.outputRowMeta = null;
        this.outputProperties = null;
    }
}

