/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BlockBasedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class AvroSource<T>
extends BlockBasedSource<T> {
    private static final long DEFAULT_MIN_BUNDLE_SIZE = 128000L;
    private static final DatumReaderFactory<?> GENERIC_DATUM_READER_FACTORY = GenericDatumReader::new;
    private static final DatumReaderFactory<?> REFLECT_DATUM_READER_FACTORY = ReflectDatumReader::new;
    private final Mode<T> mode;
    private static final Map<String, Schema> schemaLogicalReferenceCache = new WeakHashMap<String, Schema>();
    private static final Map<String, String> schemaStringLogicalReferenceCache = new WeakHashMap<String, String>();

    private static Mode<GenericRecord> readGenericRecordsWithSchema(String schema, @Nullable DatumReaderFactory<?> factory) {
        return new Mode<GenericRecord>(GenericRecord.class, schema, null, null, factory);
    }

    private static <T> Mode<T> readGeneratedClasses(Class<T> clazz, @Nullable DatumReaderFactory<?> factory) {
        return new Mode(clazz, ReflectData.get().getSchema(clazz).toString(), null, null, factory);
    }

    private static <T> Mode<T> parseGenericRecords(SerializableFunction<GenericRecord, T> parseFn, Coder<T> outputCoder, @Nullable DatumReaderFactory<?> factory) {
        return new Mode(GenericRecord.class, null, parseFn, outputCoder, factory);
    }

    public static AvroSource<GenericRecord> from(ValueProvider<String> fileNameOrPattern) {
        return new AvroSource<GenericRecord>(fileNameOrPattern, EmptyMatchTreatment.DISALLOW, 128000L, AvroSource.readGenericRecordsWithSchema(null, null));
    }

    public static AvroSource<GenericRecord> from(MatchResult.Metadata metadata) {
        return new AvroSource<GenericRecord>(metadata, 128000L, 0L, metadata.sizeBytes(), AvroSource.readGenericRecordsWithSchema(null, null));
    }

    public static AvroSource<GenericRecord> from(String fileNameOrPattern) {
        return AvroSource.from(ValueProvider.StaticValueProvider.of(fileNameOrPattern));
    }

    public AvroSource<T> withEmptyMatchTreatment(EmptyMatchTreatment emptyMatchTreatment) {
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), emptyMatchTreatment, this.getMinBundleSize(), this.mode);
    }

    public AvroSource<GenericRecord> withSchema(String schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        return new AvroSource<GenericRecord>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.readGenericRecordsWithSchema(schema, ((Mode)this.mode).readerFactory));
    }

    public AvroSource<GenericRecord> withSchema(Schema schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        return this.withSchema(schema.toString());
    }

    public <X> AvroSource<X> withSchema(Class<X> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<X>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), AvroSource.readGeneratedClasses(clazz, ((Mode)this.mode).readerFactory));
        }
        return new AvroSource<X>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.readGeneratedClasses(clazz, ((Mode)this.mode).readerFactory));
    }

    public <X> AvroSource<X> withParseFn(SerializableFunction<GenericRecord, X> parseFn, Coder<X> coder) {
        Preconditions.checkArgument((parseFn != null ? 1 : 0) != 0, (Object)"parseFn can not be null");
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<X>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), AvroSource.parseGenericRecords(parseFn, coder, ((Mode)this.mode).readerFactory));
        }
        return new AvroSource<X>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.parseGenericRecords(parseFn, coder, ((Mode)this.mode).readerFactory));
    }

    public AvroSource<T> withMinBundleSize(long minBundleSize) {
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), minBundleSize, this.getStartOffset(), this.getEndOffset(), this.mode);
        }
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), minBundleSize, this.mode);
    }

    public AvroSource<T> withDatumReaderFactory(DatumReaderFactory<?> factory) {
        Mode newMode = ((Mode)this.mode).withReaderFactory(factory);
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), newMode);
        }
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), newMode);
    }

    private AvroSource(ValueProvider<String> fileNameOrPattern, EmptyMatchTreatment emptyMatchTreatment, long minBundleSize, Mode<T> mode) {
        super(fileNameOrPattern, emptyMatchTreatment, minBundleSize);
        this.mode = mode;
    }

    private AvroSource(MatchResult.Metadata metadata, long minBundleSize, long startOffset, long endOffset, Mode<T> mode) {
        super(metadata, minBundleSize, startOffset, endOffset);
        this.mode = mode;
    }

    @Override
    public void validate() {
        super.validate();
        ((Mode)this.mode).validate();
    }

    @Deprecated
    public BlockBasedSource<T> createForSubrangeOfFile(String fileName, long start, long end) throws IOException {
        return this.createForSubrangeOfFile(FileSystems.matchSingleFileSpec(fileName), start, end);
    }

    @Override
    public BlockBasedSource<T> createForSubrangeOfFile(MatchResult.Metadata fileMetadata, long start, long end) {
        return new AvroSource<T>(fileMetadata, this.getMinBundleSize(), start, end, this.mode);
    }

    @Override
    protected BlockBasedSource.BlockBasedReader<T> createSingleFileReader(PipelineOptions options) {
        return new AvroReader(this);
    }

    @Override
    public Coder<T> getOutputCoder() {
        return ((Mode)this.mode).getOutputCoder();
    }

    @VisibleForTesting
    @Nullable String getReaderSchemaString() {
        return ((Mode)this.mode).readerSchemaString;
    }

    @VisibleForTesting
    static AvroMetadata readMetadataFromFile(ResourceId fileResource) throws IOException {
        byte[] syncMarker;
        String codec = null;
        String schemaString = null;
        try (InputStream stream = Channels.newInputStream(FileSystems.open(fileResource));){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(stream, null);
            byte[] magic = new byte[DataFileConstants.MAGIC.length];
            decoder.readFixed(magic);
            if (!Arrays.equals(magic, DataFileConstants.MAGIC)) {
                throw new IOException("Missing Avro file signature: " + fileResource);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(512);
            long numRecords = decoder.readMapStart();
            while (numRecords > 0L) {
                for (long recordIndex = 0L; recordIndex < numRecords; ++recordIndex) {
                    String key = decoder.readString();
                    valueBuffer = decoder.readBytes(valueBuffer);
                    byte[] bytes = new byte[valueBuffer.remaining()];
                    valueBuffer.get(bytes);
                    if (key.equals("avro.codec")) {
                        codec = new String(bytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!key.equals("avro.schema")) continue;
                    schemaString = new String(bytes, StandardCharsets.UTF_8);
                }
                numRecords = decoder.mapNext();
            }
            if (codec == null) {
                codec = "null";
            }
            syncMarker = new byte[16];
            decoder.readFixed(syncMarker);
        }
        Preconditions.checkState((schemaString != null ? 1 : 0) != 0, (String)"No schema present in Avro file metadata %s", (Object)fileResource);
        return new AvroMetadata(syncMarker, codec, schemaString);
    }

    private static synchronized String internSchemaString(String schema) {
        String internSchema = schemaStringLogicalReferenceCache.get(schema);
        if (internSchema != null) {
            return internSchema;
        }
        schemaStringLogicalReferenceCache.put(schema, schema);
        return schema;
    }

    static synchronized Schema internOrParseSchemaString(String schemaString) {
        Schema schema = schemaLogicalReferenceCache.get(schemaString);
        if (schema != null) {
            return schema;
        }
        Schema.Parser parser = new Schema.Parser();
        schema = parser.parse(schemaString);
        schemaLogicalReferenceCache.put(schemaString, schema);
        return schema;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.getMode()) {
            case SINGLE_FILE_OR_SUBRANGE: {
                return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), this.mode);
            }
            case FILEPATTERN: {
                return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), this.mode);
            }
        }
        throw new InvalidObjectException(String.format("Unknown mode %s for AvroSource %s", new Object[]{this.getMode(), this}));
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static class AvroReader<T>
    extends BlockBasedSource.BlockBasedReader<T> {
        private @Nullable AvroBlock<T> currentBlock;
        private @Nullable DataFileReader<?> dataFileReader;
        private final Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private long currentBlockOffset = 0L;
        @GuardedBy(value="progressLock")
        private long currentBlockSizeBytes = 0L;

        public AvroReader(AvroSource<T> source) {
            super(source);
        }

        @Override
        public synchronized AvroSource<T> getCurrentSource() {
            return (AvroSource)super.getCurrentSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readNextBlock() {
            if (!this.dataFileReader.hasNext()) {
                return false;
            }
            long headerLength = (long)VarInt.getLength(this.dataFileReader.getBlockCount()) + (long)VarInt.getLength(this.dataFileReader.getBlockSize()) + 16L;
            this.currentBlock = new AvroBlock((Iterator<?>)this.dataFileReader, ((AvroSource)this.getCurrentSource()).mode.parseFn, this.dataFileReader.getBlockCount());
            Object object = this.progressLock;
            synchronized (object) {
                this.currentBlockOffset = this.dataFileReader.previousSync();
                this.currentBlockSizeBytes = this.dataFileReader.getBlockSize() + headerLength;
            }
            return true;
        }

        @Override
        public AvroBlock<T> getCurrentBlock() {
            return this.currentBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentBlockOffset() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentBlockSize() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockSizeBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSplitPointsRemaining() {
            if (this.isDone()) {
                return 0L;
            }
            Object object = this.progressLock;
            synchronized (object) {
                if (this.currentBlockOffset + this.currentBlockSizeBytes >= this.getCurrentSource().getEndOffset()) {
                    return 1L;
                }
            }
            return super.getSplitPointsRemaining();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void startReading(ReadableByteChannel channel) throws IOException {
            SeekableChannelInput seekableChannelInput = new SeekableChannelInput((SeekableByteChannel)channel);
            seekableChannelInput.seek(0L);
            Schema readerSchema = null;
            String readerSchemaString = ((AvroSource)this.getCurrentSource()).getReaderSchemaString();
            if (readerSchemaString != null) {
                readerSchema = AvroSource.internOrParseSchemaString(readerSchemaString);
            }
            DatumReader reader = ((AvroSource)this.getCurrentSource()).mode.createReader(readerSchema, readerSchema);
            this.dataFileReader = new DataFileReader((SeekableInput)seekableChannelInput, reader);
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset != 0L) {
                this.dataFileReader.sync(Math.max(0L, startOffset - 16L));
            }
            Object object = this.progressLock;
            synchronized (object) {
                this.currentBlockOffset = this.dataFileReader.previousSync();
                this.currentBlockSizeBytes = 0L;
            }
        }

        private static class SeekableChannelInput
        implements SeekableInput {
            private final SeekableByteChannel channel;
            private final InputStream input;

            SeekableChannelInput(SeekableByteChannel channel) {
                this.channel = channel;
                this.input = Channels.newInputStream(channel);
            }

            public void seek(long p) throws IOException {
                this.channel.position(p);
            }

            public long tell() throws IOException {
                return this.channel.position();
            }

            public long length() throws IOException {
                return this.channel.size();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return this.input.read(b, off, len);
            }

            public void close() throws IOException {
                this.channel.close();
            }
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    static class AvroBlock<T>
    extends BlockBasedSource.Block<T> {
        private @Nullable T currentRecord;
        private long currentRecordIndex = 0L;
        private final Iterator<?> iterator;
        private final SerializableFunction<GenericRecord, T> parseFn;
        private final long numRecordsInBlock;

        AvroBlock(Iterator<?> iter, SerializableFunction<GenericRecord, T> parseFn, long numRecordsInBlock) {
            this.iterator = iter;
            this.parseFn = parseFn;
            this.numRecordsInBlock = numRecordsInBlock;
        }

        @Override
        public T getCurrentRecord() {
            return this.currentRecord;
        }

        @Override
        public boolean readNextRecord() {
            if (this.currentRecordIndex >= this.numRecordsInBlock) {
                return false;
            }
            Object record = this.iterator.next();
            this.currentRecord = this.parseFn == null ? record : this.parseFn.apply((GenericRecord)record);
            ++this.currentRecordIndex;
            return true;
        }

        @Override
        public double getFractionOfBlockConsumed() {
            return (double)this.currentRecordIndex / (double)this.numRecordsInBlock;
        }
    }

    @VisibleForTesting
    static class AvroMetadata {
        private final byte[] syncMarker;
        private final String codec;
        private final String schemaString;

        AvroMetadata(byte[] syncMarker, String codec, String schemaString) {
            this.syncMarker = (byte[])Preconditions.checkNotNull((Object)syncMarker, (Object)"syncMarker");
            this.codec = (String)Preconditions.checkNotNull((Object)codec, (Object)"codec");
            this.schemaString = AvroSource.internSchemaString((String)Preconditions.checkNotNull((Object)schemaString, (Object)"schemaString"));
        }

        public String getSchemaString() {
            return this.schemaString;
        }

        public String getCodec() {
            return this.codec;
        }

        public byte[] getSyncMarker() {
            return this.syncMarker;
        }
    }

    private static class Mode<T>
    implements Serializable {
        private final Class<?> type;
        private @Nullable String readerSchemaString;
        private final @Nullable SerializableFunction<GenericRecord, T> parseFn;
        private final @Nullable Coder<T> outputCoder;
        private final @Nullable DatumReaderFactory<?> readerFactory;

        private Mode(Class<?> type, @Nullable String readerSchemaString, @Nullable SerializableFunction<GenericRecord, T> parseFn, @Nullable Coder<T> outputCoder, @Nullable DatumReaderFactory<?> readerFactory) {
            this.type = type;
            this.readerSchemaString = AvroSource.internSchemaString(readerSchemaString);
            this.parseFn = parseFn;
            this.outputCoder = outputCoder;
            this.readerFactory = readerFactory;
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            this.readerSchemaString = AvroSource.internSchemaString(this.readerSchemaString);
        }

        private Coder<T> getOutputCoder() {
            if (this.parseFn == null) {
                return AvroCoder.of(this.type, AvroSource.internOrParseSchemaString(this.readerSchemaString));
            }
            return this.outputCoder;
        }

        private void validate() {
            if (this.parseFn == null) {
                Preconditions.checkArgument((this.readerSchemaString != null ? 1 : 0) != 0, (Object)"schema must be specified using withSchema() when not using a parse fn");
            }
        }

        private Mode<T> withReaderFactory(DatumReaderFactory<?> factory) {
            return new Mode<T>(this.type, this.readerSchemaString, this.parseFn, this.outputCoder, factory);
        }

        private DatumReader<?> createReader(Schema writerSchema, Schema readerSchema) {
            DatumReaderFactory factory = this.readerFactory;
            if (factory == null) {
                factory = this.type == GenericRecord.class ? GENERIC_DATUM_READER_FACTORY : REFLECT_DATUM_READER_FACTORY;
            }
            return factory.apply(writerSchema, readerSchema);
        }
    }

    @FunctionalInterface
    public static interface DatumReaderFactory<T>
    extends Serializable {
        public DatumReader<T> apply(Schema var1, Schema var2);
    }
}

