/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.state;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;

@Internal
public class StateContexts {
    private static final StateContext<BoundedWindow> NULL_CONTEXT = new StateContext<BoundedWindow>(){

        @Override
        public PipelineOptions getPipelineOptions() {
            throw new IllegalArgumentException("cannot call getPipelineOptions() in a null context");
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            throw new IllegalArgumentException("cannot call sideInput() in a null context");
        }

        @Override
        public BoundedWindow window() {
            throw new IllegalArgumentException("cannot call window() in a null context");
        }
    };

    public static <W extends BoundedWindow> StateContext<W> nullContext() {
        return NULL_CONTEXT;
    }

    public static <W extends BoundedWindow> StateContext<W> windowOnlyContext(W window) {
        return new WindowOnlyContext(window, null);
    }

    private static class WindowOnlyContext<W extends BoundedWindow>
    implements StateContext<W> {
        private final W window;

        private WindowOnlyContext(W window) {
            this.window = window;
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            throw new IllegalArgumentException("cannot call getPipelineOptions() in a window-only context");
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            throw new IllegalArgumentException("cannot call sideInput() in a window-only context");
        }

        @Override
        public W window() {
            return this.window;
        }

        /* synthetic */ WindowOnlyContext(BoundedWindow x0, 1 x1) {
            this(x0);
        }
    }
}

