/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PCollectionRowTuple
implements PInput,
POutput {
    final Pipeline pipeline;
    final Map<String, PCollection<Row>> pcollectionMap;

    public static PCollectionRowTuple empty(Pipeline pipeline) {
        return new PCollectionRowTuple(pipeline);
    }

    public static PCollectionRowTuple of(String tag, PCollection<Row> pc) {
        return PCollectionRowTuple.empty(pc.getPipeline()).and(tag, pc);
    }

    public static PCollectionRowTuple of(String tag1, PCollection<Row> pc1, String tag2, PCollection<Row> pc2) {
        return PCollectionRowTuple.of(tag1, pc1).and(tag2, pc2);
    }

    public static PCollectionRowTuple of(String tag1, PCollection<Row> pc1, String tag2, PCollection<Row> pc2, String tag3, PCollection<Row> pc3) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2).and(tag3, pc3);
    }

    public static PCollectionRowTuple of(String tag1, PCollection<Row> pc1, String tag2, PCollection<Row> pc2, String tag3, PCollection<Row> pc3, String tag4, PCollection<Row> pc4) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2, tag3, pc3).and(tag4, pc4);
    }

    public static PCollectionRowTuple of(String tag1, PCollection<Row> pc1, String tag2, PCollection<Row> pc2, String tag3, PCollection<Row> pc3, String tag4, PCollection<Row> pc4, String tag5, PCollection<Row> pc5) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2, tag3, pc3, tag4, pc4).and(tag5, pc5);
    }

    public PCollectionRowTuple and(String tag, PCollection<Row> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionRowTuple(this.pipeline, (Map<String, PCollection<Row>>)new ImmutableMap.Builder().putAll(this.pcollectionMap).put((Object)tag, pc).build());
    }

    public boolean has(String tag) {
        return this.pcollectionMap.containsKey(tag);
    }

    public PCollection<Row> get(String tag) {
        PCollection<Row> pcollection = this.pcollectionMap.get(tag);
        if (pcollection == null) {
            throw new IllegalArgumentException("Tag not found in this PCollectionRowTuple tuple");
        }
        return pcollection;
    }

    public Map<String, PCollection<Row>> getAll() {
        return this.pcollectionMap;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PCollectionRowTuple, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PCollectionRowTuple, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionRowTuple(Pipeline pipeline) {
        this(pipeline, new LinkedHashMap<String, PCollection<Row>>());
    }

    PCollectionRowTuple(Pipeline pipeline, Map<String, PCollection<Row>> pcollectionMap) {
        this.pipeline = pipeline;
        this.pcollectionMap = Collections.unmodifiableMap(pcollectionMap);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Map<TupleTag<?>, PValue> expand() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.pcollectionMap.forEach((tag, value) -> builder.put(new TupleTag((String)tag), value));
        return builder.build();
    }

    @Override
    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        for (Map.Entry<String, PCollection<Row>> entry : this.pcollectionMap.entrySet()) {
            String tag = entry.getKey();
            PCollection<Row> pc = entry.getValue();
            if (!pc.getName().equals(PValueBase.defaultName(transformName))) continue;
            pc.setName(String.format("%s.%s", transformName, tag));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PCollectionRowTuple)) {
            return false;
        }
        PCollectionRowTuple that = (PCollectionRowTuple)other;
        return this.pipeline.equals(that.pipeline) && this.pcollectionMap.equals(that.pcollectionMap);
    }

    public int hashCode() {
        return Objects.hash(this.pipeline, this.pcollectionMap);
    }
}

