/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.ElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.ElementPropertyConfig;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public class GraphSONUtility {
    private static final JsonNodeFactory jsonNodeFactory = JsonNodeFactory.instance;
    private static final JsonFactory jsonFactory = new MappingJsonFactory();
    private static final String EMPTY_STRING = "";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final GraphSONMode mode;
    private final List<String> vertexPropertyKeys;
    private final List<String> edgePropertyKeys;
    private final ElementFactory factory;
    private final boolean hasEmbeddedTypes;
    private final ElementPropertyConfig.ElementPropertiesRule vertexPropertiesRule;
    private final ElementPropertyConfig.ElementPropertiesRule edgePropertiesRule;
    private final boolean normalized;
    private final boolean includeReservedVertexId;
    private final boolean includeReservedEdgeId;
    private final boolean includeReservedVertexType;
    private final boolean includeReservedEdgeType;
    private final boolean includeReservedEdgeLabel;
    private final boolean includeReservedEdgeOutV;
    private final boolean includeReservedEdgeInV;

    public GraphSONUtility(GraphSONMode mode, ElementFactory factory) {
        this(mode, factory, ElementPropertyConfig.AllProperties);
    }

    public GraphSONUtility(GraphSONMode mode, ElementFactory factory, Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys) {
        this(mode, factory, ElementPropertyConfig.includeProperties(vertexPropertyKeys, edgePropertyKeys));
    }

    public GraphSONUtility(GraphSONMode mode, ElementFactory factory, ElementPropertyConfig config) {
        this.vertexPropertyKeys = config.getVertexPropertyKeys();
        this.edgePropertyKeys = config.getEdgePropertyKeys();
        this.vertexPropertiesRule = config.getVertexPropertiesRule();
        this.edgePropertiesRule = config.getEdgePropertiesRule();
        this.normalized = config.isNormalized();
        this.mode = mode;
        this.factory = factory;
        this.hasEmbeddedTypes = mode == GraphSONMode.EXTENDED;
        this.includeReservedVertexId = GraphSONUtility.includeReservedKey(mode, "_id", this.vertexPropertyKeys, this.vertexPropertiesRule);
        this.includeReservedEdgeId = GraphSONUtility.includeReservedKey(mode, "_id", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedVertexType = GraphSONUtility.includeReservedKey(mode, "_type", this.vertexPropertyKeys, this.vertexPropertiesRule);
        this.includeReservedEdgeType = GraphSONUtility.includeReservedKey(mode, "_type", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeLabel = GraphSONUtility.includeReservedKey(mode, "_label", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeOutV = GraphSONUtility.includeReservedKey(mode, "_outV", this.edgePropertyKeys, this.edgePropertiesRule);
        this.includeReservedEdgeInV = GraphSONUtility.includeReservedKey(mode, "_inV", this.edgePropertyKeys, this.edgePropertiesRule);
    }

    public Vertex vertexFromJson(JSONObject json) throws IOException {
        return this.vertexFromJson(json.toString());
    }

    public Vertex vertexFromJson(String json) throws IOException {
        JsonParser jp = jsonFactory.createParser(json);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return this.vertexFromJson(node);
    }

    public Vertex vertexFromJson(InputStream json) throws IOException {
        JsonParser jp = jsonFactory.createParser(json);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return this.vertexFromJson(node);
    }

    public Vertex vertexFromJson(JsonNode json) throws IOException {
        Map<String, Object> props = GraphSONUtility.readProperties(json, true, this.hasEmbeddedTypes);
        Object vertexId = GraphSONUtility.getTypedValueFromJsonNode(json.get("_id"));
        Object v = this.factory.createVertex(vertexId);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!GraphSONUtility.includeKey(entry.getKey(), this.vertexPropertyKeys, this.vertexPropertiesRule)) continue;
            v.setProperty(entry.getKey(), entry.getValue());
        }
        return v;
    }

    public Edge edgeFromJson(JSONObject json, Vertex out, Vertex in) throws IOException {
        return this.edgeFromJson(json.toString(), out, in);
    }

    public Edge edgeFromJson(String json, Vertex out, Vertex in) throws IOException {
        JsonParser jp = jsonFactory.createParser(json);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return this.edgeFromJson(node, out, in);
    }

    public Edge edgeFromJson(InputStream json, Vertex out, Vertex in) throws IOException {
        JsonParser jp = jsonFactory.createParser(json);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return this.edgeFromJson(node, out, in);
    }

    public Edge edgeFromJson(JsonNode json, Vertex out, Vertex in) throws IOException {
        Map<String, Object> props = GraphSONUtility.readProperties(json, true, this.hasEmbeddedTypes);
        Object edgeId = GraphSONUtility.getTypedValueFromJsonNode(json.get("_id"));
        JsonNode nodeLabel = json.get("_label");
        String label = nodeLabel == null ? EMPTY_STRING : nodeLabel.textValue();
        Object e = this.factory.createEdge(edgeId, out, in, label);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!GraphSONUtility.includeKey(entry.getKey(), this.edgePropertyKeys, this.edgePropertiesRule)) continue;
            e.setProperty(entry.getKey(), entry.getValue());
        }
        return e;
    }

    public JSONObject jsonFromElement(Element element) throws JSONException {
        ObjectNode objectNode = this.objectNodeFromElement(element);
        try {
            return new JSONObject(new JSONTokener(mapper.writeValueAsString((Object)objectNode)));
        }
        catch (IOException ioe) {
            throw new JSONException((Throwable)ioe);
        }
    }

    public ObjectNode objectNodeFromElement(Element element) {
        boolean isEdge = element instanceof Edge;
        boolean showTypes = this.mode == GraphSONMode.EXTENDED;
        List<String> propertyKeys = isEdge ? this.edgePropertyKeys : this.vertexPropertyKeys;
        ElementPropertyConfig.ElementPropertiesRule elementPropertyConfig = isEdge ? this.edgePropertiesRule : this.vertexPropertiesRule;
        ObjectNode jsonElement = GraphSONUtility.createJSONMap(GraphSONUtility.createPropertyMap(element, propertyKeys, elementPropertyConfig, this.normalized), propertyKeys, showTypes);
        if (isEdge && this.includeReservedEdgeId || !isEdge && this.includeReservedVertexId) {
            GraphSONUtility.putObject(jsonElement, "_id", element.getId());
        }
        if (element instanceof Edge) {
            Edge edge = (Edge)element;
            if (this.includeReservedEdgeId) {
                GraphSONUtility.putObject(jsonElement, "_id", element.getId());
            }
            if (this.includeReservedEdgeType) {
                jsonElement.put("_type", "edge");
            }
            if (this.includeReservedEdgeOutV) {
                GraphSONUtility.putObject(jsonElement, "_outV", edge.getVertex(Direction.OUT).getId());
            }
            if (this.includeReservedEdgeInV) {
                GraphSONUtility.putObject(jsonElement, "_inV", edge.getVertex(Direction.IN).getId());
            }
            if (this.includeReservedEdgeLabel) {
                jsonElement.put("_label", edge.getLabel());
            }
        } else if (element instanceof Vertex) {
            if (this.includeReservedVertexId) {
                GraphSONUtility.putObject(jsonElement, "_id", element.getId());
            }
            if (this.includeReservedVertexType) {
                jsonElement.put("_type", "vertex");
            }
        }
        return jsonElement;
    }

    public static Vertex vertexFromJson(JSONObject json, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, propertyKeys, null);
        return graphson.vertexFromJson(json);
    }

    public static Vertex vertexFromJson(String json, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, propertyKeys, null);
        return graphson.vertexFromJson(json);
    }

    public static Vertex vertexFromJson(InputStream json, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, propertyKeys, null);
        return graphson.vertexFromJson(json);
    }

    public static Vertex vertexFromJson(JsonNode json, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, propertyKeys, null);
        return graphson.vertexFromJson(json);
    }

    public static Edge edgeFromJson(JSONObject json, Vertex out, Vertex in, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, null, propertyKeys);
        return graphson.edgeFromJson(json, out, in);
    }

    public static Edge edgeFromJson(String json, Vertex out, Vertex in, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, null, propertyKeys);
        return graphson.edgeFromJson(json, out, in);
    }

    public static Edge edgeFromJson(InputStream json, Vertex out, Vertex in, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, null, propertyKeys);
        return graphson.edgeFromJson(json, out, in);
    }

    public static Edge edgeFromJson(JsonNode json, Vertex out, Vertex in, ElementFactory factory, GraphSONMode mode, Set<String> propertyKeys) throws IOException {
        GraphSONUtility graphson = new GraphSONUtility(mode, factory, null, propertyKeys);
        return graphson.edgeFromJson(json, out, in);
    }

    public static JSONObject jsonFromElement(Element element, Set<String> propertyKeys, GraphSONMode mode) throws JSONException {
        GraphSONUtility graphson = element instanceof Edge ? new GraphSONUtility(mode, null, null, propertyKeys) : new GraphSONUtility(mode, null, propertyKeys, null);
        return graphson.jsonFromElement(element);
    }

    public static ObjectNode objectNodeFromElement(Element element, Set<String> propertyKeys, GraphSONMode mode) {
        GraphSONUtility graphson = element instanceof Edge ? new GraphSONUtility(mode, null, null, propertyKeys) : new GraphSONUtility(mode, null, propertyKeys, null);
        return graphson.objectNodeFromElement(element);
    }

    private static ObjectNode objectNodeFromElement(Element element, List<String> propertyKeys, GraphSONMode mode) {
        GraphSONUtility graphson = element instanceof Edge ? new GraphSONUtility(mode, null, null, new HashSet<String>(propertyKeys)) : new GraphSONUtility(mode, null, new HashSet<String>(propertyKeys), null);
        return graphson.objectNodeFromElement(element);
    }

    static Map<String, Object> readProperties(JsonNode node, boolean ignoreReservedKeys, boolean hasEmbeddedTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Object o;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ignoreReservedKeys && GraphSONUtility.isReservedKey((String)entry.getKey()) || (o = GraphSONUtility.readProperty((JsonNode)entry.getValue(), hasEmbeddedTypes)) == null) continue;
            map.put((String)entry.getKey(), o);
        }
        return map;
    }

    private static boolean includeReservedKey(GraphSONMode mode, String key, List<String> propertyKeys, ElementPropertyConfig.ElementPropertiesRule rule) {
        return mode != GraphSONMode.COMPACT || GraphSONUtility.includeKey(key, propertyKeys, rule);
    }

    private static boolean includeKey(String key, List<String> propertyKeys, ElementPropertyConfig.ElementPropertiesRule rule) {
        if (propertyKeys == null) {
            return true;
        }
        boolean keySituation = rule == ElementPropertyConfig.ElementPropertiesRule.INCLUDE;
        switch (rule) {
            case INCLUDE: {
                keySituation = propertyKeys.contains(key);
                break;
            }
            case EXCLUDE: {
                keySituation = !propertyKeys.contains(key);
            }
        }
        return keySituation;
    }

    private static boolean isReservedKey(String key) {
        return key.equals("_id") || key.equals("_type") || key.equals("_label") || key.equals("_outV") || key.equals("_inV");
    }

    private static Object readProperty(JsonNode node, boolean hasEmbeddedTypes) {
        Object propertyValue = hasEmbeddedTypes ? (node.get("type").textValue().equals("unknown") ? null : (node.get("type").textValue().equals("boolean") ? Boolean.valueOf(node.get("value").booleanValue()) : (node.get("type").textValue().equals("float") ? Float.valueOf(Float.parseFloat(node.get("value").asText())) : (node.get("type").textValue().equals("byte") ? Byte.valueOf(Byte.parseByte(node.get("value").asText())) : (node.get("type").textValue().equals("short") ? Short.valueOf(Short.parseShort(node.get("value").asText())) : (node.get("type").textValue().equals("double") ? Double.valueOf(node.get("value").doubleValue()) : (node.get("type").textValue().equals("integer") ? Integer.valueOf(node.get("value").intValue()) : (node.get("type").textValue().equals("long") ? Long.valueOf(node.get("value").longValue()) : (node.get("type").textValue().equals("string") ? node.get("value").textValue() : (node.get("type").textValue().equals("list") ? GraphSONUtility.readProperties(node.get("value").elements(), hasEmbeddedTypes) : (node.get("type").textValue().equals("map") ? GraphSONUtility.readProperties(node.get("value"), false, hasEmbeddedTypes) : node.textValue()))))))))))) : (node.isNull() ? null : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isDouble() ? Double.valueOf(node.doubleValue()) : (node.isInt() ? Integer.valueOf(node.intValue()) : (node.isLong() ? Long.valueOf(node.longValue()) : (node.isTextual() ? node.textValue() : (node.isArray() ? GraphSONUtility.readProperties(node.elements(), hasEmbeddedTypes) : (node.isObject() ? GraphSONUtility.readProperties(node, false, hasEmbeddedTypes) : node.textValue()))))))));
        return propertyValue;
    }

    private static List readProperties(Iterator<JsonNode> listOfNodes, boolean hasEmbeddedTypes) {
        ArrayList<Object> array = new ArrayList<Object>();
        while (listOfNodes.hasNext()) {
            array.add(GraphSONUtility.readProperty(listOfNodes.next(), hasEmbeddedTypes));
        }
        return array;
    }

    private static ArrayNode createJSONList(List list, List<String> propertyKeys, boolean showTypes) {
        ArrayNode jsonList = jsonNodeFactory.arrayNode();
        for (Object item : list) {
            if (item instanceof Element) {
                jsonList.add((JsonNode)GraphSONUtility.objectNodeFromElement((Element)item, propertyKeys, showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL));
                continue;
            }
            if (item instanceof List) {
                jsonList.add((JsonNode)GraphSONUtility.createJSONList((List)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof Map) {
                jsonList.add((JsonNode)GraphSONUtility.createJSONMap((Map)item, propertyKeys, showTypes));
                continue;
            }
            if (item != null && item.getClass().isArray()) {
                jsonList.add((JsonNode)GraphSONUtility.createJSONList(GraphSONUtility.convertArrayToList(item), propertyKeys, showTypes));
                continue;
            }
            GraphSONUtility.addObject(jsonList, item);
        }
        return jsonList;
    }

    private static ObjectNode createJSONMap(Map map, List<String> propertyKeys, boolean showTypes) {
        ObjectNode jsonMap = jsonNodeFactory.objectNode();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value != null) {
                if (value instanceof List) {
                    value = GraphSONUtility.createJSONList((List)value, propertyKeys, showTypes);
                } else if (value instanceof Map) {
                    value = GraphSONUtility.createJSONMap((Map)value, propertyKeys, showTypes);
                } else if (value instanceof Element) {
                    value = GraphSONUtility.objectNodeFromElement((Element)value, propertyKeys, showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL);
                } else if (value.getClass().isArray()) {
                    value = GraphSONUtility.createJSONList(GraphSONUtility.convertArrayToList(value), propertyKeys, showTypes);
                }
            }
            GraphSONUtility.putObject(jsonMap, key.toString(), GraphSONUtility.getValue(value, showTypes));
        }
        return jsonMap;
    }

    private static void addObject(ArrayNode jsonList, Object value) {
        if (value == null) {
            jsonList.add((JsonNode)null);
        } else if (value.getClass() == Boolean.class) {
            jsonList.add((Boolean)value);
        } else if (value.getClass() == Long.class) {
            jsonList.add((Long)value);
        } else if (value.getClass() == Integer.class) {
            jsonList.add((Integer)value);
        } else if (value.getClass() == Float.class) {
            jsonList.add((Float)value);
        } else if (value.getClass() == Double.class) {
            jsonList.add((Double)value);
        } else if (value.getClass() == Byte.class) {
            jsonList.add((int)((Byte)value).byteValue());
        } else if (value.getClass() == Short.class) {
            jsonList.add((int)((Short)value).shortValue());
        } else if (value.getClass() == String.class) {
            jsonList.add((String)value);
        } else if (value instanceof ObjectNode) {
            jsonList.add((JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonList.add((JsonNode)((ArrayNode)value));
        } else {
            jsonList.add(value.toString());
        }
    }

    private static void putObject(ObjectNode jsonMap, String key, Object value) {
        if (value == null) {
            jsonMap.put(key, (JsonNode)null);
        } else if (value.getClass() == Boolean.class) {
            jsonMap.put(key, (Boolean)value);
        } else if (value.getClass() == Long.class) {
            jsonMap.put(key, (Long)value);
        } else if (value.getClass() == Integer.class) {
            jsonMap.put(key, (Integer)value);
        } else if (value.getClass() == Float.class) {
            jsonMap.put(key, (Float)value);
        } else if (value.getClass() == Double.class) {
            jsonMap.put(key, (Double)value);
        } else if (value.getClass() == Short.class) {
            jsonMap.put(key, (Short)value);
        } else if (value.getClass() == Byte.class) {
            jsonMap.put(key, (short)((Byte)value).byteValue());
        } else if (value.getClass() == String.class) {
            jsonMap.put(key, (String)value);
        } else if (value instanceof ObjectNode) {
            jsonMap.put(key, (JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonMap.put(key, (JsonNode)((ArrayNode)value));
        } else {
            jsonMap.put(key, value.toString());
        }
    }

    private static Map createPropertyMap(Element element, List<String> propertyKeys, ElementPropertyConfig.ElementPropertiesRule rule, boolean normalized) {
        ArrayList<String> propertyKeyList;
        HashMap map = new HashMap();
        if (normalized) {
            ArrayList<String> sorted = new ArrayList<String>(element.getPropertyKeys());
            Collections.sort(sorted);
            propertyKeyList = sorted;
        } else {
            propertyKeyList = new ArrayList<String>(element.getPropertyKeys());
        }
        if (propertyKeys == null) {
            for (String key : propertyKeyList) {
                Object valToPutInMap = element.getProperty(key);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        } else if (rule == ElementPropertyConfig.ElementPropertiesRule.INCLUDE) {
            for (String key : propertyKeys) {
                Object valToPutInMap = element.getProperty(key);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        } else {
            for (String key : propertyKeyList) {
                Object valToPutInMap;
                if (propertyKeys.contains(key) || (valToPutInMap = element.getProperty(key)) == null) continue;
                map.put(key, valToPutInMap);
            }
        }
        return map;
    }

    private static Object getValue(Object value, boolean includeType) {
        Object returnValue = value;
        if (includeType) {
            String type = GraphSONUtility.determineType(value);
            ObjectNode valueAndType = jsonNodeFactory.objectNode();
            valueAndType.put("type", type);
            if (type.equals("list")) {
                ArrayNode list = (ArrayNode)value;
                ArrayNode valueArray = valueAndType.putArray("value");
                for (int ix = 0; ix < list.size(); ++ix) {
                    GraphSONUtility.addObject(valueArray, GraphSONUtility.getValue(GraphSONUtility.getTypedValueFromJsonNode(list.get(ix)), includeType));
                }
            } else if (type.equals("map")) {
                ObjectNode convertedMap = jsonNodeFactory.objectNode();
                ObjectNode jsonObject = (ObjectNode)value;
                Iterator keyIterator = jsonObject.fieldNames();
                while (keyIterator.hasNext()) {
                    Object key = keyIterator.next();
                    convertedMap.put(key.toString(), jsonObject.get(key.toString()));
                }
                valueAndType.put("value", (JsonNode)convertedMap);
            } else {
                GraphSONUtility.putObject(valueAndType, "value", value);
            }
            returnValue = valueAndType;
        }
        return returnValue;
    }

    static Object getTypedValueFromJsonNode(JsonNode node) {
        Object theValue = null;
        if (node != null && !node.isNull()) {
            theValue = node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isDouble() ? Double.valueOf(node.doubleValue()) : (node.isFloatingPointNumber() ? Float.valueOf(node.floatValue()) : (node.isInt() ? Integer.valueOf(node.intValue()) : (node.isLong() ? Long.valueOf(node.longValue()) : (node.isTextual() ? node.textValue() : (node.isArray() ? node : (node.isObject() ? node : node.textValue())))))));
        }
        return theValue;
    }

    private static List convertArrayToList(Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        int arrlength = Array.getLength(value);
        for (int i = 0; i < arrlength; ++i) {
            Object object = Array.get(value, i);
            list.add(object);
        }
        return list;
    }

    private static String determineType(Object value) {
        String type = "string";
        if (value == null) {
            type = "unknown";
        } else if (value.getClass() == Double.class) {
            type = "double";
        } else if (value.getClass() == Float.class) {
            type = "float";
        } else if (value.getClass() == Byte.class) {
            type = "byte";
        } else if (value.getClass() == Short.class) {
            type = "short";
        } else if (value.getClass() == Integer.class) {
            type = "integer";
        } else if (value.getClass() == Long.class) {
            type = "long";
        } else if (value.getClass() == Boolean.class) {
            type = "boolean";
        } else if (value instanceof ArrayNode) {
            type = "list";
        } else if (value instanceof ObjectNode) {
            type = "map";
        }
        return type;
    }
}

