/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.dataorch;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.gui.SnapAllignDistribute;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IGraphSnapAlignDistribute;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.execution.DragViewZoomBase;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;

public abstract class HopGuiAbstractGraph
extends DragViewZoomBase
implements IGraphSnapAlignDistribute {
    public static final String STATE_MAGNIFICATION = "magnification";
    public static final String STATE_SCROLL_X_SELECTION = "offset-x";
    public static final String STATE_SCROLL_Y_SELECTION = "offset-y";
    protected HopGui hopGui;
    protected IVariables variables;
    protected Composite parentComposite;
    protected CTabItem parentTabItem;
    protected Point iconOffset;
    protected Point noteOffset;
    private boolean changedState;
    private final Font defaultFont;
    protected final String id;
    protected ToolTip toolTip;
    protected Map<String, Object> stateMap;

    public HopGuiAbstractGraph(HopGui hopGui, Composite parent, int style, CTabItem parentTabItem) {
        super(parent, style);
        this.parentComposite = parent;
        this.hopGui = hopGui;
        this.variables = new Variables();
        this.variables.copyFrom(hopGui.getVariables());
        this.parentTabItem = parentTabItem;
        this.defaultFont = GuiResource.getInstance().getFontDefault();
        this.changedState = false;
        this.id = UUID.randomUUID().toString();
        this.stateMap = new HashMap<String, Object>();
        this.offset = new DPoint(0.0, 0.0);
    }

    protected Shell hopShell() {
        return this.hopGui.getShell();
    }

    protected Display hopDisplay() {
        return this.hopGui.getDisplay();
    }

    public abstract boolean hasChanged();

    @Override
    public void redraw() {
        if (this.isDisposed() || this.canvas == null || this.canvas.isDisposed() || this.parentTabItem.isDisposed()) {
            return;
        }
        if (this.hasChanged() != this.changedState) {
            this.changedState = this.hasChanged();
            if (this.hasChanged()) {
                this.parentTabItem.setFont(GuiResource.getInstance().getFontBold());
            } else {
                this.parentTabItem.setFont(this.defaultFont);
            }
        }
        this.canvas.redraw();
    }

    public boolean forceFocus() {
        return this.canvas.forceFocus();
    }

    public void dispose() {
        this.parentTabItem.dispose();
    }

    public CTabItem getParentTabItem() {
        return this.parentTabItem;
    }

    public void setParentTabItem(CTabItem parentTabItem) {
        this.parentTabItem = parentTabItem;
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public void setParentComposite(Composite parentComposite) {
        this.parentComposite = parentComposite;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getStateProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE_MAGNIFICATION, Float.valueOf(this.magnification));
        map.put(STATE_SCROLL_X_SELECTION, this.offset.x);
        map.put(STATE_SCROLL_Y_SELECTION, this.offset.y);
        return map;
    }

    public void applyStateProperties(Map<String, Object> stateProperties) {
        Object yOffset;
        Double fMagnification = (Double)stateProperties.get(STATE_MAGNIFICATION);
        this.magnification = fMagnification == null ? 1.0f : fMagnification.floatValue();
        this.setZoomLabel();
        Object xOffset = stateProperties.get(STATE_SCROLL_X_SELECTION);
        if (xOffset != null) {
            this.offset.x = Double.parseDouble(xOffset.toString());
        }
        if ((yOffset = stateProperties.get(STATE_SCROLL_Y_SELECTION)) != null) {
            this.offset.y = Double.parseDouble(yOffset.toString());
        }
        this.redraw();
    }

    protected void showToolTip(org.eclipse.swt.graphics.Point location) {
        org.eclipse.swt.graphics.Point p = this.canvas.toDisplay(location);
        this.toolTip.setLocation(p.x + 5, p.y + 5);
        this.toolTip.setVisible(true);
    }

    @Override
    public abstract SnapAllignDistribute createSnapAlignDistribute();

    @Override
    public void snapToGrid() {
        this.snapToGrid(16);
    }

    private void snapToGrid(int size) {
        this.createSnapAlignDistribute().snapToGrid(size);
    }

    @Override
    public void alignLeft() {
        this.createSnapAlignDistribute().allignleft();
    }

    @Override
    public void alignRight() {
        this.createSnapAlignDistribute().allignright();
    }

    @Override
    public void alignTop() {
        this.createSnapAlignDistribute().alligntop();
    }

    @Override
    public void alignBottom() {
        this.createSnapAlignDistribute().allignbottom();
    }

    @Override
    @GuiKeyboardShortcut(alt=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000004)
    public void distributeHorizontal() {
        this.createSnapAlignDistribute().distributehorizontal();
    }

    @Override
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000001)
    public void distributeVertical() {
        this.createSnapAlignDistribute().distributevertical();
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public Map<String, Object> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Rectangle getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(Rectangle viewPort) {
        this.viewPort = viewPort;
    }

    public Rectangle getGraphPort() {
        return this.graphPort;
    }

    public void setGraphPort(Rectangle graphPort) {
        this.graphPort = graphPort;
    }

    protected void enableSnapAlignDistributeMenuItems(IHopFileType fileType, boolean selectedTransform) {
        GuiMenuWidgets menuWidgets = this.hopGui.getMainMenuWidgets();
        menuWidgets.enableMenuItem(fileType, "20200-menu-edit-snap-to-grid", "SnapToGrid", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20210-menu-edit-align-left", "AlignLeft", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20220-menu-edit-align-right", "AlignRight", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20230-menu-edit-align-top", "AlignTop", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20240-menu-edit-align-bottom", "AlignBottom", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20300-menu-edit-distribute-horizontal", "DistributeHorizontal", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20320-menu-edit-distribute-vertical", "DistributeVertical", selectedTransform);
    }
}

