/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.eclipse.swt.graphics.Image;

public class ExplorerFile {
    private String name;
    private Image tabImage;
    private String filename;
    private IExplorerFileType fileType;
    private IExplorerFileTypeHandler fileTypeHandler;
    private boolean changed;
    private List<IContentChangedListener> contentChangedListeners = new ArrayList<IContentChangedListener>();

    public ExplorerFile() {
    }

    public ExplorerFile(String name, Image tabImage, String filename, IExplorerFileType fileType, IExplorerFileTypeHandler fileTypeHandler) {
        this();
        this.name = name;
        this.tabImage = tabImage;
        this.filename = filename;
        this.fileType = fileType;
        this.fileTypeHandler = fileTypeHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplorerFile that = (ExplorerFile)o;
        return Objects.equals(this.filename, that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Image getTabImage() {
        return this.tabImage;
    }

    public void setTabImage(Image tabImage) {
        this.tabImage = tabImage;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public IExplorerFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(IExplorerFileType fileType) {
        this.fileType = fileType;
    }

    public IExplorerFileTypeHandler getFileTypeHandler() {
        return this.fileTypeHandler;
    }

    public void setFileTypeHandler(IExplorerFileTypeHandler fileTypeHandler) {
        this.fileTypeHandler = fileTypeHandler;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged() {
        if (!this.changed) {
            this.changed = true;
            for (IContentChangedListener listener : this.contentChangedListeners) {
                listener.contentChanged((Object)this);
            }
        }
    }

    public void clearChanged() {
        if (this.changed) {
            this.changed = false;
            for (IContentChangedListener listener : this.contentChangedListeners) {
                listener.contentSafe((Object)this);
            }
        }
    }

    public List<IContentChangedListener> getContentChangedListeners() {
        return this.contentChangedListeners;
    }

    public void addContentChangedListener(IContentChangedListener listener) {
        this.contentChangedListeners.add(listener);
    }
}

