/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.query.QueryFormat;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.DFunction;
import net.ucanaccess.converters.Functions;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.ParametricQuery;
import net.ucanaccess.converters.Pivot;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.converters.UcanaccessTable;
import net.ucanaccess.ext.FunctionType;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Logger;

public class LoadJet {
    private static int namingCounter = 0;
    private Connection conn;
    private Database dbIO;
    private boolean err;
    private FunctionsLoader functionsLoader = new FunctionsLoader();
    private List<String> loadedIndexes = new ArrayList<String>();
    private List<String> loadedQueries = new ArrayList<String>();
    private List<String> loadedProcedures = new ArrayList<String>();
    private List<String> loadedTables = new ArrayList<String>();
    private LogsFlusher logsFlusher = new LogsFlusher();
    private TablesLoader tablesLoader = new TablesLoader();
    private TriggersLoader triggersGenerator = new TriggersLoader();
    private ViewsLoader viewsLoader = new ViewsLoader();
    private boolean sysSchema;
    private boolean ff1997;
    private boolean skipIndexes;
    private Metadata metadata;

    public LoadJet(Connection _conn, Database _dbIo) throws SQLException {
        this.conn = _conn;
        this.dbIO = _dbIo;
        try {
            this.ff1997 = Database.FileFormat.V1997.equals((Object)this.dbIO.getFileFormat());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.metadata = new Metadata(_conn);
    }

    public void loadDefaultValues(Table t) throws SQLException, IOException {
        this.tablesLoader.setDefaultValues(t);
    }

    public void loadDefaultValues(Column cl) throws SQLException, IOException {
        this.tablesLoader.setDefaultValue(cl);
    }

    public String defaultValue4SQL(Column cl) throws SQLException, IOException {
        PropertyMap pm = cl.getProperties();
        Object defaulT = pm.getValue("DefaultValue");
        if (defaulT == null) {
            return null;
        }
        return this.tablesLoader.defaultValue4SQL(defaulT, cl.getType());
    }

    private static boolean hasAutoNumberColumn(Table t) {
        List lc = t.getColumns();
        for (Column cl : lc) {
            if (!cl.isAutoNumber() && !DataType.BOOLEAN.equals((Object)cl.getType())) continue;
            return true;
        }
        return false;
    }

    public void addFunctions(Class<?> clazz) throws SQLException {
        this.functionsLoader.addFunctions(clazz, false);
    }

    private void exec(String expression, boolean logging) throws SQLException {
        try (Statement st = null;){
            st = this.conn.createStatement();
            st.executeUpdate(expression);
        }
    }

    private void execInsert(PreparedStatement st, List<Object> values) throws SQLException {
        int i = 1;
        for (Object value : values) {
            st.setObject(i++, value);
        }
        st.addBatch();
    }

    private String escapeIdentifier(String tn) throws SQLException {
        return SQLConverter.escapeIdentifier(tn, this.conn);
    }

    public SQLWarning getLoadingWarnings() {
        String message;
        if (this.viewsLoader.notLoaded.size() == 0 && this.tablesLoader.unresolvedTables.size() == 0) {
            return null;
        }
        SQLWarning sqlw = null;
        for (String s : this.viewsLoader.notLoaded.keySet()) {
            String string = message = s.length() > 0 ? "Cannot load view " + s + " " + (String)this.viewsLoader.notLoaded.get(s) : "Cannot load views ";
            if (sqlw == null) {
                sqlw = new SQLWarning(message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning(message));
        }
        for (String s : this.viewsLoader.notLoadedProcedure.keySet()) {
            String string = message = s.length() > 0 ? "Cannot load procedure " + s + " " + (String)this.viewsLoader.notLoadedProcedure.get(s) : "Cannot load procedures ";
            if (sqlw == null) {
                sqlw = new SQLWarning(message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning(message));
        }
        for (String s : this.tablesLoader.unresolvedTables) {
            message = "Cannot resolve table " + s;
            if (sqlw == null) {
                sqlw = new SQLWarning(message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning(message));
        }
        return sqlw;
    }

    public void resetFunctionsDefault() throws SQLException {
        this.functionsLoader.resetDefault();
    }

    public void loadDB() throws SQLException, IOException {
        try {
            this.functionsLoader.loadMappedFunctions();
            this.tablesLoader.loadTables();
            this.viewsLoader.loadViews();
            this.conn.commit();
            SQLConverter.cleanEscaped();
        }
        finally {
            Logger.log("Loaded Tables:");
            this.logsFlusher.dumpList(this.loadedTables);
            Logger.log("Loaded Queries:");
            this.logsFlusher.dumpList(this.loadedQueries);
            Logger.log("Loaded Procedures:");
            this.logsFlusher.dumpList(this.loadedProcedures);
            Logger.log("Loaded Indexes:");
            this.logsFlusher.dumpList(this.loadedIndexes, true);
            this.conn.close();
        }
    }

    public void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAppendOnly) throws SQLException {
        this.triggersGenerator.synchronisationTriggers(tableName, hasAutoNumberColumn, hasAppendOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object tryDefault(Object defaulT) throws SQLException {
        try (Statement st = null;){
            st = this.conn.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + defaulT + " FROM   DUAL ");
            if (rs.next()) {
                Object object = rs.getObject(1);
                return object;
            }
            Object var4_6 = null;
            return var4_6;
        }
    }

    public void setSysSchema(boolean _sysSchema) {
        this.sysSchema = _sysSchema;
    }

    public void setSkipIndexes(boolean _skipIndexes) {
        this.skipIndexes = _skipIndexes;
    }

    private final class ViewsLoader {
        private Map<String, String> notLoaded = new HashMap<String, String>();
        private Map<String, String> notLoadedProcedure = new HashMap<String, String>();
        private static final int OBJECT_ALREADY_EXISTS = -5504;
        private static final int OBJECT_NOT_FOUND = -5501;
        private static final int UNEXPECTED_TOKEN = -5581;

        private ViewsLoader() {
        }

        private boolean loadView(Query q) throws SQLException {
            return this.loadView(q, null);
        }

        private void registerQueryColumns(Query q, int seq) throws SQLException {
            QueryImpl qi = (QueryImpl)q;
            for (QueryImpl.Row row : qi.getRows()) {
                if (!QueryFormat.COLUMN_ATTRIBUTE.equals(row.attribute)) continue;
                String name = row.name1;
                if (name == null) {
                    int beginIndex = Math.max(row.expression.lastIndexOf(91), row.expression.lastIndexOf(46));
                    if (beginIndex < 0 || beginIndex == row.expression.length() - 1 || row.expression.endsWith(")")) continue;
                    name = row.expression.substring(beginIndex + 1);
                    if (name.endsWith("]")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if (name.contentEquals("*")) {
                        String table = row.expression.substring(0, beginIndex);
                        List<String> result = LoadJet.this.metadata.getColumnNames(table);
                        if (result != null) {
                            for (String column : result) {
                                LoadJet.this.metadata.newColumn(column, SQLConverter.preEscapingIdentifier(column), null, seq);
                            }
                        }
                    }
                }
                LoadJet.this.metadata.newColumn(name, SQLConverter.preEscapingIdentifier(name), null, seq);
            }
        }

        private boolean loadView(Query q, String queryWKT) throws SQLException {
            String qnn = SQLConverter.preEscapingIdentifier(q.getName());
            if (qnn == null) {
                return false;
            }
            int seq = LoadJet.this.metadata.newTable(q.getName(), qnn, Metadata.Types.VIEW);
            this.registerQueryColumns(q, seq);
            qnn = SQLConverter.completeEscaping(qnn, false);
            qnn = SQLConverter.checkLang(qnn, LoadJet.this.conn, false);
            if (qnn.indexOf(" ") > 0) {
                SQLConverter.addWhiteSpacedTableNames(q.getName());
            }
            String querySQL = queryWKT == null ? q.toSQLString() : queryWKT;
            Pivot pivot = null;
            boolean isPivot = q.getType().equals((Object)Query.Type.CROSS_TAB);
            if (isPivot && (!(pivot = new Pivot(LoadJet.this.conn)).parsePivot(querySQL) || (querySQL = pivot.toSQL(q.getName())) == null)) {
                this.notLoaded.put(q.getName(), "cannot load this query");
                return false;
            }
            querySQL = new DFunction(LoadJet.this.conn, querySQL).toSQL();
            StringBuffer sb = new StringBuffer("CREATE VIEW ").append(qnn).append(" AS ").append(querySQL);
            String v = null;
            try {
                v = SQLConverter.convertSQL(sb.toString(), true).getSql();
                if (v.trim().endsWith(";")) {
                    v = v.trim().substring(0, v.length() - 1);
                }
                LoadJet.this.exec(v, false);
                LoadJet.this.loadedQueries.add(q.getName());
                this.notLoaded.remove(q.getName());
                if (pivot != null) {
                    pivot.registerPivot(SQLConverter.preEscapingIdentifier(q.getName()));
                }
                return true;
            }
            catch (Exception e) {
                if (e instanceof SQLSyntaxErrorException) {
                    if (queryWKT == null && ((SQLSyntaxErrorException)e).getErrorCode() == -5504) {
                        return this.loadView(q, this.solveAmbiguous(querySQL));
                    }
                    SQLSyntaxErrorException sqle = (SQLSyntaxErrorException)e;
                    if (sqle.getErrorCode() == -5501 || sqle.getErrorCode() == -5581) {
                        ParametricQuery pq = new ParametricQuery(LoadJet.this.conn, (QueryImpl)q);
                        pq.setIssueWithParameterName(sqle.getErrorCode() == -5581);
                        pq.createSelect();
                        if (pq.loaded()) {
                            LoadJet.this.loadedQueries.add(q.getName());
                            this.notLoaded.remove(q.getName());
                            return true;
                        }
                    }
                }
                String cause = UcanaccessSQLException.explaneCause(e);
                this.notLoaded.put(q.getName(), ": " + cause);
                if (!LoadJet.this.err) {
                    Logger.log("Error occured at the first loading attempt of " + q.getName());
                    Logger.log("Converted view was :" + v);
                    Logger.log("Error message was :" + e.getMessage());
                    LoadJet.this.err = true;
                }
                return false;
            }
        }

        private String solveAmbiguous(String sql) {
            try {
                sql = sql.replaceAll("[\n\r]", " ");
                Pattern pt = Pattern.compile("(.*)[\n\r\\s]*(?i)SELECT([\n\r\\s].*[\n\r\\s])(?i)FROM([\n\r\\s])(.*)");
                Matcher mtc = pt.matcher(sql);
                if (mtc.find()) {
                    String select = mtc.group(2);
                    String pre = mtc.group(1) == null ? "" : mtc.group(1);
                    String[] splitted = select.split(",", -1);
                    StringBuffer sb = new StringBuffer(pre + " select ");
                    LinkedList<String> lkl = new LinkedList<String>();
                    for (String s : splitted) {
                        int j = s.lastIndexOf(".");
                        Pattern aliasPt = Pattern.compile("[\\s\n\r]+(?i)AS[\\s\n\r]+");
                        boolean alias = aliasPt.matcher(s).find();
                        if (j < 0 || alias) {
                            lkl.add(s);
                            continue;
                        }
                        String k = s.substring(j + 1);
                        if (lkl.contains(k)) {
                            int idx = lkl.indexOf(k);
                            String old = (String)lkl.get(lkl.indexOf(k));
                            lkl.remove(old);
                            lkl.add(idx, splitted[idx] + " AS [" + splitted[idx].trim() + "]");
                            lkl.add(s + " AS [" + s.trim() + "]");
                            continue;
                        }
                        lkl.add(k);
                    }
                    String comma = "";
                    for (String s : lkl) {
                        sb.append(comma).append(s);
                        comma = ",";
                    }
                    sb.append(" FROM ").append(mtc.group(4));
                    return sb.toString();
                }
                return sql;
            }
            catch (Exception e) {
                return sql;
            }
        }

        private void loadViews() throws SQLException, IOException {
            List lq = null;
            ArrayList<Query> procedures = new ArrayList<Query>();
            try {
                lq = LoadJet.this.dbIO.getQueries();
                Iterator it = lq.iterator();
                while (it.hasNext()) {
                    Query q = (Query)it.next();
                    if (q.getType().equals((Object)Query.Type.SELECT) || q.getType().equals((Object)Query.Type.UNION) || q.getType().equals((Object)Query.Type.CROSS_TAB)) continue;
                    procedures.add(q);
                    it.remove();
                }
                this.queryPorting(lq);
            }
            catch (Exception e) {
                this.notLoaded.put("", "");
            }
            this.loadProcedures(procedures);
        }

        private void loadProcedures(List<Query> procedures) throws SQLException {
            for (Query q : procedures) {
                ParametricQuery pq = new ParametricQuery(LoadJet.this.conn, (QueryImpl)q);
                if (q.getType().equals((Object)Query.Type.DATA_DEFINITION)) continue;
                pq.createProcedure();
                if (pq.loaded()) {
                    LoadJet.this.loadedProcedures.add(pq.getSignature());
                    continue;
                }
                String msg = pq.getException() == null ? "" : pq.getException().getMessage();
                this.notLoadedProcedure.put(q.getName(), msg);
            }
        }

        private void queryPorting(List<Query> lq) throws SQLException {
            ArrayList<String> arn = new ArrayList<String>();
            for (Query q : lq) {
                arn.add(q.getName().toLowerCase());
            }
            boolean heavy = false;
            while (lq.size() > 0) {
                ArrayList<Query> arq = new ArrayList<Query>();
                for (Query q : lq) {
                    String qtxt = null;
                    boolean qryGot = true;
                    try {
                        qtxt = q.toSQLString().toLowerCase();
                    }
                    catch (Exception ignore) {
                        qryGot = false;
                    }
                    boolean foundDep = false;
                    if (qryGot && !heavy) {
                        for (String name : arn) {
                            if (qtxt.indexOf(name) == -1) continue;
                            foundDep = true;
                            break;
                        }
                    }
                    if (!qryGot || foundDep || !this.loadView(q)) continue;
                    arq.add(q);
                    arn.remove(q.getName().toLowerCase());
                }
                if (arq.size() == 0) {
                    if (heavy) break;
                    heavy = true;
                }
                lq.removeAll(arq);
            }
            Pivot.clearPrepared();
        }
    }

    private final class TriggersLoader {
        private static final String DEFAULT_TRIGGERS_PACKAGE = "net.ucanaccess.triggers";

        private TriggersLoader() {
        }

        private void loadTrigger(String tableName, String namePrefix, String when, String className) throws SQLException {
            String q0 = DBReference.is2xx() ? "" : " QUEUE 0  ";
            String triggerName = namePrefix + "_" + tableName;
            triggerName = LoadJet.this.escapeIdentifier(triggerName);
            LoadJet.this.exec("CREATE TRIGGER " + triggerName + "  " + when + " ON " + tableName + "   FOR EACH ROW\t" + q0 + "   CALL \"" + className + "\" ", true);
        }

        private void loadTriggerNP(String tableName, String namePrefix, String when, String className) throws SQLException {
            this.loadTrigger(tableName, namePrefix, when, "net.ucanaccess.triggers." + className);
        }

        private void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAutoAppendOnly) throws SQLException {
            this.loadTriggerNP(tableName, "genericInsert", "AFTER INSERT", "TriggerInsert");
            this.loadTriggerNP(tableName, "genericUpdate", "AFTER UPDATE", "TriggerUpdate");
            this.loadTriggerNP(tableName, "genericDelete", "AFTER DELETE", "TriggerDelete");
            if (hasAutoAppendOnly) {
                this.loadTriggerNP(tableName, "appendOnly", "BEFORE INSERT", "TriggerAppendOnly");
                this.loadTriggerNP(tableName, "appendOnly_upd", "BEFORE UPDATE", "TriggerAppendOnly");
            }
            if (hasAutoNumberColumn) {
                this.loadTriggerNP(tableName, "autonumber", "BEFORE INSERT", "TriggerAutoNumber");
                this.loadTriggerNP(tableName, "autonumber_validate", "BEFORE UPDATE", "TriggerAutoNumber");
            }
        }
    }

    private final class TablesLoader {
        private static final int HSQL_FK_ALREADY_EXISTS = -5528;
        private static final int HSQL_UK_ALREADY_EXISTS = -5522;
        private static final int HSQL_NOT_NULL = -10;
        private static final int HSQL_FK_VIOLATION = -177;
        private static final int HSQL_UK_VIOLATION = -104;
        private static final String SYSTEM_SCHEMA = "SYS";
        private static final int DEFAULT_STEP = 2000;
        private List<String> unresolvedTables = new ArrayList<String>();
        private List<String> calculatedFieldsTriggers = new ArrayList<String>();
        private LinkedList<String> loadingOrder = new LinkedList();
        private Set<Column> alreadyIndexed = new HashSet<Column>();
        private Set<String> readOnlyTables = new HashSet<String>();

        private TablesLoader() {
        }

        private String commaSeparated(List<? extends Index.Column> columns, boolean escape) throws SQLException {
            String comma = "";
            StringBuffer sb = new StringBuffer(" (");
            for (Index.Column column : columns) {
                String cl = escape ? LoadJet.this.escapeIdentifier(column.getColumn().getName()) : column.getColumn().getName();
                sb.append(comma).append(cl);
                comma = ",";
            }
            return sb.append(") ").toString();
        }

        private String schema(String name, boolean systemTable) {
            if (systemTable) {
                return "SYS." + name;
            }
            return name;
        }

        private DataType getReturnType(Column cl) throws IOException {
            if (cl.getProperties().get("Expression") == null || cl.getProperties().get("ResultType") == null) {
                return null;
            }
            byte pos = (Byte)cl.getProperties().get("ResultType").getValue();
            return DataType.fromByte((byte)pos);
        }

        private String getHsqldbColumnType(Column cl) throws IOException {
            String htype;
            DataType dtyp = cl.getType();
            DataType rtyp = this.getReturnType(cl);
            boolean calcType = false;
            if (rtyp != null) {
                dtyp = rtyp;
                calcType = true;
            }
            if (dtyp.equals((Object)DataType.TEXT)) {
                short ln = LoadJet.this.ff1997 ? cl.getLength() : cl.getLengthInUnits();
                htype = "VARCHAR(" + ln + ")";
            } else if (dtyp.equals((Object)DataType.NUMERIC) && (cl.getScale() > 0 || calcType)) {
                htype = calcType ? "NUMERIC(100 ,4)" : "NUMERIC(" + (cl.getPrecision() > 0 ? (int)cl.getPrecision() : 100) + "," + cl.getScale() + ")";
            } else if (dtyp.equals((Object)DataType.FLOAT)) {
                if (calcType) {
                    htype = "NUMERIC(" + (cl.getPrecision() > 0 ? (int)cl.getPrecision() : 100) + "," + 7 + ")";
                } else {
                    Object dps = null;
                    PropertyMap.Property dpso = cl.getProperties().get("DecimalPlaces");
                    if (dpso != null) {
                        dps = cl.getProperties().get("DecimalPlaces").getValue();
                    }
                    int dp = dps == null ? 7 : ((Byte)dps < 0 ? 7 : (int)((Byte)dps).byteValue());
                    htype = "NUMERIC(" + (cl.getPrecision() > 0 ? (int)cl.getPrecision() : 100) + "," + dp + ")";
                }
            } else {
                htype = TypesMap.map2hsqldb(dtyp);
            }
            return htype;
        }

        private String getCalculatedFieldTrigger(String ntn, Column cl, boolean isCreate) throws IOException, SQLException {
            DataType dt = this.getReturnType(cl);
            String fun = null;
            if (this.isNumeric(dt)) {
                fun = "formulaToNumeric";
            } else if (this.isBoolean(dt)) {
                fun = "formulaToBoolean";
            } else if (this.isDate(dt)) {
                fun = "formulaToDate";
            } else if (this.isTextual(dt)) {
                fun = "formulaToText";
            }
            String call = fun == null ? "%s" : fun + "(%s,'" + dt.name() + "')";
            String ecl = this.procedureEscapingIdentifier(cl.getName()).replace("%", "%%");
            String trg = isCreate ? "CREATE TRIGGER expr%d before insert ON " + ntn + " REFERENCING NEW  AS newrow  FOR EACH ROW  BEGIN  ATOMIC  SET newrow." + ecl + " = " + call + "; END " : "CREATE TRIGGER expr%d before update ON " + ntn + " REFERENCING NEW  AS newrow OLD AS OLDROW FOR EACH ROW  BEGIN  ATOMIC IF %s THEN  SET newrow." + ecl + " = " + call + "; ELSEIF newrow." + ecl + " <> oldrow." + ecl + " THEN SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = '" + Logger.getMessage(Logger.Messages.TRIGGER_UPDATE_CF_ERR.name()) + cl.getName().replace("%", "%%") + "';  END IF ; END ";
            return trg;
        }

        private boolean isNumeric(DataType dt) {
            return this.typeGroup(dt, DataType.NUMERIC, DataType.MONEY, DataType.DOUBLE, DataType.FLOAT, DataType.LONG, DataType.INT, DataType.BYTE);
        }

        private boolean isDate(DataType dt) {
            return this.typeGroup(dt, DataType.SHORT_DATE_TIME);
        }

        private boolean isBoolean(DataType dt) {
            return this.typeGroup(dt, DataType.BOOLEAN);
        }

        private boolean isTextual(DataType dt) {
            return this.typeGroup(dt, DataType.MEMO, DataType.TEXT);
        }

        private boolean typeGroup(DataType dt, DataType ... gr) {
            for (DataType el : gr) {
                if (!el.equals((Object)dt)) continue;
                return true;
            }
            return false;
        }

        private void createSyncrTable(Table t, boolean systemTable) throws SQLException, IOException {
            this.createSyncrTable(t, systemTable, true);
        }

        private void createSyncrTable(Table t, boolean systemTable, boolean constraints) throws SQLException, IOException {
            String tn = t.getName();
            if (tn.equalsIgnoreCase("DUAL")) {
                SQLConverter.setDualUsedAsTableName(true);
            }
            StringBuffer check = new StringBuffer();
            String ntn = SQLConverter.preEscapingIdentifier(tn);
            int seq = LoadJet.this.metadata.newTable(tn, ntn, Metadata.Types.TABLE);
            ntn = SQLConverter.completeEscaping(ntn);
            ntn = SQLConverter.checkLang(ntn, LoadJet.this.conn);
            ntn = this.schema(ntn, systemTable);
            StringBuffer sbC = new StringBuffer("CREATE  CACHED TABLE ").append(ntn).append("(");
            List lc = t.getColumns();
            String comma = "";
            for (Column cl : lc) {
                String expr;
                if ("USER".equalsIgnoreCase(cl.getName())) {
                    Logger.logParametricWarning(Logger.Messages.USER_AS_COLUMNNAME, t.getName());
                }
                if ((expr = this.getExpression(cl)) != null && constraints) {
                    String tgrI = this.getCalculatedFieldTrigger(ntn, cl, true);
                    String tgrU = this.getCalculatedFieldTrigger(ntn, cl, false);
                    this.calculatedFieldsTriggers.add(String.format(tgrI, namingCounter++, SQLConverter.convertFormula(expr)));
                    String uc = this.getUpdateConditions(cl);
                    if (uc.length() > 0) {
                        this.calculatedFieldsTriggers.add(String.format(tgrU, namingCounter++, uc, SQLConverter.convertFormula(expr)));
                    }
                }
                String htype = this.getHsqldbColumnType(cl);
                String cn = SQLConverter.preEscapingIdentifier(cl.getName());
                String ctype = cl.getType().name();
                if (cl.isAutoNumber()) {
                    ColumnImpl cli = (ColumnImpl)cl;
                    ColumnImpl.AutoNumberGenerator ang = cli.getAutoNumberGenerator();
                    if (ang.getType().equals((Object)DataType.LONG)) {
                        ctype = "COUNTER";
                    }
                } else if (cl.isHyperlink()) {
                    ctype = "HYPERLINK";
                }
                LoadJet.this.metadata.newColumn(cl.getName(), cn, ctype, seq);
                if (expr != null && constraints) {
                    LoadJet.this.metadata.calculatedField(t.getName(), cl.getName());
                }
                cn = SQLConverter.completeEscaping(cn);
                cn = SQLConverter.checkLang(cn, LoadJet.this.conn);
                sbC.append(comma).append(cn).append(" ").append(htype);
                if (DataType.FLOAT.equals((Object)cl.getType())) {
                    check.append(", check (3.4028235E+38>=").append(cn).append(" AND -3.4028235E+38<=").append(cn).append(")");
                }
                PropertyMap pm = cl.getProperties();
                Object required = pm.getValue("Required");
                if (constraints && required != null && required instanceof Boolean && ((Boolean)required).booleanValue()) {
                    sbC.append(" NOT NULL ");
                }
                comma = ",";
            }
            sbC.append(check).append(")");
            LoadJet.this.exec(sbC.toString(), true);
        }

        private String getExpression(Column cl) throws IOException {
            PropertyMap map = cl.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null) {
                Table tl = cl.getTable();
                String expr = SQLConverter.convertPowOperator((String)exprp.getValue());
                for (Column cl1 : tl.getColumns()) {
                    expr = expr.replaceAll("\\[(?i)(" + Pattern.quote(cl1.getName()) + ")\\]", "newrow.$0");
                }
                return expr;
            }
            return null;
        }

        private String getUpdateConditions(Column cl) throws IOException, SQLException {
            Set<String> setu;
            PropertyMap map = cl.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null && (setu = SQLConverter.getFormulaDependencies(exprp.getValue().toString())).size() > 0) {
                String or = "";
                StringBuffer cw = new StringBuffer();
                for (String dep : setu) {
                    dep = LoadJet.this.escapeIdentifier(dep);
                    cw.append(or).append("oldrow.").append(dep).append("<>").append("newrow.").append(dep);
                    or = " OR ";
                }
                return cw.toString();
            }
            return " FALSE ";
        }

        private String procedureEscapingIdentifier(String name) throws SQLException {
            return SQLConverter.procedureEscapingIdentifier(LoadJet.this.escapeIdentifier(name));
        }

        private void setDefaultValue(Column cl) throws SQLException, IOException {
            String tn = cl.getTable().getName();
            String ntn = LoadJet.this.escapeIdentifier(tn);
            ArrayList<String> arTrigger = new ArrayList<String>();
            this.setDefaultValue(cl, ntn, arTrigger);
            for (String trigger : arTrigger) {
                LoadJet.this.exec(trigger, true);
            }
        }

        private String defaultValue4SQL(Object defaulT, DataType dt) throws SQLException, IOException {
            if (defaulT == null) {
                return null;
            }
            String default4SQL = SQLConverter.convertSQL(" " + defaulT.toString()).getSql();
            if (default4SQL.trim().startsWith("=")) {
                default4SQL = default4SQL.trim().substring(1);
            }
            if (dt.equals((Object)DataType.BOOLEAN) && ("=yes".equalsIgnoreCase(default4SQL) || "yes".equalsIgnoreCase(default4SQL))) {
                default4SQL = "true";
            }
            if (dt.equals((Object)DataType.BOOLEAN) && ("=no".equalsIgnoreCase(default4SQL) || "no".equalsIgnoreCase(default4SQL))) {
                default4SQL = "false";
            }
            if (!(!dt.equals((Object)DataType.MEMO) && !dt.equals((Object)DataType.TEXT) || defaulT.toString().startsWith("\"") && defaulT.toString().endsWith("\""))) {
                default4SQL = "'" + default4SQL.replaceAll("'", "''") + "'";
            }
            return default4SQL;
        }

        private void setDefaultValue(Column cl, String ntn, List<String> arTrigger) throws IOException, SQLException {
            PropertyMap pm = cl.getProperties();
            String ncn = this.procedureEscapingIdentifier(cl.getName());
            Object defaulT = pm.getValue("DefaultValue");
            if (defaulT != null) {
                String default4SQL = this.defaultValue4SQL(defaulT, cl.getType());
                String guidExp = "GenGUID()";
                if (!guidExp.equals(defaulT)) {
                    boolean defaultIsFunction;
                    boolean bl = defaultIsFunction = defaulT.toString().trim().endsWith(")") && defaulT.toString().indexOf("(") > 0;
                    if (defaultIsFunction) {
                        LoadJet.this.metadata.columnDef(cl.getTable().getName(), cl.getName(), defaulT.toString());
                    }
                    Object defFound = default4SQL;
                    boolean isNull = (default4SQL + "").equalsIgnoreCase("null");
                    if (!isNull && (defFound = LoadJet.this.tryDefault(default4SQL)) == null) {
                        Logger.logParametricWarning(Logger.Messages.UNKNOWN_EXPRESSION, "" + defaulT, cl.getName(), cl.getTable().getName());
                    } else {
                        if (defFound != null && !defaultIsFunction) {
                            LoadJet.this.metadata.columnDef(cl.getTable().getName(), cl.getName(), defFound.toString());
                        }
                        if (cl.getType() == DataType.TEXT && defaulT.toString().startsWith("'") && defaulT.toString().endsWith("'") && defaulT.toString().length() > cl.getLengthInUnits()) {
                            Logger.logParametricWarning(Logger.Messages.DEFAULT_VALUES_DELIMETERS, "" + defaulT, cl.getName(), cl.getTable().getName(), "" + cl.getLengthInUnits());
                        }
                        arTrigger.add("CREATE TRIGGER DEFAULT_TRIGGER" + namingCounter++ + " BEFORE INSERT ON " + ntn + "  REFERENCING NEW ROW AS NEW FOR EACH ROW IF NEW." + ncn + " IS NULL THEN SET NEW." + ncn + "= " + default4SQL + " ; END IF");
                    }
                }
            }
        }

        private void setDefaultValues(Table t) throws SQLException, IOException {
            String tn = t.getName();
            String ntn = LoadJet.this.escapeIdentifier(tn);
            List lc = t.getColumns();
            ArrayList<String> arTrigger = new ArrayList<String>();
            for (Column cl : lc) {
                this.setDefaultValue(cl, ntn, arTrigger);
            }
            for (String trigger : arTrigger) {
                LoadJet.this.exec(trigger, true);
            }
        }

        private int countFKs() throws IOException {
            int i = 0;
            for (String tn : this.loadingOrder) {
                UcanaccessTable table = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                if (this.unresolvedTables.contains(tn)) continue;
                for (Index index : table.getIndexes()) {
                    IndexImpl idx = (IndexImpl)index;
                    if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                    ++i;
                }
            }
            return i;
        }

        private boolean reorder() throws IOException, SQLException {
            int maxIteration = this.countFKs() + 1;
            for (int i = 0; i < maxIteration; ++i) {
                boolean change = false;
                ArrayList<String> loadingOrder0 = new ArrayList<String>();
                loadingOrder0.addAll(this.loadingOrder);
                for (String tn : loadingOrder0) {
                    UcanaccessTable table = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                    if (this.unresolvedTables.contains(tn)) continue;
                    for (Index index : table.getIndexes()) {
                        IndexImpl idx = (IndexImpl)index;
                        if (!idx.isForeignKey() || idx.getReference().isPrimaryTable() || this.tryReorder((Index)idx)) continue;
                        change = true;
                    }
                }
                if (change) continue;
                return true;
            }
            return false;
        }

        private boolean tryReorder(Index idxi) throws IOException {
            int irt;
            IndexImpl idx = (IndexImpl)idxi;
            String ctn = idx.getTable().getName();
            String rtn = idx.getReferencedIndex().getTable().getName();
            int ict = this.loadingOrder.indexOf(ctn);
            if (ict < (irt = this.loadingOrder.indexOf(rtn))) {
                this.loadingOrder.remove(ctn);
                this.loadingOrder.add(irt, ctn);
                return false;
            }
            return true;
        }

        private void loadForeignKey(Index idxi, String ctn) throws IOException, SQLException {
            String ntn;
            IndexImpl idx = (IndexImpl)idxi;
            String rtn = idx.getReferencedIndex().getTable().getName();
            List cls = idx.getColumns();
            if (cls.size() == 1) {
                this.alreadyIndexed.add((Column)((IndexData.ColumnDescriptor)cls.get(0)).getColumn());
            }
            if ((ntn = LoadJet.this.escapeIdentifier(ctn)) == null) {
                return;
            }
            String nin = LoadJet.this.escapeIdentifier(ctn + "_" + idx.getName());
            String colsIdx = this.commaSeparated(cls, true);
            String colsIdxRef = this.commaSeparated(idx.getReferencedIndex().getColumns(), true);
            StringBuffer ci = new StringBuffer("ALTER TABLE ").append(ntn);
            ci.append(" ADD CONSTRAINT ").append(nin);
            String nrt = LoadJet.this.escapeIdentifier(rtn);
            if (nrt == null) {
                return;
            }
            ci.append(" FOREIGN KEY ").append(colsIdx).append(" REFERENCES ").append(nrt).append(colsIdxRef);
            if (idx.getReference().isCascadeDeletes()) {
                ci.append(" ON DELETE CASCADE ");
            }
            if (idx.getReference().isCascadeUpdates()) {
                ci.append(" ON UPDATE CASCADE ");
            }
            try {
                LoadJet.this.exec(ci.toString(), true);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -5528) {
                    Logger.log(e.getMessage());
                }
                throw e;
            }
            LoadJet.this.loadedIndexes.add("FK on " + ntn + " Columns:" + this.commaSeparated(cls, false) + " References " + nrt + " Columns:" + this.commaSeparated(idx.getReferencedIndex().getColumns(), false));
        }

        private void loadIndex(Index idx, String tn) throws IOException, SQLException {
            DataType dt;
            Column cl;
            String ntn = LoadJet.this.escapeIdentifier(tn);
            if (ntn == null) {
                return;
            }
            String nin = idx.getName();
            nin = LoadJet.this.escapeIdentifier(tn + "_" + nin);
            boolean uk = idx.isUnique();
            boolean pk = idx.isPrimaryKey();
            if (!uk && !pk && idx.getColumns().size() == 1 && this.alreadyIndexed.contains(cl = ((Index.Column)idx.getColumns().get(0)).getColumn())) {
                return;
            }
            if (uk && idx.getColumns().size() == 1 && (dt = (cl = ((Index.Column)idx.getColumns().get(0)).getColumn()).getType()).equals((Object)DataType.COMPLEX_TYPE)) {
                return;
            }
            StringBuffer ci = new StringBuffer("ALTER TABLE ").append(ntn);
            String colsIdx = this.commaSeparated(idx.getColumns(), true);
            if (pk) {
                ci.append(" ADD PRIMARY KEY ").append(colsIdx);
            } else if (uk) {
                ci.append(" ADD CONSTRAINT ").append(nin);
                ci.append(" UNIQUE ").append(colsIdx);
            } else {
                ci = new StringBuffer("CREATE INDEX ").append(nin).append(" ON ").append(ntn).append(colsIdx);
            }
            try {
                LoadJet.this.exec(ci.toString(), true);
            }
            catch (SQLException e) {
                if (-5522 == e.getErrorCode()) {
                    return;
                }
                if (idx.isUnique()) {
                    for (Index.Column cd : idx.getColumns()) {
                        if (!cd.getColumn().getType().equals((Object)DataType.COMPLEX_TYPE)) continue;
                        return;
                    }
                }
                Logger.logWarning(e.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.logWarning(e.getMessage());
                return;
            }
            String pre = pk ? "Primary Key " : (uk ? "Index Unique " : "Index");
            LoadJet.this.loadedIndexes.add(pre + " on " + tn + " Columns:" + this.commaSeparated(idx.getColumns(), false));
        }

        private void createTable(Table t) throws SQLException, IOException {
            this.createTable(t, false);
        }

        private void dropTable(Table t, boolean systemTable) throws SQLException {
            String tn = t.getName();
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            LoadJet.this.exec("DROP TABLE " + ntn + " CASCADE ", false);
            LoadJet.this.metadata.dropTable(tn);
        }

        private void makeTableReadOnly(Table t, boolean systemTable) throws SQLException {
            String tn = t.getName();
            this.readOnlyTables.add(t.getName());
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            LoadJet.this.exec("SET TABLE " + ntn + " READONLY TRUE ", false);
            LoadJet.this.loadedTables.add(tn + " READONLY");
        }

        private void recreate(Table t, boolean systemTable, Row record, int errorCode) throws SQLException, IOException {
            String type = "";
            switch (errorCode) {
                case -177: {
                    type = "Foreign Key";
                    break;
                }
                case -10: {
                    type = "Not Null";
                    break;
                }
                case -104: {
                    type = "Unique";
                    break;
                }
            }
            Logger.logParametricWarning(Logger.Messages.CONSTRAINT, type, t.getName(), record.toString(), t.getName());
            this.dropTable(t, systemTable);
            this.createSyncrTable(t, systemTable, false);
            if (errorCode != -177) {
                this.loadTableFKs(t.getName(), false);
            }
            this.loadTableData(t, systemTable);
            this.makeTableReadOnly(t, systemTable);
        }

        private void createTable(Table t, boolean systemTable) throws SQLException, IOException {
            String ntn;
            String tn = t.getName();
            if (tn.indexOf(" ") > 0) {
                SQLConverter.addWhiteSpacedTableNames(tn);
            }
            if ((ntn = SQLConverter.escapeIdentifier(tn)) == null) {
                return;
            }
            this.createSyncrTable(t, systemTable);
        }

        private boolean hasAppendOnly(Table t) {
            for (Column c : t.getColumns()) {
                if (!c.isAppendOnly()) continue;
                return true;
            }
            return false;
        }

        private void loadTableData(Table t, boolean systemTable) throws IOException, SQLException {
            this.loadTableData(t, systemTable, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadTableData(Table t, boolean systemTable, boolean errorCheck) throws IOException, SQLException {
            TimeZone prevJackcessTimeZone = t.getDatabase().getTimeZone();
            t.getDatabase().setTimeZone(TimeZone.getTimeZone("UTC"));
            int step = errorCheck ? 1 : 2000;
            try (Statement ps = null;){
                int i = 0;
                Iterator it = t.iterator();
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    ArrayList<Object> values = new ArrayList<Object>();
                    if (row == null) continue;
                    if (ps == null) {
                        ps = this.sqlInsert(t, (Map<String, Object>)row, systemTable);
                    }
                    for (Map.Entry entry : row.entrySet()) {
                        values.add(this.value(entry.getValue(), t, (String)entry.getKey(), row));
                    }
                    LoadJet.this.execInsert((PreparedStatement)ps, values);
                    if (errorCheck || i > 0 && i % step == 0 || !it.hasNext()) {
                        try {
                            ps.executeBatch();
                        }
                        catch (SQLException e) {
                            int ec = e.getErrorCode();
                            if (!errorCheck && ec == -10) {
                                this.dropTable(t, systemTable);
                                this.createSyncrTable(t, systemTable, true);
                                this.loadTableData(t, systemTable, true);
                            }
                            if (ec == -10 || ec == -177 || ec == -104) {
                                if (ec == -177) {
                                    Logger.logWarning(e.getMessage());
                                }
                                this.recreate(t, systemTable, row, e.getErrorCode());
                            }
                            throw e;
                        }
                        if (errorCheck) {
                            LoadJet.this.conn.rollback();
                        } else {
                            LoadJet.this.conn.commit();
                        }
                    }
                    ++i;
                }
                if (i != t.getRowCount() && step != 1) {
                    Logger.logParametricWarning(Logger.Messages.ROW_COUNT, t.getName(), String.valueOf(t.getRowCount()), String.valueOf(i));
                }
            }
            t.getDatabase().setTimeZone(prevJackcessTimeZone);
        }

        private void loadTableFKs(String tn, boolean autoref) throws IOException, SQLException {
            if (this.readOnlyTables.contains(tn)) {
                return;
            }
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (t != null) {
                for (Index index : table.getIndexes()) {
                    IndexImpl idx = (IndexImpl)index;
                    if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                    boolean isAuto = idx.getTable().getName().equals(idx.getReferencedIndex().getTable().getName());
                    if ((!autoref || !isAuto) && (autoref || isAuto)) continue;
                    this.loadForeignKey((Index)idx, tn);
                }
            }
        }

        private void createCalculatedFieldsTriggers() {
            for (String trigger : this.calculatedFieldsTriggers) {
                try {
                    LoadJet.this.exec(trigger, false);
                }
                catch (SQLException e) {
                    Logger.logWarning(e.getMessage());
                }
            }
        }

        private void loadTableIndexesUK(String tn) throws IOException, SQLException {
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (t != null) {
                for (Index index : table.getIndexes()) {
                    if (index.isForeignKey() || !index.isPrimaryKey() && !index.isUnique()) continue;
                    this.loadIndex(index, tn);
                }
            }
        }

        private void loadTableIndexesNotUK(String tn) throws IOException, SQLException {
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (!LoadJet.this.skipIndexes && t != null) {
                for (Index index : table.getIndexes()) {
                    if (index.isForeignKey() || index.isPrimaryKey() || index.isUnique()) continue;
                    this.loadIndex(index, tn);
                }
            }
        }

        private void createTables() throws SQLException, IOException {
            LoadJet.this.metadata.createMetadata();
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                UcanaccessTable t = null;
                Table t2 = null;
                try {
                    t2 = LoadJet.this.dbIO.getTable(tn);
                    t = new UcanaccessTable(t2, tn);
                }
                catch (Exception e) {
                    Logger.logWarning(e.getMessage());
                    this.unresolvedTables.add(tn);
                }
                if (t2 == null || t == null || tn.startsWith("~")) continue;
                this.createTable(t);
                this.loadingOrder.add(t.getName());
            }
        }

        private void createIndexesUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createIndexesNotUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesNotUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createFKs() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableFKs(tn, false);
                LoadJet.this.conn.commit();
            }
        }

        private void createAutoFKs() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                try {
                    this.loadTableFKs(tn, true);
                }
                catch (SQLException e) {
                    UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                    this.makeTableReadOnly(t, false);
                }
                LoadJet.this.conn.commit();
            }
        }

        private void loadTablesData() throws SQLException, IOException {
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn)) continue;
                UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                this.loadTableData(t, false);
                LoadJet.this.conn.commit();
            }
        }

        private void createTriggers() throws IOException, SQLException {
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn) || this.readOnlyTables.contains(tn)) continue;
                UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                this.createSyncrTriggers(t);
            }
            this.createCalculatedFieldsTriggers();
        }

        private void createSystemTables() throws SQLException, IOException {
            if (LoadJet.this.sysSchema) {
                this.createSystemSchema();
                for (String tn : LoadJet.this.dbIO.getSystemTableNames()) {
                    UcanaccessTable t = null;
                    try {
                        t = new UcanaccessTable(LoadJet.this.dbIO.getSystemTable(tn), tn);
                        if (t == null) continue;
                        this.createTable(t, true);
                        this.loadTableData(t, true);
                        LoadJet.this.exec("SET TABLE " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " READONLY TRUE ", false);
                        LoadJet.this.exec("GRANT SELECT  ON " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " TO PUBLIC ", false);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void loadTables() throws SQLException, IOException {
            this.createTables();
            this.createIndexesUK();
            boolean reorder = this.reorder();
            if (reorder) {
                this.createFKs();
            }
            this.createIndexesNotUK();
            this.loadTablesData();
            this.createTriggers();
            if (!reorder) {
                this.createFKs();
            }
            this.createAutoFKs();
            this.createSystemTables();
        }

        private void createSystemSchema() throws SQLException {
            LoadJet.this.exec("CREATE SCHEMA SYS AUTHORIZATION DBA", false);
        }

        private void createSyncrTriggers(Table t) throws SQLException, IOException {
            this.setDefaultValues(t);
            String ntn = LoadJet.this.escapeIdentifier(t.getName());
            LoadJet.this.triggersGenerator.synchronisationTriggers(ntn, LoadJet.hasAutoNumberColumn(t), this.hasAppendOnly(t));
            LoadJet.this.loadedTables.add(t.getName());
        }

        private PreparedStatement sqlInsert(Table t, Map<String, Object> row, boolean systemTable) throws IOException, SQLException {
            String tn = t.getName();
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            String comma = "";
            StringBuffer sbI = new StringBuffer(" INSERT INTO ").append(ntn).append(" (");
            StringBuffer sbE = new StringBuffer(" VALUES( ");
            Set<String> se = row.keySet();
            comma = "";
            for (String cn : se) {
                sbI.append(comma).append(LoadJet.this.escapeIdentifier(cn));
                sbE.append(comma).append(" ? ");
                comma = ",";
            }
            sbI.append(") ");
            sbE.append(")");
            sbI.append(sbE);
            return LoadJet.this.conn.prepareStatement(sbI.toString());
        }

        private Object value(Object value, Table table, String columnName, Row row) throws SQLException {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                if (value.equals(Float.valueOf(Float.NaN))) {
                    return value;
                }
                BigDecimal bd = new BigDecimal(value.toString());
                return bd;
            }
            if (value instanceof Date && !(value instanceof Timestamp)) {
                return LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.of("UTC"));
            }
            if (value instanceof ComplexValueForeignKey) {
                try {
                    return ComplexBase.convert((ComplexValueForeignKey)value);
                }
                catch (IOException e) {
                    throw new UcanaccessSQLException(e);
                }
            }
            if (value instanceof byte[] && BlobKey.hasPrimaryKey(table)) {
                BlobKey bk = new BlobKey(table, columnName, row);
                return bk.getBytes();
            }
            if (value instanceof Byte) {
                return SQLConverter.asUnsigned((Byte)value);
            }
            return value;
        }
    }

    private final class LogsFlusher {
        private LogsFlusher() {
        }

        private void dumpList(List<String> logs) {
            this.dumpList(logs, false);
        }

        private void dumpList(List<String> logs, boolean cr) {
            String comma = "";
            StringBuffer sb = new StringBuffer();
            String crs = cr ? System.getProperty("line.separator") : "";
            for (String log : logs) {
                sb.append(comma).append(log).append(crs);
                comma = ", ";
            }
            Logger.log(sb.toString());
            logs.clear();
        }
    }

    private final class FunctionsLoader {
        private Set<String> functionsDefinition = new HashSet<String>();

        private FunctionsLoader() {
        }

        private void addAggregates() {
            this.functionsDefinition.add(this.getAggregate("LONGVARCHAR", "last"));
            this.functionsDefinition.add(this.getAggregate("DECIMAL(100,10)", "last"));
            this.functionsDefinition.add(this.getAggregate("BOOLEAN", "last"));
            this.functionsDefinition.add(this.getAggregate("LONGVARCHAR", "first"));
            this.functionsDefinition.add(this.getAggregate("DECIMAL(100,10)", "first"));
            this.functionsDefinition.add(this.getAggregate("BOOLEAN", "first"));
            this.functionsDefinition.add(this.getLastTimestamp());
            this.functionsDefinition.add(this.getFirstTimestamp());
        }

        private String getLastTimestamp() {
            return "CREATE AGGREGATE FUNCTION last(IN val TIMESTAMP, IN flag boolean, INOUT ts TIMESTAMP, INOUT counter INT) RETURNS TIMESTAMP CONTAINS SQL BEGIN ATOMIC IF flag THEN RETURN ts; ELSE IF counter IS NULL THEN SET counter = 0; END IF; SET counter = counter + 1; SET ts = val;RETURN NULL; END IF; END ";
        }

        private String getFirstTimestamp() {
            return "CREATE AGGREGATE FUNCTION First(IN val TIMESTAMP, IN flag boolean, INOUT ts TIMESTAMP , INOUT counter INT) RETURNS TIMESTAMP CONTAINS SQL BEGIN ATOMIC IF flag THEN RETURN ts; ELSE IF counter IS NULL THEN SET counter = 0; END IF; SET counter = counter + 1;  IF counter = 1 THEN   SET ts = val; END IF; RETURN NULL; END IF; END ";
        }

        private void addFunction(String functionName, String methodName, String returnType, String ... parTypes) {
            StringBuffer funDef = new StringBuffer();
            if (DBReference.is2xx()) {
                funDef.append("CREATE FUNCTION ").append(functionName).append("(");
                String comma = "";
                for (int i = 0; i < parTypes.length; ++i) {
                    funDef.append(comma).append("par").append(i).append(" ").append(parTypes[i]);
                    comma = ",";
                }
                funDef.append(")");
                funDef.append(" RETURNS ");
                funDef.append(returnType);
                funDef.append("  LANGUAGE JAVA DETERMINISTIC NO SQL  EXTERNAL NAME 'CLASSPATH:");
                funDef.append(methodName).append("'");
            } else {
                funDef.append("CREATE ALIAS ").append(functionName).append(" FOR \"").append(methodName).append("\"");
            }
            this.functionsDefinition.add(funDef.toString());
        }

        private void addFunctions(Class<?> clazz, boolean cswitch) throws SQLException {
            Method[] mths = clazz.getDeclaredMethods();
            Map<String, String> tmap = TypesMap.getAccess2HsqlTypesMap();
            for (Method mth : mths) {
                Annotation[] ants;
                for (Annotation ant : ants = mth.getAnnotations()) {
                    String returnType;
                    if (!ant.annotationType().equals(FunctionType.class)) continue;
                    FunctionType ft = (FunctionType)ant;
                    String methodName = clazz.getName() + "." + mth.getName();
                    String functionName = ft.functionName();
                    if (functionName == null) {
                        functionName = methodName;
                    }
                    TypesMap.AccessType[] acts = ft.argumentTypes();
                    TypesMap.AccessType ret = ft.returnType();
                    String retTypeName = ret.name();
                    String string = returnType = tmap.containsKey(retTypeName) ? tmap.get(retTypeName) : retTypeName;
                    if (TypesMap.AccessType.TEXT.equals((Object)ret)) {
                        returnType = returnType + "(255)";
                    }
                    String[] args = new String[acts.length];
                    for (int i = 0; i < args.length; ++i) {
                        String typeName = acts[i].name();
                        String string2 = args[i] = tmap.containsKey(typeName) ? tmap.get(typeName) : typeName;
                        if (!TypesMap.AccessType.TEXT.equals((Object)acts[i])) continue;
                        int n = i;
                        args[n] = args[n] + "(255)";
                    }
                    if (ft.namingConflict()) {
                        SQLConverter.addWAFunctionName(functionName);
                        functionName = functionName + "WA";
                    }
                    this.addFunction(functionName, methodName, returnType, args);
                }
            }
            this.createFunctions();
            if (cswitch) {
                this.createSwitch();
            }
        }

        private void resetDefault() throws SQLException {
            Method[] mths;
            Class<Functions> clazz = Functions.class;
            for (Method mth : mths = clazz.getDeclaredMethods()) {
                Annotation[] ants;
                for (Annotation ant : ants = mth.getAnnotations()) {
                    if (!ant.annotationType().equals(FunctionType.class)) continue;
                    FunctionType ft = (FunctionType)ant;
                    String functionName = ft.functionName();
                    if (!ft.namingConflict()) continue;
                    SQLConverter.addWAFunctionName(functionName);
                }
            }
        }

        private void createFunctions() throws SQLException {
            for (String functionDef : this.functionsDefinition) {
                try {
                    LoadJet.this.exec(functionDef, true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Logger.logParametricWarning(Logger.Messages.FUNCTION_ALREADY_ADDED, functionDef);
                }
            }
            this.functionsDefinition.clear();
        }

        private void createSwitch() throws SQLException {
            DataType[] dtypes;
            for (DataType dtype : dtypes = new DataType[]{DataType.BINARY, DataType.BOOLEAN, DataType.SHORT_DATE_TIME, DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.MONEY, DataType.NUMERIC, DataType.COMPLEX_TYPE, DataType.MEMO}) {
                String type = " " + TypesMap.map2hsqldb(dtype) + " ";
                for (int i = 1; i < 10; ++i) {
                    StringBuffer header = new StringBuffer("CREATE FUNCTION SWITCH(  ");
                    StringBuffer body = new StringBuffer("(CASE ");
                    String comma = "";
                    for (int j = 0; j < i; ++j) {
                        body.append("  WHEN B").append(j).append(" THEN V").append(j);
                        header.append(comma).append("B").append(j).append(" BOOLEAN ,").append("V").append(j).append(type);
                        comma = ",";
                    }
                    body.append(" END)");
                    header.append(") RETURNS").append(type).append(" RETURN").append(body);
                    try {
                        LoadJet.this.exec(header.toString(), true);
                        continue;
                    }
                    catch (SQLException e) {
                        Logger.logParametricWarning(Logger.Messages.FUNCTION_ALREADY_ADDED, header.toString());
                    }
                }
            }
        }

        private String getAggregate(String type, String fun) {
            String createLast = "CREATE AGGREGATE FUNCTION " + fun + "(IN val " + type + ", IN flag BOOLEAN, INOUT register  " + type + ", INOUT counter INT)   RETURNS  " + type + "  NO SQL  LANGUAGE JAVA   EXTERNAL NAME 'CLASSPATH:net.ucanaccess.converters.FunctionsAggregate." + fun + "'";
            return createLast;
        }

        private void loadMappedFunctions() throws SQLException {
            this.addFunctions(Functions.class, true);
            this.addAggregates();
            this.createFunctions();
        }
    }
}

