/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.ImportFormat;
import com.dropbox.core.v2.paper.PaperDocUpdatePolicy;
import com.dropbox.core.v2.paper.RefPaperDoc;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class PaperDocUpdateArgs
extends RefPaperDoc {
    protected final PaperDocUpdatePolicy docUpdatePolicy;
    protected final long revision;
    protected final ImportFormat importFormat;

    public PaperDocUpdateArgs(String docId, PaperDocUpdatePolicy docUpdatePolicy, long revision, ImportFormat importFormat) {
        super(docId);
        if (docUpdatePolicy == null) {
            throw new IllegalArgumentException("Required value for 'docUpdatePolicy' is null");
        }
        this.docUpdatePolicy = docUpdatePolicy;
        this.revision = revision;
        if (importFormat == null) {
            throw new IllegalArgumentException("Required value for 'importFormat' is null");
        }
        this.importFormat = importFormat;
    }

    @Override
    public String getDocId() {
        return this.docId;
    }

    public PaperDocUpdatePolicy getDocUpdatePolicy() {
        return this.docUpdatePolicy;
    }

    public long getRevision() {
        return this.revision;
    }

    public ImportFormat getImportFormat() {
        return this.importFormat;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.docUpdatePolicy, this.revision, this.importFormat});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocUpdateArgs other = (PaperDocUpdateArgs)obj;
            return !(this.docId != other.docId && !this.docId.equals(other.docId) || this.docUpdatePolicy != other.docUpdatePolicy && !this.docUpdatePolicy.equals((Object)other.docUpdatePolicy) || this.revision != other.revision || this.importFormat != other.importFormat && !this.importFormat.equals((Object)other.importFormat));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocUpdateArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocUpdateArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("doc_id");
            StoneSerializers.string().serialize(value.docId, g);
            g.writeFieldName("doc_update_policy");
            PaperDocUpdatePolicy.Serializer.INSTANCE.serialize(value.docUpdatePolicy, g);
            g.writeFieldName("revision");
            StoneSerializers.int64().serialize((Long)value.revision, g);
            g.writeFieldName("import_format");
            ImportFormat.Serializer.INSTANCE.serialize(value.importFormat, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperDocUpdateArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            ImportFormat f_importFormat;
            Long f_revision;
            PaperDocUpdatePolicy f_docUpdatePolicy;
            String f_docId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docId = null;
                f_docUpdatePolicy = null;
                f_revision = null;
                f_importFormat = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_id".equals(field)) {
                        f_docId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("doc_update_policy".equals(field)) {
                        f_docUpdatePolicy = PaperDocUpdatePolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("revision".equals(field)) {
                        f_revision = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    if ("import_format".equals(field)) {
                        f_importFormat = ImportFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docId == null) {
                    throw new JsonParseException(p, "Required field \"doc_id\" missing.");
                }
                if (f_docUpdatePolicy == null) {
                    throw new JsonParseException(p, "Required field \"doc_update_policy\" missing.");
                }
                if (f_revision == null) {
                    throw new JsonParseException(p, "Required field \"revision\" missing.");
                }
                if (f_importFormat == null) {
                    throw new JsonParseException(p, "Required field \"import_format\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocUpdateArgs value = new PaperDocUpdateArgs(f_docId, f_docUpdatePolicy, f_revision, f_importFormat);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

