/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.DeviceSessionArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class RevokeDesktopClientArg
extends DeviceSessionArg {
    protected final boolean deleteOnUnlink;

    public RevokeDesktopClientArg(String sessionId, String teamMemberId, boolean deleteOnUnlink) {
        super(sessionId, teamMemberId);
        this.deleteOnUnlink = deleteOnUnlink;
    }

    public RevokeDesktopClientArg(String sessionId, String teamMemberId) {
        this(sessionId, teamMemberId, false);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getDeleteOnUnlink() {
        return this.deleteOnUnlink;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.deleteOnUnlink});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RevokeDesktopClientArg other = (RevokeDesktopClientArg)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.deleteOnUnlink != other.deleteOnUnlink);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RevokeDesktopClientArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RevokeDesktopClientArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("session_id");
            StoneSerializers.string().serialize(value.sessionId, g);
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("delete_on_unlink");
            StoneSerializers.boolean_().serialize((Boolean)value.deleteOnUnlink, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RevokeDesktopClientArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_deleteOnUnlink;
            String f_teamMemberId;
            String f_sessionId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sessionId = null;
                f_teamMemberId = null;
                f_deleteOnUnlink = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("session_id".equals(field)) {
                        f_sessionId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("delete_on_unlink".equals(field)) {
                        f_deleteOnUnlink = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sessionId == null) {
                    throw new JsonParseException(p, "Required field \"session_id\" missing.");
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RevokeDesktopClientArg value = new RevokeDesktopClientArg(f_sessionId, f_teamMemberId, f_deleteOnUnlink);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

