/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;

@BetaApi
public class FakeServiceImpl
extends FakeServiceGrpc.FakeServiceImplBase {
    private Throwable receivedError;

    public Throwable getLastRecievedError() {
        return this.receivedError;
    }

    @Override
    public StreamObserver<Color> streamingRecognize(StreamObserver<Money> responseObserver) {
        return new RequestStreamObserver(responseObserver);
    }

    @Override
    public StreamObserver<Color> streamingRecognizeError(final StreamObserver<Money> responseObserver) {
        return new StreamObserver<Color>(){

            public void onNext(Color color) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT));
            }

            public void onError(Throwable throwable) {
                FakeServiceImpl.this.receivedError = throwable;
            }

            public void onCompleted() {
            }
        };
    }

    @Override
    public void serverStreamingRecognize(final Color color, final StreamObserver<Money> responseObserver) {
        if (color.getRed() < 0.0f) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("red must be positive").asRuntimeException());
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep((long)color.getGreen());
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return;
                }
                responseObserver.onNext((Object)FakeServiceImpl.convert(color));
                responseObserver.onCompleted();
            }
        };
        if (color.getGreen() > 0.0f) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    @Override
    public StreamObserver<Color> clientStreamingRecognize(StreamObserver<Money> responseObserver) {
        return new RequestStreamObserver(responseObserver);
    }

    private static Money convert(Color color) {
        Money result = Money.newBuilder().setCurrencyCode("USD").setUnits((long)(color.getRed() * 255.0f)).build();
        return result;
    }

    private static class RequestStreamObserver
    implements StreamObserver<Color> {
        private StreamObserver<Money> responseObserver;

        public RequestStreamObserver(StreamObserver<Money> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public void onNext(Color color) {
            this.responseObserver.onNext((Object)FakeServiceImpl.convert(color));
        }

        public void onError(Throwable throwable) {
            throwable.printStackTrace(System.err);
        }

        public void onCompleted() {
            this.responseObserver.onCompleted();
        }
    }
}

