/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.EdgeStep;
import org.apache.hugegraph.util.E;

public class KoutRequest {
    @JsonProperty(value="source")
    private Object source = null;
    @JsonProperty(value="step")
    public EdgeStep step = null;
    @JsonProperty(value="max_depth")
    public int maxDepth = 5000;
    @JsonProperty(value="nearest")
    public boolean nearest = true;
    @JsonProperty(value="count_only")
    public boolean countOnly = false;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="limit")
    public int limit = 10;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;
    @JsonProperty(value="with_path")
    public boolean withPath = false;

    private KoutRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("KoutRequest{source=%s,step=%s,maxDepth=%snearest=%s,countOnly=%s,capacity=%s,limit=%s,withVertex=%s,withPath=%s}", this.source, this.step, this.maxDepth, this.nearest, this.countOnly, this.capacity, this.limit, this.withVertex, this.withPath);
    }

    public static class Builder {
        private final KoutRequest request = new KoutRequest();
        private EdgeStep.Builder stepBuilder = EdgeStep.builder();

        private Builder() {
        }

        public Builder source(Object source) {
            E.checkNotNull((Object)source, (String)"source");
            this.request.source = source;
            return this;
        }

        public EdgeStep.Builder step() {
            EdgeStep.Builder builder;
            this.stepBuilder = builder = EdgeStep.builder();
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            TraversersAPI.checkPositive(maxDepth, "max depth");
            this.request.maxDepth = maxDepth;
            return this;
        }

        public Builder nearest(boolean nearest) {
            this.request.nearest = nearest;
            return this;
        }

        public Builder countOnly(boolean countOnly) {
            this.request.countOnly = countOnly;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(int limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public Builder withPath(boolean withPath) {
            this.request.withPath = withPath;
            return this;
        }

        public KoutRequest build() {
            E.checkNotNull((Object)this.request.source, (String)"The source can't be null");
            this.request.step = this.stepBuilder.build();
            E.checkNotNull((Object)this.request.step, (String)"step");
            TraversersAPI.checkPositive(this.request.maxDepth, "max depth");
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            if (this.request.countOnly) {
                E.checkArgument((!this.request.withVertex && !this.request.withPath ? 1 : 0) != 0, (String)"Can't return vertex or path when count only is true", (Object[])new Object[0]);
            }
            return this.request;
        }
    }
}

