/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DbType {
    MYSQL("mysql", "MySql\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect"),
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MariaDBDialect"),
    ORACLE("oracle", "Oracle11g\u53ca\u4ee5\u4e0b\u6570\u636e\u5e93(\u9ad8\u7248\u672c\u63a8\u8350\u4f7f\u7528ORACLE_NEW)", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect"),
    ORACLE_12C("oracle12c", "Oracle12c+\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.Oracle12cDialect"),
    DB2("db2", "DB2\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DB2Dialect"),
    H2("h2", "H2\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.H2Dialect"),
    HSQL("hsql", "HSQL\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.HSQLDialect"),
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLiteDialect"),
    POSTGRE_SQL("postgresql", "Postgre\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect"),
    SQL_SERVER2005("sqlserver2005", "SQLServer2005\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServer2005Dialect"),
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServerDialect"),
    DM("dm", "\u8fbe\u68a6\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DmDialect"),
    XU_GU("xugu", "\u865a\u8c37\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.XuGuDialect"),
    KINGBASE_ES("kingbasees", "\u4eba\u5927\u91d1\u4ed3\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.KingbaseDialect"),
    OTHER("other", "\u5176\u4ed6\u6570\u636e\u5e93", "com.baomidou.mybatisplus.extension.plugins.pagination.dialects.UnknownDialect");

    private final String db;
    private final String desc;
    private String dialect;
    private static Map<String, DbType> DB_CACHE_MAP;

    public static DbType getDbType(String dbType) {
        return DB_CACHE_MAP.getOrDefault(dbType.toLowerCase(), OTHER);
    }

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDialect() {
        return this.dialect;
    }

    private DbType(String db, String desc, String dialect) {
        this.db = db;
        this.desc = desc;
        this.dialect = dialect;
    }

    static {
        DB_CACHE_MAP = new ConcurrentHashMap<String, DbType>();
        for (DbType dbType : DbType.values()) {
            DB_CACHE_MAP.put(dbType.getDb().toLowerCase(), dbType);
        }
    }
}

