/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.CachePagesListView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class CachePagesListViewWalker
implements SystemViewRowAttributeWalker<CachePagesListView> {
    public static final String CACHE_GROUP_ID_FILTER = "cacheGroupId";
    public static final String PARTITION_ID_FILTER = "partitionId";
    public static final String BUCKET_NUMBER_FILTER = "bucketNumber";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(new String[]{"cacheGroupId", "partitionId", "bucketNumber"}));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, CACHE_GROUP_ID_FILTER, Integer.TYPE);
        v.accept(1, PARTITION_ID_FILTER, Integer.TYPE);
        v.accept(2, "name", String.class);
        v.accept(3, BUCKET_NUMBER_FILTER, Integer.TYPE);
        v.accept(4, "bucketSize", Long.TYPE);
        v.accept(5, "stripesCount", Integer.TYPE);
        v.accept(6, "cachedPagesCount", Integer.TYPE);
        v.accept(7, "pageFreeSpace", Integer.TYPE);
    }

    @Override
    public void visitAll(CachePagesListView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.acceptInt(0, CACHE_GROUP_ID_FILTER, row.cacheGroupId());
        v.acceptInt(1, PARTITION_ID_FILTER, row.partitionId());
        v.accept(2, "name", String.class, row.name());
        v.acceptInt(3, BUCKET_NUMBER_FILTER, row.bucketNumber());
        v.acceptLong(4, "bucketSize", row.bucketSize());
        v.acceptInt(5, "stripesCount", row.stripesCount());
        v.acceptInt(6, "cachedPagesCount", row.cachedPagesCount());
        v.acceptInt(7, "pageFreeSpace", row.pageFreeSpace());
    }

    @Override
    public int count() {
        return 8;
    }
}

