/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class ContinuousRoutineStartResultMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private static final int ERROR_FLAG = 1;
    private UUID routineId;
    private byte[] errBytes;
    private byte[] cntrsMapBytes;
    private int flags;

    public ContinuousRoutineStartResultMessage() {
    }

    ContinuousRoutineStartResultMessage(UUID routineId, byte[] cntrsMapBytes, byte[] errBytes, boolean err) {
        this.routineId = routineId;
        this.cntrsMapBytes = cntrsMapBytes;
        this.errBytes = errBytes;
        if (err) {
            this.flags |= 1;
        }
    }

    @Nullable
    byte[] countersMapBytes() {
        return this.cntrsMapBytes;
    }

    boolean error() {
        return (this.flags & 1) != 0;
    }

    UUID routineId() {
        return this.routineId;
    }

    @Nullable
    byte[] errorBytes() {
        return this.errBytes;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("cntrsMapBytes", this.cntrsMapBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeUuid("routineId", this.routineId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cntrsMapBytes = reader.readByteArray("cntrsMapBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.flags = reader.readInt("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.routineId = reader.readUuid("routineId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ContinuousRoutineStartResultMessage.class);
    }

    @Override
    public short directType() {
        return 134;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(ContinuousRoutineStartResultMessage.class, this);
    }
}

