/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

public class SchemaSqlViewManager
implements IgniteChangeGlobalStateSupport {
    private static final String SQL_VIEW_KEY_PREFIX = "ignite.internal.sql.view.";
    private final GridKernalContext ctx;
    private volatile DistributedMetaStorage metastorage;
    private final IgniteLogger log;

    public SchemaSqlViewManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(SchemaSqlViewManager.class);
    }

    public void start() {
        this.ctx.internalSubscriptionProcessor().registerDistributedMetastorageListener(new DistributedMetastorageLifecycleListener(){

            @Override
            public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
                metastorage.listen(key -> key.startsWith(SchemaSqlViewManager.SQL_VIEW_KEY_PREFIX), (x$0, x$1, x$2) -> SchemaSqlViewManager.this.processMetastorageUpdate(x$0, x$1, x$2));
            }

            @Override
            public void onReadyForWrite(DistributedMetaStorage metastorage) {
                SchemaSqlViewManager.this.metastorage = metastorage;
            }
        });
        this.ctx.internalSubscriptionProcessor().registerGlobalStateListener(this);
    }

    public void createView(String schemaName, String viewName, String viewSql, boolean replace) throws IgniteCheckedException {
        Object oldVal;
        this.ctx.security().authorize(SecurityPermission.SQL_VIEW_CREATE);
        if (!this.ctx.query().schemaManager().schemaNames().contains(schemaName)) {
            throw new SchemaOperationException(11, schemaName);
        }
        String key = SchemaSqlViewManager.makeKey(schemaName, viewName);
        SqlView newVal = new SqlView(schemaName, viewName, viewSql);
        do {
            if ((oldVal = this.metastorage.read(key)) == null || replace) continue;
            throw new SchemaOperationException(10, viewName);
        } while (!this.metastorage.compareAndSet(key, (Serializable)oldVal, newVal));
    }

    public void dropView(String schemaName, String viewName, boolean ifExists) throws IgniteCheckedException {
        Object oldVal;
        this.ctx.security().authorize(SecurityPermission.SQL_VIEW_DROP);
        String key = SchemaSqlViewManager.makeKey(schemaName, viewName);
        do {
            if ((oldVal = this.metastorage.read(key)) != null) continue;
            if (!ifExists) {
                throw new SchemaOperationException(9, viewName);
            }
            return;
        } while (!this.metastorage.compareAndRemove(key, (Serializable)oldVal));
    }

    public void clearSchemaViews(String schemaName) {
        if (!U.isLocalNodeCoordinator(this.ctx.discovery())) {
            return;
        }
        try {
            this.metastorage.iterate(SchemaSqlViewManager.makeKey(schemaName, null), (k, v) -> {
                try {
                    this.metastorage.removeAsync((String)k);
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Failed to remove SQL views from metastorage [key=" + k + "]", e);
                }
            });
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to get views list from metastorage", e);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.metastorage.iterate(SQL_VIEW_KEY_PREFIX, (k, v) -> this.processMetastorageUpdate((String)k, null, (Serializable)v));
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
    }

    private void processMetastorageUpdate(String key, @Nullable Serializable oldVal, @Nullable Serializable newVal) {
        String viewName;
        assert (key.startsWith(SQL_VIEW_KEY_PREFIX)) : "Invalid key: " + key;
        assert (oldVal == null || oldVal instanceof SqlView) : "Invalid old value: " + oldVal;
        assert (newVal == null || newVal instanceof SqlView) : "Invalid new value: " + newVal;
        assert (oldVal != null || newVal != null);
        String schemaName = newVal == null ? ((SqlView)oldVal).schemaName : ((SqlView)newVal).schemaName;
        String string = viewName = newVal == null ? ((SqlView)oldVal).viewName : ((SqlView)newVal).viewName;
        if (newVal == null) {
            this.ctx.query().schemaManager().dropView(schemaName, viewName);
        } else {
            this.ctx.query().schemaManager().createView(schemaName, viewName, ((SqlView)newVal).viewSql);
        }
    }

    private static String makeKey(String schemaName, @Nullable String viewName) {
        return SQL_VIEW_KEY_PREFIX + SchemaSqlViewManager.escape(schemaName) + "." + (viewName == null ? "" : SchemaSqlViewManager.escape(viewName));
    }

    private static String escape(String name) {
        return name.replace("\\", "\\\\").replace(".", "\\.");
    }

    private static class SqlView
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String schemaName;
        private final String viewName;
        private final String viewSql;

        private SqlView(String schemaName, String viewName, String viewSql) {
            this.schemaName = schemaName;
            this.viewName = viewName;
            this.viewSql = viewSql;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SqlView)) {
                return false;
            }
            SqlView view = (SqlView)o;
            return Objects.equals(this.schemaName, view.schemaName) && Objects.equals(this.viewName, view.viewName) && Objects.equals(this.viewSql, view.viewSql);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.viewName, this.viewSql);
        }

        public String toString() {
            return S.toString(SqlView.class, this);
        }
    }
}

