/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.math.BigDecimal;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;

public class ByteIndexKey
extends NumericIndexKey {
    private final byte key;

    public ByteIndexKey(byte key) {
        this.key = key;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.BYTE;
    }

    @Override
    public int compareTo(boolean val) {
        return Boolean.compare(this.key != 0, val);
    }

    @Override
    public int compareTo(byte val) {
        return Integer.signum(Byte.compare(this.key, val));
    }

    @Override
    public int compareTo(short val) {
        return Integer.compare(this.key, val);
    }

    @Override
    public int compareTo(int val) {
        return Integer.compare(this.key, val);
    }

    @Override
    public int compareTo(long val) {
        return Long.compare(this.key, val);
    }

    @Override
    public int compareTo(float val) {
        return Float.compare(this.key, val);
    }

    @Override
    public int compareTo(double val) {
        return Double.compare(this.key, val);
    }

    @Override
    public int compareTo(BigDecimal val) {
        return BigDecimal.valueOf(this.key).compareTo(val);
    }

    @Override
    public int compare(IndexKey o) {
        return -((NumericIndexKey)o).compareTo(this.key);
    }

    public String toString() {
        return String.valueOf(this.key);
    }
}

