/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.IOException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;

abstract class OptimizedObjectStreamRegistry {
    OptimizedObjectStreamRegistry() {
    }

    abstract OptimizedObjectOutputStream out() throws IgniteInterruptedCheckedException;

    abstract OptimizedObjectInputStream in() throws IgniteInterruptedCheckedException;

    abstract void closeOut(OptimizedObjectOutputStream var1);

    abstract void closeIn(OptimizedObjectInputStream var1);

    static OptimizedObjectOutputStream createOut() {
        try {
            return new OptimizedObjectOutputStream(new GridUnsafeDataOutput(4096));
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create object output stream.", e);
        }
    }

    static OptimizedObjectInputStream createIn() {
        try {
            return new OptimizedObjectInputStream(new GridUnsafeDataInput());
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create object input stream.", e);
        }
    }
}

