/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.query;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformAbstractQueryCursor;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;

public class PlatformFieldsQueryCursor
extends PlatformAbstractQueryCursor<List<?>> {
    private static final int OP_GET_FIELD_NAMES = 7;
    private static final int OP_GET_FIELDS_META = 8;

    public PlatformFieldsQueryCursor(PlatformContext platformCtx, QueryCursorEx<List<?>> cursor, int batchSize) {
        super(platformCtx, cursor, batchSize);
    }

    @Override
    protected void write(BinaryRawWriterEx writer, List vals) {
        assert (vals != null);
        int rowSizePos = writer.reserveInt();
        writer.writeInt(vals.size());
        for (Object val : vals) {
            writer.writeObjectDetached(val);
        }
        int rowEndPos = writer.out().position();
        writer.writeInt(rowSizePos, rowEndPos - rowSizePos);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 7) {
            List<GridQueryFieldMetadata> fieldsMeta = this.cursor().fieldsMeta();
            writer.writeInt(fieldsMeta.size());
            for (GridQueryFieldMetadata meta : fieldsMeta) {
                writer.writeString(meta.fieldName());
            }
        } else if (type == 8) {
            List<GridQueryFieldMetadata> metas = this.cursor().fieldsMeta();
            if (metas == null) {
                writer.writeInt(0);
            } else {
                writer.writeInt(metas.size());
                for (GridQueryFieldMetadata meta : metas) {
                    writer.writeString(meta.fieldName());
                    writer.writeString(meta.fieldTypeName());
                }
            }
        } else {
            super.processOutStream(type, writer);
        }
    }
}

