#!/usr/bin/env bash
#
# ignite Bash Completion
# =======================
#
# Bash completion support for the `ignite` command,
# generated by [picocli](http://picocli.info/) version 4.6.2.
#
# Installation
# ------------
#
# 1. Source all completion scripts in your .bash_profile
#
#   cd $YOUR_APP_HOME/bin
#   for f in $(find . -name "*_completion"); do line=". $(pwd)/$f"; grep "$line" ~/.bash_profile || echo "$line" >> ~/.bash_profile; done
#
# 2. Open a new bash console, and type `ignite [TAB][TAB]`
#
# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:
#     Place this file in a `bash-completion.d` folder:
#
#   * /etc/bash-completion.d
#   * /usr/local/etc/bash-completion.d
#   * ~/bash-completion.d
#
# Documentation
# -------------
# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after
# 'ignite (..)'. By reading entered command line parameters,
# it determines possible bash completions and writes them to the COMPREPLY variable.
# Bash then completes the user input if only one entry is listed in the variable or
# shows the options if more than one is listed in COMPREPLY.
#
# References
# ----------
# [1] http://stackoverflow.com/a/12495480/1440785
# [2] http://tiswww.case.edu/php/chet/bash/FAQ
# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html
# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES
# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655
# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion
# [7] https://stackoverflow.com/questions/3249432/can-a-bash-tab-completion-script-be-used-in-zsh/27853970#27853970
#

if [ -n "$BASH_VERSION" ]; then
  # Enable programmable completion facilities when using bash (see [3])
  shopt -s progcomp
elif [ -n "$ZSH_VERSION" ]; then
  # Make alias a distinct command for completion purposes when using zsh (see [4])
  setopt COMPLETE_ALIASES
  alias compopt=complete

  # Enable bash completion in zsh (see [7])
  autoload -U +X compinit && compinit
  autoload -U +X bashcompinit && bashcompinit
fi

# CompWordsContainsArray takes an array and then checks
# if all elements of this array are in the global COMP_WORDS array.
#
# Returns zero (no error) if all elements of the array are in the COMP_WORDS array,
# otherwise returns 1 (error).
function CompWordsContainsArray() {
  declare -a localArray
  localArray=("$@")
  local findme
  for findme in "${localArray[@]}"; do
    if ElementNotInCompWords "$findme"; then return 1; fi
  done
  return 0
}
function ElementNotInCompWords() {
  local findme="$1"
  local element
  for element in "${COMP_WORDS[@]}"; do
    if [[ "$findme" = "$element" ]]; then return 1; fi
  done
  return 0
}

# The `currentPositionalIndex` function calculates the index of the current positional parameter.
#
# currentPositionalIndex takes three parameters:
# the command name,
# a space-separated string with the names of options that take a parameter, and
# a space-separated string with the names of boolean options (that don't take any params).
# When done, this function echos the current positional index to std_out.
#
# Example usage:
# local currIndex=$(currentPositionalIndex "mysubcommand" "$ARG_OPTS" "$FLAG_OPTS")
function currentPositionalIndex() {
  local commandName="$1"
  local optionsWithArgs="$2"
  local booleanOptions="$3"
  local previousWord
  local result=0

  for i in $(seq $((COMP_CWORD - 1)) -1 0); do
    previousWord=${COMP_WORDS[i]}
    if [ "${previousWord}" = "$commandName" ]; then
      break
    fi
    if [[ "${optionsWithArgs}" =~ ${previousWord} ]]; then
      ((result-=2)) # Arg option and its value not counted as positional param
    elif [[ "${booleanOptions}" =~ ${previousWord} ]]; then
      ((result-=1)) # Flag option itself not counted as positional param
    fi
    ((result++))
  done
  echo "$result"
}

# Bash completion entry point function.
# _complete_ignite finds which commands and subcommands have been specified
# on the command line and delegates to the appropriate function
# to generate possible options and subcommands for the last specified subcommand.
function _complete_ignite() {
  local cmds0=(sql)
  local cmds1=(help)
  local cmds2=(status)
  local cmds3=(cluster show)
  local cmds4=(cli)
  local cmds5=(bootstrap)
  local cmds6=(node)
  local cmds7=(cluster)
  local cmds8=(cli config)
  local cmds9=(cli config get)
  local cmds10=(cli config set)
  local cmds11=(node config)
  local cmds12=(node start)
  local cmds13=(node stop)
  local cmds14=(node classpath)
  local cmds15=(node list)
  local cmds16=(node config show)
  local cmds17=(node config update)
  local cmds18=(cluster config)
  local cmds19=(cluster init)
  local cmds20=(cluster config show)
  local cmds21=(cluster config update)

  if CompWordsContainsArray "${cmds21[@]}"; then _picocli_ignite_cluster_config_update; return $?; fi
  if CompWordsContainsArray "${cmds20[@]}"; then _picocli_ignite_cluster_config_show; return $?; fi
  if CompWordsContainsArray "${cmds19[@]}"; then _picocli_ignite_cluster_init; return $?; fi
  if CompWordsContainsArray "${cmds18[@]}"; then _picocli_ignite_cluster_config; return $?; fi
  if CompWordsContainsArray "${cmds17[@]}"; then _picocli_ignite_node_config_update; return $?; fi
  if CompWordsContainsArray "${cmds16[@]}"; then _picocli_ignite_node_config_show; return $?; fi
  if CompWordsContainsArray "${cmds15[@]}"; then _picocli_ignite_node_list; return $?; fi
  if CompWordsContainsArray "${cmds14[@]}"; then _picocli_ignite_node_classpath; return $?; fi
  if CompWordsContainsArray "${cmds13[@]}"; then _picocli_ignite_node_stop; return $?; fi
  if CompWordsContainsArray "${cmds12[@]}"; then _picocli_ignite_node_start; return $?; fi
  if CompWordsContainsArray "${cmds11[@]}"; then _picocli_ignite_node_config; return $?; fi
  if CompWordsContainsArray "${cmds10[@]}"; then _picocli_ignite_cli_config_set; return $?; fi
  if CompWordsContainsArray "${cmds9[@]}"; then _picocli_ignite_cli_config_get; return $?; fi
  if CompWordsContainsArray "${cmds8[@]}"; then _picocli_ignite_cli_config; return $?; fi
  if CompWordsContainsArray "${cmds7[@]}"; then _picocli_ignite_cluster; return $?; fi
  if CompWordsContainsArray "${cmds6[@]}"; then _picocli_ignite_node; return $?; fi
  if CompWordsContainsArray "${cmds5[@]}"; then _picocli_ignite_bootstrap; return $?; fi
  if CompWordsContainsArray "${cmds4[@]}"; then _picocli_ignite_cli; return $?; fi
  if CompWordsContainsArray "${cmds3[@]}"; then _picocli_ignite_cluster_show; return $?; fi
  if CompWordsContainsArray "${cmds2[@]}"; then _picocli_ignite_status; return $?; fi
  if CompWordsContainsArray "${cmds1[@]}"; then _picocli_ignite_help; return $?; fi
  if CompWordsContainsArray "${cmds0[@]}"; then _picocli_ignite_sql; return $?; fi

  # No subcommands were specified; generate completions for the top-level command.
  _picocli_ignite; return $?;
}

# Generates completions for the options and subcommands of the `ignite` command.
function _picocli_ignite() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="sql help status cluster show cli bootstrap node cluster"
  local flag_opts="-h --help --version"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `sql` subcommand.
function _picocli_ignite_sql() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="-u --jdbc-url -e --execute --exec -f --script-file"

  compopt +o default

  case ${prev_word} in
    -u|--jdbc-url)
      return
      ;;
    -e|--execute|--exec)
      return
      ;;
    -f|--script-file)
      compopt -o filenames
      COMPREPLY=( $( compgen -f -- "${curr_word}" ) ) # files
      return $?
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `help` subcommand.
function _picocli_ignite_help() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="sql status cli bootstrap node cluster"
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `status` subcommand.
function _picocli_ignite_status() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--cluster-url"

  compopt +o default

  case ${prev_word} in
    --cluster-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cluster show` subcommand.
function _picocli_ignite_cluster_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--cluster-url"

  compopt +o default

  case ${prev_word} in
    --cluster-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cli` subcommand.
function _picocli_ignite_cli() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config"
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `bootstrap` subcommand.
function _picocli_ignite_bootstrap() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--repo"

  compopt +o default

  case ${prev_word} in
    --repo)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `node` subcommand.
function _picocli_ignite_node() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config start stop classpath list"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `cluster` subcommand.
function _picocli_ignite_cluster() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="config init"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite_cli_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="get set"
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `get` subcommand.
function _picocli_ignite_cli_config_get() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `set` subcommand.
function _picocli_ignite_cli_config_set() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite_node_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="show update"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `start` subcommand.
function _picocli_ignite_node_start() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--config"

  compopt +o default

  case ${prev_word} in
    --config)
      compopt -o filenames
      COMPREPLY=( $( compgen -f -- "${curr_word}" ) ) # files
      return $?
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `stop` subcommand.
function _picocli_ignite_node_stop() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `classpath` subcommand.
function _picocli_ignite_node_classpath() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `list` subcommand.
function _picocli_ignite_node_list() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite_node_config_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--selector --node-url"

  compopt +o default

  case ${prev_word} in
    --selector)
      return
      ;;
    --node-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `update` subcommand.
function _picocli_ignite_node_config_update() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--node-url"

  compopt +o default

  case ${prev_word} in
    --node-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `config` subcommand.
function _picocli_ignite_cluster_config() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}

  local commands="show update"
  local flag_opts=""
  local arg_opts=""

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `init` subcommand.
function _picocli_ignite_cluster_init() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--node-endpoint --meta-storage-node --cmg-node --cluster-name"

  compopt +o default

  case ${prev_word} in
    --node-endpoint)
      return
      ;;
    --meta-storage-node)
      return
      ;;
    --cmg-node)
      return
      ;;
    --cluster-name)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `show` subcommand.
function _picocli_ignite_cluster_config_show() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--selector --cluster-url"

  compopt +o default

  case ${prev_word} in
    --selector)
      return
      ;;
    --cluster-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Generates completions for the options and subcommands of the `update` subcommand.
function _picocli_ignite_cluster_config_update() {
  # Get completion data
  local curr_word=${COMP_WORDS[COMP_CWORD]}
  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  local commands=""
  local flag_opts="-h --help"
  local arg_opts="--cluster-url"

  compopt +o default

  case ${prev_word} in
    --cluster-url)
      return
      ;;
  esac

  if [[ "${curr_word}" == -* ]]; then
    COMPREPLY=( $(compgen -W "${flag_opts} ${arg_opts}" -- "${curr_word}") )
  else
    local positionals=""
    COMPREPLY=( $(compgen -W "${commands} ${positionals}" -- "${curr_word}") )
  fi
}

# Define a completion specification (a compspec) for the
# `ignite`, `ignite.sh`, and `ignite.bash` commands.
# Uses the bash `complete` builtin (see [6]) to specify that shell function
# `_complete_ignite` is responsible for generating possible completions for the
# current word on the command line.
# The `-o default` option means that if the function generated no matches, the
# default Bash completions and the Readline default filename completions are performed.
complete -F _complete_ignite -o default ignite ignite.sh ignite.bash
