/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSetBuilder;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMetricSource<T extends Holder<T>>
implements MetricSource {
    private static final AtomicReferenceFieldUpdater<AbstractMetricSource, Holder> HOLDER_FIELD_UPD = AtomicReferenceFieldUpdater.newUpdater(AbstractMetricSource.class, Holder.class, "holder");
    private final String name;
    private volatile T holder;

    protected AbstractMetricSource(String name) {
        this.name = name;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final boolean enabled() {
        return this.holder != null;
    }

    @Nullable
    public final T holder() {
        return this.holder;
    }

    protected abstract T createHolder();

    @Override
    @Nullable
    public final MetricSet enable() {
        T newHolder = this.createHolder();
        if (HOLDER_FIELD_UPD.compareAndSet(this, (Holder)null, (Holder)newHolder)) {
            MetricSetBuilder metricSetBuilder = new MetricSetBuilder(this.name);
            newHolder.metrics().forEach(metricSetBuilder::register);
            return metricSetBuilder.build();
        }
        return null;
    }

    @Override
    public final void disable() {
        HOLDER_FIELD_UPD.compareAndSet(this, (Holder)this.holder, (Holder)null);
    }

    protected static interface Holder<T extends Holder<T>> {
        public Iterable<Metric> metrics();
    }
}

