/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommandSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UpdateCommandImpl
implements UpdateCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 43;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final Long leaseStartTime;
    @IgniteToStringInclude
    private final TimedBinaryRowMessage messageRowToUpdate;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private final UUID rowUuid;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final TablePartitionIdMessage tablePartitionId;
    @IgniteToStringInclude
    private final UUID txCoordinatorId;
    @IgniteToStringInclude
    private final UUID txId;

    private UpdateCommandImpl(boolean full, HybridTimestamp initiatorTime, Long leaseStartTime, TimedBinaryRowMessage messageRowToUpdate, int requiredCatalogVersion, UUID rowUuid, HybridTimestamp safeTime, TablePartitionIdMessage tablePartitionId, UUID txCoordinatorId, UUID txId) {
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.leaseStartTime = leaseStartTime;
        this.messageRowToUpdate = messageRowToUpdate;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.rowUuid = rowUuid;
        this.safeTime = safeTime;
        this.tablePartitionId = tablePartitionId;
        this.txCoordinatorId = txCoordinatorId;
        this.txId = txId;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public Long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public TimedBinaryRowMessage messageRowToUpdate() {
        return this.messageRowToUpdate;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public UUID rowUuid() {
        return this.rowUuid;
    }

    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public TablePartitionIdMessage tablePartitionId() {
        return this.tablePartitionId;
    }

    @Override
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return UpdateCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UpdateCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 43;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateCommandImpl otherMessage = (UpdateCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && Objects.equals(this.messageRowToUpdate, otherMessage.messageRowToUpdate) && Objects.equals(this.rowUuid, otherMessage.rowUuid) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.tablePartitionId, otherMessage.tablePartitionId) && Objects.equals(this.txCoordinatorId, otherMessage.txCoordinatorId) && Objects.equals(this.txId, otherMessage.txId) && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.full, this.requiredCatalogVersion, this.initiatorTime, this.leaseStartTime, this.messageRowToUpdate, this.rowUuid, this.safeTime, this.tablePartitionId, this.txCoordinatorId, this.txId);
        return result;
    }

    public UpdateCommandImpl clone() {
        try {
            return (UpdateCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messageRowToUpdate != null) {
            this.messageRowToUpdate.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.tablePartitionId != null) {
            this.tablePartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messageRowToUpdate != null) {
            this.messageRowToUpdate.unmarshal(marshaller, descriptorsObj);
        }
        if (this.tablePartitionId != null) {
            this.tablePartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements UpdateCommandBuilder {
        private boolean full;
        private HybridTimestamp initiatorTime;
        private Long leaseStartTime;
        private TimedBinaryRowMessage messageRowToUpdate;
        private int requiredCatalogVersion;
        private UUID rowUuid;
        private HybridTimestamp safeTime;
        private TablePartitionIdMessage tablePartitionId;
        private UUID txCoordinatorId;
        private UUID txId;

        private Builder() {
        }

        @Override
        public UpdateCommandBuilder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public UpdateCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public UpdateCommandBuilder leaseStartTime(Long leaseStartTime) {
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public UpdateCommandBuilder messageRowToUpdate(TimedBinaryRowMessage messageRowToUpdate) {
            this.messageRowToUpdate = messageRowToUpdate;
            return this;
        }

        @Override
        public UpdateCommandBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public UpdateCommandBuilder rowUuid(UUID rowUuid) {
            Objects.requireNonNull(rowUuid, "rowUuid is not marked @Nullable");
            this.rowUuid = rowUuid;
            return this;
        }

        @Override
        public UpdateCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public UpdateCommandBuilder tablePartitionId(TablePartitionIdMessage tablePartitionId) {
            Objects.requireNonNull(tablePartitionId, "tablePartitionId is not marked @Nullable");
            this.tablePartitionId = tablePartitionId;
            return this;
        }

        @Override
        public UpdateCommandBuilder txCoordinatorId(UUID txCoordinatorId) {
            Objects.requireNonNull(txCoordinatorId, "txCoordinatorId is not marked @Nullable");
            this.txCoordinatorId = txCoordinatorId;
            return this;
        }

        @Override
        public UpdateCommandBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public Long leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public TimedBinaryRowMessage messageRowToUpdate() {
            return this.messageRowToUpdate;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public UUID rowUuid() {
            return this.rowUuid;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public TablePartitionIdMessage tablePartitionId() {
            return this.tablePartitionId;
        }

        @Override
        public UUID txCoordinatorId() {
            return this.txCoordinatorId;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public UpdateCommand build() {
            return new UpdateCommandImpl(this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.leaseStartTime, this.messageRowToUpdate, this.requiredCatalogVersion, Objects.requireNonNull(this.rowUuid, "rowUuid is not marked @Nullable"), this.safeTime, Objects.requireNonNull(this.tablePartitionId, "tablePartitionId is not marked @Nullable"), Objects.requireNonNull(this.txCoordinatorId, "txCoordinatorId is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

