/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.VolatilePageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite.internal.util.CompletableFutures;

public class VolatilePageMemoryTableStorage
extends AbstractPageMemoryTableStorage {
    private static final IgniteLogger LOG = Loggers.forClass(VolatilePageMemoryTableStorage.class);
    private final VolatilePageMemoryStorageEngine engine;
    private final VolatilePageMemoryDataRegion dataRegion;
    private final ExecutorService destructionExecutor;

    VolatilePageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier, VolatilePageMemoryStorageEngine engine, VolatilePageMemoryDataRegion dataRegion, ExecutorService destructionExecutor) {
        super(tableDescriptor, indexDescriptorSupplier);
        this.engine = engine;
        this.dataRegion = dataRegion;
        this.destructionExecutor = destructionExecutor;
    }

    public VolatilePageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    @Override
    public VolatilePageMemoryStorageEngine engine() {
        return this.engine;
    }

    @Override
    public VolatilePageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) throws StorageException {
        VersionChainTree versionChainTree = this.createVersionChainTree(partitionId);
        IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId);
        GcQueue gcQueue = this.createGarbageCollectionTree(partitionId);
        return new VolatilePageMemoryMvPartitionStorage(this, partitionId, versionChainTree, indexMetaTree, gcQueue, this.destructionExecutor);
    }

    private IndexMetaTree createIndexMetaTree(int partitionId) {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion.reuseList(), this.getTableId(), partitionId, (byte)2);
            return new IndexMetaTree(this.getTableId(), Integer.toString(this.getTableId()), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private GcQueue createGarbageCollectionTree(int partitionId) {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion().reuseList(), this.getTableId(), partitionId, (byte)2);
            return new GcQueue(this.getTableId(), Integer.toString(this.getTableId()), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public boolean isVolatile() {
        return true;
    }

    @Override
    protected void finishDestruction() {
    }

    private VersionChainTree createVersionChainTree(int partId) throws StorageException {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion().reuseList(), this.getTableId(), partId, (byte)2);
            return new VersionChainTree(this.getTableId(), Integer.toString(this.getTableId()), partId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating TableTree: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), partId});
        }
    }

    @Override
    CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        VolatilePageMemoryMvPartitionStorage volatilePartitionStorage = (VolatilePageMemoryMvPartitionStorage)mvPartitionStorage;
        volatilePartitionStorage.destroyStructures().whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("Could not destroy structures: [tableId={}, partitionId={}]", ex, new Object[]{this.getTableId(), volatilePartitionStorage.partitionId()});
            }
        });
        int partitionId = mvPartitionStorage.partitionId();
        volatilePartitionStorage.updateDataStructures(this.createVersionChainTree(partitionId), this.createIndexMetaTree(partitionId), this.createGarbageCollectionTree(partitionId));
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        VolatilePageMemoryMvPartitionStorage volatilePartitionStorage = (VolatilePageMemoryMvPartitionStorage)mvPartitionStorage;
        boolean transitioned = volatilePartitionStorage.transitionToDestroyedState();
        if (!transitioned) {
            return CompletableFutures.nullCompletedFuture();
        }
        return volatilePartitionStorage.destroyStructures().whenComplete((v, e) -> volatilePartitionStorage.closeResources());
    }
}

