/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server;

import java.nio.file.Path;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.RaftNodeDisruptorConfiguration;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.RaftMetaStorageFactory;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.jetbrains.annotations.Nullable;

public class RaftGroupOptions {
    private final boolean volatileStores;
    private LogStorageFactory logStorageFactory;
    @Nullable
    private SnapshotStorageFactory snapshotStorageFactory;
    private RaftMetaStorageFactory raftMetaStorageFactory;
    @Nullable
    private RaftNodeDisruptorConfiguration ownFsmCallerExecutorDisruptorConfig;
    @Nullable
    private Marshaller commandsMarshaller;
    @Nullable
    private Path serverDataPath;
    @Nullable
    private Long externallyEnforcedConfigIndex;
    private int maxClockSkewMs;

    public static RaftGroupOptions defaults() {
        return RaftGroupOptions.forPersistentStores();
    }

    public static RaftGroupOptions forPersistentStores() {
        return new RaftGroupOptions(false);
    }

    public static RaftGroupOptions forVolatileStores() {
        return new RaftGroupOptions(true);
    }

    private RaftGroupOptions(boolean volatileStores) {
        this.volatileStores = volatileStores;
    }

    public boolean volatileStores() {
        return this.volatileStores;
    }

    public LogStorageFactory getLogStorageFactory() {
        return this.logStorageFactory;
    }

    public RaftGroupOptions setLogStorageFactory(LogStorageFactory logStorageFactory) {
        this.logStorageFactory = logStorageFactory;
        return this;
    }

    @Nullable
    public SnapshotStorageFactory snapshotStorageFactory() {
        return this.snapshotStorageFactory;
    }

    public RaftGroupOptions snapshotStorageFactory(@Nullable SnapshotStorageFactory snapshotStorageFactory) {
        this.snapshotStorageFactory = snapshotStorageFactory;
        return this;
    }

    public RaftMetaStorageFactory raftMetaStorageFactory() {
        return this.raftMetaStorageFactory;
    }

    public RaftGroupOptions raftMetaStorageFactory(RaftMetaStorageFactory raftMetaStorageFactory) {
        this.raftMetaStorageFactory = raftMetaStorageFactory;
        return this;
    }

    @Nullable
    public RaftNodeDisruptorConfiguration ownFsmCallerExecutorDisruptorConfig() {
        return this.ownFsmCallerExecutorDisruptorConfig;
    }

    public RaftGroupOptions ownFsmCallerExecutorDisruptorConfig(RaftNodeDisruptorConfiguration ownFsmCallerExecutorDisruptorConfig) {
        this.ownFsmCallerExecutorDisruptorConfig = ownFsmCallerExecutorDisruptorConfig;
        return this;
    }

    @Nullable
    public Marshaller commandsMarshaller() {
        return this.commandsMarshaller;
    }

    public RaftGroupOptions commandsMarshaller(Marshaller marshaller) {
        this.commandsMarshaller = marshaller;
        return this;
    }

    @Nullable
    public Path serverDataPath() {
        return this.serverDataPath;
    }

    public RaftGroupOptions serverDataPath(Path serverDataPath) {
        this.serverDataPath = serverDataPath;
        return this;
    }

    @Nullable
    public Long externallyEnforcedConfigIndex() {
        return this.externallyEnforcedConfigIndex;
    }

    public RaftGroupOptions externallyEnforcedConfigIndex(@Nullable Long index) {
        this.externallyEnforcedConfigIndex = index;
        return this;
    }

    public RaftGroupOptions maxClockSkew(int maxClockSkewMs) {
        this.maxClockSkewMs = maxClockSkewMs;
        return this;
    }

    public int maxClockSkew() {
        return this.maxClockSkewMs;
    }
}

