/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.message.DataPresence;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataRequest;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataResponse;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageClosedException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.utils.RebalanceUtilEx;
import org.apache.ignite.network.ClusterNode;

class PartitionReplicatorNodeRecovery {
    private static final long QUERY_DATA_NODES_COUNT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final long PEERS_IN_TOPOLOGY_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final PartitionReplicationMessagesFactory TABLE_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final MetaStorageManager metaStorageManager;
    private final MessagingService messagingService;
    private final TopologyService topologyService;
    private final Executor storageAccessExecutor;
    private final IntFunction<TableViewInternal> tableById;

    PartitionReplicatorNodeRecovery(MetaStorageManager metaStorageManager, MessagingService messagingService, TopologyService topologyService, Executor storageAccessExecutor, IntFunction<TableViewInternal> tableById) {
        this.metaStorageManager = metaStorageManager;
        this.messagingService = messagingService;
        this.topologyService = topologyService;
        this.storageAccessExecutor = storageAccessExecutor;
        this.tableById = tableById;
    }

    void start() {
        this.addMessageHandler();
    }

    private void addMessageHandler() {
        this.messagingService.addMessageHandler(PartitionReplicationMessageGroup.class, (message, sender, correlationId) -> {
            if (message instanceof HasDataRequest) {
                assert (correlationId != null);
                HasDataRequest msg = (HasDataRequest)message;
                this.storageAccessExecutor.execute(() -> this.handleHasDataRequest(msg, sender, correlationId));
            }
        });
    }

    private void handleHasDataRequest(HasDataRequest msg, ClusterNode sender, Long correlationId) {
        MvTableStorage storage;
        MvPartitionStorage mvPartition;
        int tableId = msg.tableId();
        int partitionId = msg.partitionId();
        DataPresence dataPresence = DataPresence.UNKNOWN;
        TableViewInternal table = this.tableById.apply(tableId);
        if (table != null && (mvPartition = (storage = table.internalTable().storage()).getMvPartition(partitionId)) != null) {
            try {
                dataPresence = mvPartition.closestRowId(RowId.lowestRowId((int)partitionId)) != null ? DataPresence.HAS_DATA : DataPresence.EMPTY;
            }
            catch (StorageClosedException | StorageRebalanceException throwable) {
                // empty catch block
            }
        }
        this.messagingService.respond(sender, (NetworkMessage)TABLE_MESSAGES_FACTORY.hasDataResponse().presenceString(dataPresence.name()).build(), correlationId.longValue());
    }

    CompletableFuture<Boolean> initiateGroupReentryIfNeeded(TablePartitionId tablePartitionId, InternalTable internalTable, PeersAndLearners newConfiguration, Assignment localMemberAssignment, long assignmentsTimestamp) {
        if (PartitionReplicatorNodeRecovery.mightNeedGroupRecovery(internalTable)) {
            return this.performGroupRecovery(tablePartitionId, newConfiguration, localMemberAssignment, assignmentsTimestamp);
        }
        return CompletableFutures.trueCompletedFuture();
    }

    private static boolean mightNeedGroupRecovery(InternalTable internalTable) {
        return internalTable.storage().isVolatile();
    }

    private CompletableFuture<Boolean> performGroupRecovery(TablePartitionId tablePartitionId, PeersAndLearners newConfiguration, Assignment localMemberAssignment, long assignmentsTimestamp) {
        int tableId = tablePartitionId.tableId();
        int partId = tablePartitionId.partitionId();
        return this.waitForPeersAndQueryDataNodesCounts(tableId, partId, newConfiguration.peers()).thenApply(dataNodesCounts -> {
            boolean majorityAvailable;
            boolean fullPartitionRestart;
            boolean bl = fullPartitionRestart = dataNodesCounts.emptyNodes == (long)newConfiguration.peers().size();
            if (fullPartitionRestart) {
                return true;
            }
            boolean bl2 = majorityAvailable = dataNodesCounts.nonEmptyNodes >= (long)(newConfiguration.peers().size() / 2 + 1);
            if (majorityAvailable) {
                RebalanceUtilEx.startPeerRemoval(tablePartitionId, localMemberAssignment, this.metaStorageManager, assignmentsTimestamp);
                return false;
            }
            String msg = "Unable to start partition " + partId + ". Majority not available.";
            throw new IgniteInternalException(msg);
        });
    }

    private CompletableFuture<DataNodesCounts> waitForPeersAndQueryDataNodesCounts(int tblId, int partId, Collection<Peer> peers) {
        HasDataRequest request = TABLE_MESSAGES_FACTORY.hasDataRequest().tableId(tblId).partitionId(partId).build();
        return this.allPeersAreInTopology(peers).thenCompose(unused -> this.queryDataNodesCounts(peers, request));
    }

    private CompletableFuture<?> allPeersAreInTopology(final Collection<Peer> peers) {
        final Set peerConsistentIds = peers.stream().map(Peer::consistentId).collect(Collectors.toSet());
        final ConcurrentHashMap<String, ClusterNode> peerNodesByConsistentIds = new ConcurrentHashMap<String, ClusterNode>();
        for (Peer peer : peers) {
            ClusterNode node = this.topologyService.getByConsistentId(peer.consistentId());
            if (node == null) continue;
            peerNodesByConsistentIds.put(peer.consistentId(), node);
        }
        if (peerNodesByConsistentIds.size() >= peers.size()) {
            return CompletableFutures.nullCompletedFuture();
        }
        final CompletableFuture<Void> allPeersAreSeenInTopology = new CompletableFuture<Void>();
        TopologyEventHandler eventHandler = new TopologyEventHandler(){

            public void onAppeared(ClusterNode member) {
                if (peerConsistentIds.contains(member.name())) {
                    peerNodesByConsistentIds.put(member.name(), member);
                }
                if (peerNodesByConsistentIds.size() >= peers.size()) {
                    allPeersAreSeenInTopology.complete(null);
                }
            }
        };
        this.topologyService.addEventHandler(eventHandler);
        for (Peer peer : peers) {
            ClusterNode node;
            if (peerNodesByConsistentIds.containsKey(peer.consistentId()) || (node = this.topologyService.getByConsistentId(peer.consistentId())) == null) continue;
            peerNodesByConsistentIds.put(peer.consistentId(), node);
        }
        if (peerNodesByConsistentIds.size() >= peers.size()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return PartitionReplicatorNodeRecovery.withTimeout(allPeersAreSeenInTopology);
    }

    private static CompletableFuture<Void> withTimeout(CompletableFuture<Void> future) {
        return ((CompletableFuture)future.orTimeout(PEERS_IN_TOPOLOGY_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS).handle((res, ex) -> {
            if (ex instanceof TimeoutException) {
                return CompletableFuture.completedFuture(res);
            }
            if (ex != null) {
                return CompletableFuture.failedFuture(ex);
            }
            return CompletableFuture.completedFuture(res);
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<DataNodesCounts> queryDataNodesCounts(Collection<Peer> peers, HasDataRequest request) {
        CompletableFuture[] presenceFutures = (CompletableFuture[])peers.stream().map(Peer::consistentId).map(arg_0 -> ((TopologyService)this.topologyService).getByConsistentId(arg_0)).filter(Objects::nonNull).map(node -> ((CompletableFuture)this.messagingService.invoke(node, (NetworkMessage)request, QUERY_DATA_NODES_COUNT_TIMEOUT_MILLIS).thenApply(response -> {
            assert (response instanceof HasDataResponse) : response;
            return ((HasDataResponse)response).presence();
        })).exceptionally(unused -> DataPresence.UNKNOWN)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(presenceFutures).thenApply(unused -> {
            List hasDataFlags = Arrays.stream(presenceFutures).map(CompletableFuture::join).collect(Collectors.toList());
            long nodesSurelyHavingData = hasDataFlags.stream().filter(presence -> presence == DataPresence.HAS_DATA).count();
            long nodesSurelyEmpty = hasDataFlags.stream().filter(presence -> presence == DataPresence.EMPTY).count();
            return new DataNodesCounts(nodesSurelyHavingData, nodesSurelyEmpty);
        });
    }

    private static class DataNodesCounts {
        private final long nonEmptyNodes;
        private final long emptyNodes;

        private DataNodesCounts(long nonEmptyNodes, long emptyNodes) {
            this.nonEmptyNodes = nonEmptyNodes;
            this.emptyNodes = emptyNodes;
        }
    }
}

