/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionProcessingCounterMap;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPageReplacement;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.jetbrains.annotations.Nullable;

class CheckpointProgressImpl
implements CheckpointProgress {
    private final UUID id = UUID.randomUUID();
    private volatile long nextCheckpointNanos;
    private final AtomicReference<CheckpointState> state = new AtomicReference<CheckpointState>(CheckpointState.SCHEDULED);
    private final Map<CheckpointState, CompletableFuture<Void>> stateFutures = new ConcurrentHashMap<CheckpointState, CompletableFuture<Void>>();
    private volatile String reason;
    private volatile int currCheckpointPagesCnt;
    @Nullable
    private volatile Throwable failCause;
    private final AtomicInteger writtenPagesCntr = new AtomicInteger();
    private final AtomicInteger syncedPagesCntr = new AtomicInteger();
    private final AtomicInteger evictedPagesCntr = new AtomicInteger();
    @Nullable
    private volatile CheckpointDirtyPages pageToWrite;
    private final PartitionProcessingCounterMap processedPartitionMap = new PartitionProcessingCounterMap();
    private final CheckpointPageReplacement checkpointPageReplacement = new CheckpointPageReplacement();

    CheckpointProgressImpl(long delay) {
        this.nextCheckpointNanos(delay);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    public void reason(String reason) {
        this.reason = reason;
    }

    @Override
    public boolean inProgress() {
        return this.greaterOrEqualTo(CheckpointState.LOCK_RELEASED) && !this.greaterOrEqualTo(CheckpointState.FINISHED);
    }

    @Override
    public CompletableFuture<Void> futureFor(CheckpointState state) {
        CompletableFuture stateFut = this.stateFutures.computeIfAbsent(state, k -> new CompletableFuture());
        if (this.greaterOrEqualTo(state)) {
            CheckpointProgressImpl.completeFuture(stateFut, this.failCause);
        }
        return stateFut;
    }

    @Override
    public int currentCheckpointPagesCount() {
        return this.currCheckpointPagesCnt;
    }

    public void currentCheckpointPagesCount(int num) {
        this.currCheckpointPagesCnt = num;
    }

    public AtomicInteger writtenPagesCounter() {
        return this.writtenPagesCntr;
    }

    public AtomicInteger syncedPagesCounter() {
        return this.syncedPagesCntr;
    }

    public AtomicInteger evictedPagesCounter() {
        return this.evictedPagesCntr;
    }

    public long nextCheckpointNanos() {
        return this.nextCheckpointNanos;
    }

    public void nextCheckpointNanos(long delay) {
        assert (delay >= 0L) : delay;
        assert (delay <= TimeUnit.DAYS.toNanos(365L)) : delay;
        this.nextCheckpointNanos = System.nanoTime() + delay;
    }

    public void clearCounters() {
        this.initCounters(0);
    }

    public void initCounters(int checkpointPages) {
        this.currCheckpointPagesCnt = checkpointPages;
        this.writtenPagesCntr.set(0);
        this.syncedPagesCntr.set(0);
        this.evictedPagesCntr.set(0);
    }

    public void transitTo(CheckpointState newState) {
        CheckpointState state = this.state.get();
        if (state.ordinal() < newState.ordinal()) {
            this.state.compareAndSet(state, newState);
            this.doFinishFuturesWhichLessOrEqualTo(newState);
        }
    }

    public void fail(Throwable error) {
        this.failCause = error;
        this.transitTo(CheckpointState.FINISHED);
    }

    public boolean greaterOrEqualTo(CheckpointState expectedState) {
        return this.state.get().ordinal() >= expectedState.ordinal();
    }

    CheckpointState state() {
        return this.state.get();
    }

    private void doFinishFuturesWhichLessOrEqualTo(CheckpointState lastState) {
        for (CheckpointState old : CheckpointState.values()) {
            CheckpointProgressImpl.completeFuture(this.stateFutures.get((Object)old), this.failCause);
            if (old != lastState) continue;
            return;
        }
    }

    private static void completeFuture(@Nullable CompletableFuture<?> future, @Nullable Throwable throwable) {
        if (future != null && !future.isDone()) {
            if (throwable != null) {
                future.completeExceptionally(throwable);
            } else {
                future.complete(null);
            }
        }
    }

    @Override
    @Nullable
    public CheckpointDirtyPages pagesToWrite() {
        return this.pageToWrite;
    }

    void pagesToWrite(@Nullable CheckpointDirtyPages pageToWrite) {
        this.pageToWrite = pageToWrite;
    }

    public void blockPartitionDestruction(GroupPartitionId groupPartitionId) {
        this.processedPartitionMap.incrementPartitionProcessingCounter(groupPartitionId);
    }

    public void unblockPartitionDestruction(GroupPartitionId groupPartitionId) {
        this.processedPartitionMap.decrementPartitionProcessingCounter(groupPartitionId);
    }

    @Nullable
    public CompletableFuture<Void> getUnblockPartitionDestructionFuture(GroupPartitionId groupPartitionId) {
        return this.processedPartitionMap.getProcessedPartitionFuture(groupPartitionId);
    }

    void blockFsyncOnPageReplacement(FullPageId pageId) {
        this.checkpointPageReplacement.block(pageId);
    }

    void unblockFsyncOnPageReplacement(FullPageId pageId, @Nullable Throwable error) {
        this.checkpointPageReplacement.unblock(pageId, error);
    }

    CompletableFuture<Void> getUnblockFsyncOnPageReplacementFuture() {
        return this.checkpointPageReplacement.stopBlocking();
    }
}

