/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

final class CustomTypesConversion {
    static final CustomTypesConversion INSTANCE = new CustomTypesConversion(Commons.typeFactory());
    private final Map<Class<?>, Function<Expression, Expression>> castByInternalType = new HashMap();
    private final Map<String, Function<Expression, Expression>> castByTypeName = new HashMap<String, Function<Expression, Expression>>();

    private CustomTypesConversion(IgniteTypeFactory typeFactory) {
        Map<String, IgniteCustomTypeSpec> customTypeSpecs = typeFactory.getCustomTypeSpecs();
        for (IgniteCustomTypeSpec spec : customTypeSpecs.values()) {
            Function<Expression, Expression> castExpr = operand -> Expressions.call((Method)spec.castFunction(), (Expression[])new Expression[]{Expressions.convert_((Expression)operand, Object.class)});
            this.castByInternalType.put(spec.storageType(), castExpr);
            this.castByTypeName.put(spec.typeName(), castExpr);
        }
    }

    @Nullable
    Expression tryConvert(Expression operand, Type internalType) {
        Function<Expression, Expression> cast = this.castByInternalType.get((Class)internalType);
        if (cast == null) {
            return null;
        }
        return cast.apply(operand);
    }

    @Nullable
    Expression tryConvert(Expression operand, RelDataType targetType) {
        if (!(targetType instanceof IgniteCustomType)) {
            return null;
        }
        IgniteCustomType customType = (IgniteCustomType)targetType;
        Function<Expression, Expression> cast = this.castByTypeName.get(customType.getCustomTypeName());
        return cast.apply(operand);
    }
}

