/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.table.IgniteTables;

public class ClientSchemasGetRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteTables tables, SchemaVersions schemaVersions) {
        return ClientTableCommon.readTableAsync(in, tables).thenCompose(table -> {
            if (in.tryUnpackNil()) {
                out.packInt(1);
                return schemaVersions.schemaVersionAtCurrentTime(table.tableId()).thenAccept(version -> {
                    SchemaDescriptor schema = table.schemaView().schema(version.intValue());
                    ClientTableCommon.writeSchema(out, schema.version(), schema);
                });
            }
            int cnt = in.unpackInt();
            out.packInt(cnt);
            CompletableFuture[] schemaFutures = new CompletableFuture[cnt];
            for (int i = 0; i < cnt; ++i) {
                int schemaVer = in.unpackInt();
                schemaFutures[i] = table.schemaView().schemaAsync(schemaVer);
            }
            return CompletableFuture.allOf(schemaFutures).thenRun(() -> {
                for (CompletableFuture schemaFuture : schemaFutures) {
                    SchemaDescriptor schema = (SchemaDescriptor)schemaFuture.join();
                    ClientTableCommon.writeSchema(out, schema.version(), schema);
                }
            });
        });
    }
}

