/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import java.util.UUID;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.message.ClusterNodeMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ClusterNodeMessageDeserializer
implements MessageDeserializer<ClusterNodeMessage> {
    private final ClusterNodeMessageBuilder msg;

    ClusterNodeMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterNodeMessage();
    }

    public Class<ClusterNodeMessage> klass() {
        return ClusterNodeMessage.class;
    }

    public ClusterNodeMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readString("host");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.host((String)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.id((UUID)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("name");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.name((String)tmp);
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("port");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.port(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterNodeMessage.class);
    }
}

