/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv.io;

import java.util.UUID;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainKey;

public interface VersionChainIo {
    public static final int ROW_ID_MSB_OFFSET = 0;
    public static final int ROW_ID_LSB_OFFSET = 8;
    public static final int TX_ID_MSB_OFFSET = 16;
    public static final int TX_ID_LSB_OFFSET = 24;
    public static final int COMMIT_TABLE_ID = 32;
    public static final int COMMIT_PARTITION_ID_OFFSET = 36;
    public static final int HEAD_LINK_OFFSET = 38;
    public static final int NEXT_LINK_OFFSET = 44;
    public static final int SIZE_IN_BYTES = 50;

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<VersionChainKey> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory((long)srcPageAddr, (long)srcOffset, (long)dstPageAddr, (long)dstOffset, (long)50L);
    }

    default public void storeByOffset(long pageAddr, int off, VersionChainKey rowKey) {
        if (!1.$assertionsDisabled && !(rowKey instanceof VersionChain)) {
            throw new AssertionError();
        }
        VersionChain row = (VersionChain)rowKey;
        RowId rowId = row.rowId();
        PageUtils.putLong((long)pageAddr, (int)(off + 0), (long)rowId.mostSignificantBits());
        PageUtils.putLong((long)pageAddr, (int)(off + 8), (long)rowId.leastSignificantBits());
        UUID txId = row.transactionId();
        Integer commitTableId = row.commitTableId();
        int commitPartitionId = row.commitPartitionId();
        if (txId == null) {
            if (!1.$assertionsDisabled && commitTableId != null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && commitPartitionId != -1) {
                throw new AssertionError();
            }
            PageUtils.putLong((long)pageAddr, (int)(off + 16), (long)0L);
            PageUtils.putLong((long)pageAddr, (int)(off + 24), (long)0L);
        } else {
            if (!1.$assertionsDisabled && commitTableId == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && commitPartitionId < 0) {
                throw new AssertionError();
            }
            PageUtils.putLong((long)pageAddr, (int)(off + 16), (long)txId.getMostSignificantBits());
            PageUtils.putLong((long)pageAddr, (int)(off + 24), (long)txId.getLeastSignificantBits());
            PageUtils.putInt((long)pageAddr, (int)(off + 32), (int)commitTableId);
            PageUtils.putShort((long)pageAddr, (int)(off + 36), (short)((short)commitPartitionId));
        }
        PartitionlessLinks.writePartitionless((long)(pageAddr + (long)off + 38L), (long)row.headLink());
        PartitionlessLinks.writePartitionless((long)(pageAddr + (long)off + 44L), (long)row.nextLink());
    }

    default public int compare(long pageAddr, int idx, VersionChainKey versionChain) {
        RowId rowId = versionChain.rowId();
        int offset = this.offset(idx);
        int cmp = Long.compare(PageUtils.getLong((long)pageAddr, (int)(offset + 0)), rowId.mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(PageUtils.getLong((long)pageAddr, (int)(offset + 8)), rowId.leastSignificantBits());
    }

    default public VersionChain getRow(long pageAddr, int idx, int partitionId) {
        int offset = this.offset(idx);
        long rowIdMsb = PageUtils.getLong((long)pageAddr, (int)(offset + 0));
        long rowIdLsb = PageUtils.getLong((long)pageAddr, (int)(offset + 8));
        RowId rowId = new RowId(partitionId, rowIdMsb, rowIdLsb);
        long txIdMsb = PageUtils.getLong((long)pageAddr, (int)(offset + 16));
        long txIdLsb = PageUtils.getLong((long)pageAddr, (int)(offset + 24));
        UUID txId = txIdMsb == 0L && txIdLsb == 0L ? null : new UUID(txIdMsb, txIdLsb);
        long headLink = PartitionlessLinks.readPartitionless((int)partitionId, (long)pageAddr, (int)(offset + 38));
        long nextLink = PartitionlessLinks.readPartitionless((int)partitionId, (long)pageAddr, (int)(offset + 44));
        if (txId != null) {
            int commitTableId = PageUtils.getInt((long)pageAddr, (int)(offset + 32));
            int commitPartitionId = PageUtils.getShort((long)pageAddr, (int)(offset + 36)) & 0xFFFF;
            return VersionChain.createUncommitted(rowId, txId, commitTableId, commitPartitionId, headLink, nextLink);
        }
        return VersionChain.createCommitted(rowId, headLink, nextLink);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

