/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.topology;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.TopologyApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ClusterNode;

@Singleton
public class PhysicalTopologyCall
implements Call<UrlCallInput, List<ClusterNode>> {
    private final ApiClientFactory clientFactory;

    public PhysicalTopologyCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<List<ClusterNode>> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            return DefaultCallOutput.success(this.fetchPhysicalTopology(clusterUrl));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private List<ClusterNode> fetchPhysicalTopology(String url) throws ApiException {
        return new TopologyApi(this.clientFactory.getClient(url)).physical();
    }
}

