/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.rules.ImmutableMinusToAntiJoinRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class MinusToAntiJoinRule
extends RelRule<Config>
implements TransformationRule {
    protected MinusToAntiJoinRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Minus minus = (Minus)call.rel(0);
        if (minus.all) {
            return;
        }
        List<RelNode> inputs = minus.getInputs();
        if (inputs.size() < 2) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RelDataType leastRowType = minus.getRowType();
        RelNode current = inputs.get(0);
        relBuilder.push(current);
        for (int i = 1; i < inputs.size(); ++i) {
            RelNode next = inputs.get(i);
            int fieldCount = current.getRowType().getFieldCount();
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            for (int j = 0; j < fieldCount; ++j) {
                RelDataType leftFieldType = current.getRowType().getFieldList().get(j).getType();
                RelDataType rightFieldType = next.getRowType().getFieldList().get(j).getType();
                RelDataType leastFieldType = leastRowType.getFieldList().get(j).getType();
                conditions.add(relBuilder.isNotDistinctFrom(rexBuilder.makeCast(leastFieldType, rexBuilder.makeInputRef(leftFieldType, j)), rexBuilder.makeCast(leastFieldType, rexBuilder.makeInputRef(rightFieldType, j + fieldCount))));
            }
            RexNode condition = RexUtil.composeConjunction(rexBuilder, conditions);
            relBuilder.push(next).join(JoinRelType.ANTI, condition);
            current = relBuilder.peek();
        }
        relBuilder.distinct().convert(leastRowType, true);
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableMinusToAntiJoinRule.Config.of().withOperandFor(LogicalMinus.class);

        @Override
        default public MinusToAntiJoinRule toRule() {
            return new MinusToAntiJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Minus> minusClass) {
            return this.withOperandSupplier(b -> b.operand(minusClass).anyInputs()).as(Config.class);
        }
    }
}

