/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.NodeWithAttributesSerializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class LogicalTopologySetSerializer
extends VersionedSerializer<Set<NodeWithAttributes>> {
    public static final LogicalTopologySetSerializer INSTANCE = new LogicalTopologySetSerializer();
    private final NodeWithAttributesSerializer nodeWithAttributesSerializer = NodeWithAttributesSerializer.INSTANCE;

    protected void writeExternalData(Set<NodeWithAttributes> topology, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)topology.size());
        for (NodeWithAttributes node : topology) {
            this.nodeWithAttributesSerializer.writeExternal(node, out);
        }
    }

    protected Set<NodeWithAttributes> readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashSet<NodeWithAttributes> topology = new HashSet<NodeWithAttributes>(IgniteUtils.capacity((int)length));
        for (int i = 0; i < length; ++i) {
            topology.add((NodeWithAttributes)this.nodeWithAttributesSerializer.readExternal(in));
        }
        return topology;
    }

    public static byte[] serialize(Set<NodeWithAttributes> set) {
        return VersionedSerialization.toBytes(set, (VersionedSerializer)INSTANCE);
    }

    public static Set<NodeWithAttributes> deserialize(byte[] bytes) {
        return (Set)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)INSTANCE);
    }
}

