/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite3.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class ValidationManager {
    protected final ClusterStateStorageManager storageManager;
    protected final LogicalTopology logicalTopology;

    public ValidationManager(ClusterStateStorageManager storageManager, LogicalTopology logicalTopology) {
        this.storageManager = storageManager;
        this.logicalTopology = logicalTopology;
    }

    static ValidationResult validateState(ClusterState state, InternalClusterNode node, ClusterState nodeState) {
        if (!state.cmgNodes().equals(nodeState.cmgNodes())) {
            return ValidationResult.errorResult(String.format("CMG node names do not match. CMG nodes: %s, nodes stored in CMG: %s", nodeState.cmgNodes(), state.cmgNodes()));
        }
        if (!state.metaStorageNodes().equals(nodeState.metaStorageNodes())) {
            return ValidationResult.errorResult(String.format("MetaStorage node names do not match. MetaStorage nodes: %s, nodes stored in CMG: %s", nodeState.metaStorageNodes(), state.metaStorageNodes()));
        }
        if (!state.igniteVersion().equals(nodeState.igniteVersion())) {
            return ValidationResult.errorResult(String.format("Ignite versions do not match. Version: %s, version stored in CMG: %s", nodeState.igniteVersion(), state.igniteVersion()));
        }
        if (!state.clusterTag().clusterName().equals(nodeState.clusterTag().clusterName())) {
            return ValidationResult.errorResult(String.format("Cluster names do not match. Cluster name: %s, cluster name stored in CMG: %s", nodeState.clusterTag().clusterName(), state.clusterTag().clusterName()));
        }
        return ValidationResult.successfulResult();
    }

    protected ValidationResult validateNode(@Nullable ClusterState state, LogicalNode node, IgniteProductVersion version, ClusterTag clusterTag) {
        if (this.isNodeValidated(node)) {
            return ValidationResult.successfulResult();
        }
        if (state == null) {
            return ValidationResult.errorResult("Cluster has not been initialized yet");
        }
        if (!state.clusterTag().equals(clusterTag)) {
            return ValidationResult.errorResult(String.format("Cluster tags do not match. Cluster tag: %s, cluster tag stored in CMG: %s", clusterTag, state.clusterTag()));
        }
        if (!this.isColocationEnabledMatched(ValidationManager.isColocationEnabled(node))) {
            return ValidationResult.configErrorResult(String.format("Colocation enabled mode does not match. Joining node colocation mode is: %s, cluster colocation mode is: %s", ValidationManager.isColocationEnabled(node), ValidationManager.isColocationEnabled(this.logicalTopology.getLogicalTopology().nodes().iterator().next())));
        }
        this.putValidatedNode(node);
        return ValidationResult.successfulResult();
    }

    private static boolean isColocationEnabled(LogicalNode node) {
        return Boolean.parseBoolean(node.systemAttributes().get("IGNITE_ZONE_BASED_REPLICATION"));
    }

    private boolean isColocationEnabledMatched(boolean joiningNodeColocationEnabled) {
        Set<LogicalNode> logicalTopologyNodes = this.logicalTopology.getLogicalTopology().nodes();
        return logicalTopologyNodes.isEmpty() || ValidationManager.isColocationEnabled(logicalTopologyNodes.iterator().next()) == joiningNodeColocationEnabled;
    }

    boolean isNodeValidated(LogicalNode node) {
        return this.storageManager.isNodeValidated(node) || this.logicalTopology.isNodeInLogicalTopology(node);
    }

    void putValidatedNode(LogicalNode node) {
        this.storageManager.putValidatedNode(node);
        this.logicalTopology.onNodeValidated(node);
    }

    void removeValidatedNodes(Collection<LogicalNode> nodes) {
        Set validatedNodeIds = this.storageManager.getValidatedNodes().stream().map(InternalClusterNode::id).collect(Collectors.toSet());
        nodes.stream().filter(node -> validatedNodeIds.contains(node.id())).sorted(Comparator.comparing(InternalClusterNode::id)).forEach(node -> {
            this.storageManager.removeValidatedNode((LogicalNode)node);
            this.logicalTopology.onNodeInvalidated((LogicalNode)node);
        });
    }

    protected ValidationResult completeValidation(LogicalNode node) {
        this.storageManager.getValidatedNodes().stream().filter(n -> n.name().equals(node.name()) && !n.id().equals(node.id())).sorted(Comparator.comparing(InternalClusterNode::id)).forEach(nodeVersion -> {
            this.storageManager.removeValidatedNode((LogicalNode)nodeVersion);
            this.logicalTopology.onNodeInvalidated((LogicalNode)nodeVersion);
        });
        this.storageManager.removeValidatedNode(node);
        return ValidationResult.successfulResult();
    }
}

