/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ignite3.internal.deployunit.DisposableDeploymentUnit;

class JobClassLoaderImpl
extends URLClassLoader {
    private static final Pattern SYSTEM_PACKAGES_PATTERN = Pattern.compile("^(java|x|javax|org\\.apache\\.ignite)\\..*$");
    private final List<DisposableDeploymentUnit> units;
    private final ClassLoader parent;

    JobClassLoaderImpl(List<DisposableDeploymentUnit> units, URL[] urls, ClassLoader parent) {
        super("compute-job", urls, parent);
        this.units = units;
        this.parent = parent;
    }

    public List<DisposableDeploymentUnit> units() {
        return this.units;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean isSystem = SYSTEM_PACKAGES_PATTERN.matcher(name).find();
        if (isSystem) {
            try {
                return this.parent.loadClass(name);
            }
            catch (ClassNotFoundException exception) {
                return this.loadClassFromClasspath(name, resolve);
            }
        }
        try {
            return this.loadClassFromClasspath(name, resolve);
        }
        catch (ClassNotFoundException exception) {
            return this.parent.loadClass(name);
        }
    }

    private Class<?> loadClassFromClasspath(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            Class<?> clazz = this.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return loadedClass;
    }

    public String toString() {
        return "JobClassLoader{classpath=" + Arrays.toString(this.getURLs()) + "}";
    }
}

