/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util.format;

enum DateTimeTemplateField {
    YYYY("Year", FieldKind.YEAR, 4),
    YYY("Year", FieldKind.YEAR, 3),
    YY("Year", FieldKind.YEAR, 2),
    Y("Year", FieldKind.YEAR, 1),
    RRRR("Year", FieldKind.ROUNDED_YEAR, 4),
    RR("Year", FieldKind.ROUNDED_YEAR, 2),
    MM("MonthOfYear", FieldKind.MONTH, 2),
    DD("DayOfMonth", FieldKind.DAY_OF_MONTH, 2),
    DDD("DayOfYear", FieldKind.DAY_OF_YEAR, 3),
    HH("HourAmPm", FieldKind.HOUR_12, 2),
    HH12("HourAmPm", FieldKind.HOUR_12, 2),
    HH24("HourOfDay", FieldKind.HOUR_24, 2),
    MI("MinuteOfHour", FieldKind.MINUTE, 2),
    SS("SecondOfMinute", FieldKind.SECOND_OF_MINUTE, 2),
    SSSSS("SecondOfDay", FieldKind.SECOND_OF_DAY, 5),
    FF1("Fraction", FieldKind.FRACTION, 1),
    FF2("Fraction", FieldKind.FRACTION, 2),
    FF3("Fraction", FieldKind.FRACTION, 3),
    FF4("Fraction", FieldKind.FRACTION, 4),
    FF5("Fraction", FieldKind.FRACTION, 5),
    FF6("Fraction", FieldKind.FRACTION, 6),
    FF7("Fraction", FieldKind.FRACTION, 7),
    FF8("Fraction", FieldKind.FRACTION, 8),
    FF9("Fraction", FieldKind.FRACTION, 9),
    PM("Pm", FieldKind.AM_PM, "P.M."),
    AM("Am", FieldKind.AM_PM, "A.M."),
    TZH("TimeZone Hour", FieldKind.TIMEZONE, 2),
    TZM("TimeZone MinuteOfHour", FieldKind.TIMEZONE, 2);

    private final String displayName;
    private final FieldKind kind;
    private final String pattern;
    private final int maxDigits;

    private DateTimeTemplateField(String displayName, FieldKind kind, int maxDigits) {
        this.displayName = displayName;
        this.kind = kind;
        this.pattern = this.name();
        this.maxDigits = maxDigits;
    }

    private DateTimeTemplateField(String displayName, FieldKind kind, String pattern) {
        this.displayName = displayName;
        this.kind = kind;
        this.pattern = pattern;
        this.maxDigits = -1;
    }

    String displayName() {
        return this.displayName;
    }

    String pattern() {
        return this.pattern;
    }

    FieldKind kind() {
        return this.kind;
    }

    int maxDigits() {
        if (this.maxDigits == -1) {
            throw new IllegalStateException(this + " has no digits");
        }
        return this.maxDigits;
    }

    static enum FieldKind {
        YEAR,
        ROUNDED_YEAR,
        MONTH,
        DAY_OF_MONTH,
        DAY_OF_YEAR,
        HOUR_12,
        HOUR_24,
        MINUTE,
        SECOND_OF_MINUTE,
        SECOND_OF_DAY,
        FRACTION,
        AM_PM,
        TIMEZONE;

    }
}

